/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.circle;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.ui.dialog.ProgressObserver;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.tiny.circle.AGPControl;
import com.owon.vds.tiny.circle.IWFCalRoutine2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CalRunner2
implements Logable {
    private WaveFormManager wfm;
    private ControlManager cm;
    private ProgressObserver po;
    private VoltageProvider vp;
    private Runnable finishedJob;
    private CoreControl cc;
    private int maximum;
    private int progress;
    private PropertyChangeSupport ict;
    private ArgCreator ac;
    private AGPControl agp;
    private int vbidx;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equalsIgnoreCase("NewDataReceive")) {
                CalRunner2.this.call();
            }
        }
    };
    private boolean isOver;
    private List<IWFCalRoutine2> wfrlist;
    private boolean isCancel;
    private Runnable afterCancelJob;
    private int vbnum;

    public CalRunner2(ArgCreator argCreator, ProgressObserver progressObserver, Runnable runnable, PropertyChangeSupport propertyChangeSupport, AGPControl aGPControl) {
        this.ac = argCreator;
        this.po = progressObserver;
        this.ict = propertyChangeSupport;
        this.agp = aGPControl;
        this.finishedJob = runnable;
        DataHouse dataHouse = Platform.getDataHouse();
        this.cm = dataHouse.controlManager;
        this.cc = dataHouse.controlManager.getCoreControl();
        this.wfm = dataHouse.getWaveFormManager();
        this.vp = this.cc.getVoltageProvider();
    }

    protected abstract int computeMaximum(int var1, int var2);

    protected abstract IWFCalRoutine2 createWFCalRoutine(int var1, WaveForm var2, ArgCreator var3);

    public void getReady() {
        this.logln("parallel");
        this.vbnum = this.vp.getVoltageNumber();
        int n = this.cc.getWaveFormInfoControl().getLowMachineChannels();
        this.maximum = this.computeMaximum(n, this.vbnum);
        this.po.setMaximum(this.maximum);
        this.cc.getTimeControl().c_setTimebase_HorTrgPos(this.cc.getMachineInfo().getTimebaseIndex("1ms"), 0);
        this.wfrlist = new ArrayList<IWFCalRoutine2>(n);
        ON_WF_Iterator oN_WF_Iterator = this.wfm.on_wf_Iterator();
        this.vbidx = 0;
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            IWFCalRoutine2 iWFCalRoutine2 = this.createWFCalRoutine(this.vbnum, waveForm, this.ac);
            iWFCalRoutine2.getReady();
            iWFCalRoutine2.forVB(this.vbidx);
            this.wfrlist.add(iWFCalRoutine2);
        }
        this.agp.genWFwithVB(this.vbidx);
        this.progress = 0;
        this.isOver = false;
        this.isCancel = false;
        this.afterCancelJob = null;
        this.ict.addPropertyChangeListener(this.pcl);
    }

    private boolean isExit() {
        return this.cm.isExit();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void cancel(Runnable runnable) {
        this.isCancel = true;
        this.afterCancelJob = runnable;
    }

    private void call() {
        if (this.isExit() || this.isOver) {
            return;
        }
        if (this.progress < this.maximum && !this.isCancel) {
            IWFCalRoutine2 iWFCalRoutine2;
            Iterator<IWFCalRoutine2> iterator = this.wfrlist.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (this.isExit()) {
                    return;
                }
                iWFCalRoutine2 = iterator.next();
                if (iWFCalRoutine2.getRoutCalType() < 0) continue;
                bl = false;
                if (this.isCancel) {
                    this.jobOnFinished();
                    break;
                }
                int n = iWFCalRoutine2.routOut();
                if (n <= 0) continue;
                this.progress += n;
                this.po.increaseValue(n);
            }
            if (bl) {
                ++this.vbidx;
                if (this.vbidx < this.vbnum) {
                    iterator = this.wfrlist.iterator();
                    while (iterator.hasNext()) {
                        if (this.isExit()) {
                            return;
                        }
                        iWFCalRoutine2 = iterator.next();
                        iWFCalRoutine2.forVB(this.vbidx);
                    }
                    this.agp.genWFwithVB(this.vbidx);
                }
            }
            this.logln("...roll...");
        } else {
            this.jobOnFinished();
        }
        if (this.isCancel && this.afterCancelJob != null) {
            this.afterCancelJob.run();
        }
    }

    private void jobOnFinished() {
        this.isOver = true;
        this.ict.removePropertyChangeListener(this.pcl);
        if (this.finishedJob != null) {
            this.finishedJob.run();
        }
    }

    @Override
    public void log(Object object) {
        System.err.print(object);
    }

    @Override
    public void logln(Object object) {
        System.err.println(object);
    }
}

