/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.calibration;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.vds.calibration.ChannelSets;

public class SelCalSetting {
    public int persistenceIndex;
    public ChannelSets[] css;
    public int triggerMode;
    public int triggerChannel;
    public AbsTrigger trigger;
    public boolean xymode;
    public boolean measureon;
    public int sampleIndex;
    public int timebase;
    public int htp;
    public int deepIndex;

    public SelCalSetting(ControlManager controlManager) {
        TriggerControl triggerControl = controlManager.getTriggerControl();
        this.triggerMode = triggerControl.getChannelMode();
        this.triggerChannel = triggerControl.getSingleTrgChannel();
        this.trigger = triggerControl.getSingleTriggerSet().getTrigger();
        this.persistenceIndex = controlManager.displayControl.getPersistenceIndex();
        WaveFormInfoControl waveFormInfoControl = controlManager.getWaveFormInfoControl();
        this.css = waveFormInfoControl.getAllChannelSets();
        this.xymode = controlManager.displayControl.isXYModeOn();
        this.measureon = controlManager.getMeasureManager().ison();
        this.sampleIndex = controlManager.getSampleControl().getModelIdx();
        this.timebase = controlManager.getTimeControl().getTimebaseIdx();
        this.htp = controlManager.getTimeControl().getHorizontalTriggerPosition();
        this.deepIndex = controlManager.getDeepMemoryControl().getDeepIdx();
        this.logInfo();
    }

    public void logInfo() {
        System.out.println("persistenceIndex: " + this.persistenceIndex);
        int n = this.css.length;
        for (int i = 0; i < n; ++i) {
            System.out.print(this.css[i]);
        }
        System.out.println("xymode: " + this.xymode);
        System.out.println("measureon: " + this.measureon);
        System.out.println("sampleIndex: " + this.sampleIndex);
        System.out.println("timebase: " + this.timebase);
        System.out.println("htp: " + this.htp);
        System.out.println("deepIndex: " + this.deepIndex);
    }
}

