/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.calibration;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.ui.dialog.ProgressObserver;
import com.owon.vds.calibration.IWFCalRoutine;
import com.owon.vds.calibration.stuff.ArgCreator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CalibrationRunner
implements Logable {
    public static final int ZEROSTEPCAL_LIMIT = 5;
    public static int ZEROSTEPCAL_BASE = 110;
    private WaveFormManager wfm;
    private ControlManager cm;
    private ProgressObserver po;
    private VoltageProvider vp;
    private Runnable finishedJob;
    private CoreControl cc;
    private int maximum;
    private int progress;
    private PropertyChangeSupport ict;
    private ArgCreator ac;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equalsIgnoreCase("NewDataReceive")) {
                CalibrationRunner.this.call();
            }
        }
    };
    private boolean isOver;
    private List<IWFCalRoutine> wfrlist;
    private boolean isCancel;
    private Runnable afterCancelJob;

    public CalibrationRunner(ArgCreator argCreator, ProgressObserver progressObserver, Runnable runnable, PropertyChangeSupport propertyChangeSupport) {
        this.ac = argCreator;
        this.po = progressObserver;
        this.ict = propertyChangeSupport;
        this.finishedJob = runnable;
        DataHouse dataHouse = Platform.getDataHouse();
        this.cm = dataHouse.controlManager;
        this.cc = dataHouse.controlManager.getCoreControl();
        this.wfm = dataHouse.getWaveFormManager();
        this.vp = this.cc.getVoltageProvider();
    }

    protected abstract int computeMaximum(int var1, int var2);

    protected abstract IWFCalRoutine createWFCalRoutine(int var1, WaveForm var2, ArgCreator var3);

    public void getReady() {
        this.logln("parallel");
        int n = this.vp.getVoltageNumber();
        int n2 = this.cc.getWaveFormInfoControl().getLowMachineChannels();
        this.maximum = this.computeMaximum(n2, n);
        this.po.setMaximum(this.maximum);
        this.cc.getTimeControl().c_setTimebase_HorTrgPos(this.cc.getMachineInfo().getTimebaseIndex("1ms"), 0);
        this.wfrlist = new ArrayList<IWFCalRoutine>(n2);
        ON_WF_Iterator oN_WF_Iterator = this.wfm.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            IWFCalRoutine iWFCalRoutine = this.createWFCalRoutine(n, waveForm, this.ac);
            iWFCalRoutine.getReady();
            this.wfrlist.add(iWFCalRoutine);
        }
        this.progress = 0;
        this.isOver = false;
        this.isCancel = false;
        this.afterCancelJob = null;
        this.ict.addPropertyChangeListener(this.pcl);
    }

    private boolean isExit() {
        return this.cm.isExit();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void cancel(Runnable runnable) {
        this.isCancel = true;
        this.afterCancelJob = runnable;
    }

    private void call() {
        if (this.isExit() || this.isOver) {
            return;
        }
        if (this.progress < this.maximum && !this.isCancel) {
            Iterator<IWFCalRoutine> iterator = this.wfrlist.iterator();
            while (iterator.hasNext()) {
                if (this.isExit()) {
                    return;
                }
                IWFCalRoutine iWFCalRoutine = iterator.next();
                if (iWFCalRoutine.getRoutCalType() < 0) continue;
                if (this.isCancel) {
                    this.jobOnFinished();
                    break;
                }
                int n = iWFCalRoutine.routOut();
                if (n <= 0) continue;
                this.progress += n;
                this.po.increaseValue(n);
            }
            this.logln("...roll...");
        } else {
            this.jobOnFinished();
        }
        if (this.isCancel && this.afterCancelJob != null) {
            this.afterCancelJob.run();
        }
    }

    private void jobOnFinished() {
        this.isOver = true;
        this.ict.removePropertyChangeListener(this.pcl);
        if (this.finishedJob != null) {
            this.finishedJob.run();
        }
    }

    @Override
    public void log(Object object) {
        System.err.print(object);
    }

    @Override
    public void logln(Object object) {
        System.err.println(object);
    }
}

