/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.calibration;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.source.comm.InterCommTiny;
import com.owon.uppersoft.vds.ui.dialog.ProgressObserver;
import com.owon.vds.calibration.AutomaticWorkManager;
import com.owon.vds.calibration.BaselineCal;
import com.owon.vds.calibration.CalibrationRunner;
import com.owon.vds.calibration.IWFCalRoutine;
import com.owon.vds.calibration.stuff.ArgCreator;
import java.beans.PropertyChangeSupport;

public class BaselineCalManager
extends AutomaticWorkManager {
    private CalibrationRunner baselineCalRunner;

    public BaselineCalManager(ControlManager controlManager, InterCommTiny interCommTiny, DataHouse dataHouse) {
        super(controlManager, interCommTiny, dataHouse);
    }

    @Override
    public void cancel(Runnable runnable) {
        if (this.baselineCalRunner != null) {
            this.baselineCalRunner.cancel(runnable);
            this.baselineCalRunner = null;
        }
    }

    @Override
    public void onFinished(ProgressObserver progressObserver) {
        super.onFinished(progressObserver);
        progressObserver.shutdown();
    }

    @Override
    protected void getReadyForCalibration(ProgressObserver progressObserver, ArgCreator argCreator, PropertyChangeSupport propertyChangeSupport, Runnable runnable) {
        this.baselineCalRunner = new CalibrationRunner(argCreator, progressObserver, runnable, propertyChangeSupport){

            @Override
            protected int computeMaximum(int n, int n2) {
                return n2 * n * 2;
            }

            @Override
            protected IWFCalRoutine createWFCalRoutine(int n, WaveForm waveForm, ArgCreator argCreator) {
                return new BaselineCal(waveForm, n, argCreator);
            }
        };
        this.baselineCalRunner.getReady();
    }
}

