/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.calibration;

import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.vds.calibration.CalibrationRunner;
import com.owon.vds.calibration.IWFCalRoutine;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.calibration.stuff.BaselineArg;
import com.owon.vds.calibration.stuff.CalculatUtil;
import com.owon.vds.tiny.firm.pref.model.ArgType;
import java.nio.ByteBuffer;

public class BaselineCal
implements Logable,
IWFCalRoutine {
    private WaveForm wf;
    private int chl;
    private int vbnum;
    private ArgCreator ac;
    private BaselineArg arg;

    public BaselineCal(WaveForm waveForm, int n, ArgCreator argCreator) {
        this.wf = waveForm;
        this.chl = waveForm.getChannelNumber();
        this.vbnum = n;
        this.ac = argCreator;
    }

    @Override
    public void getReady() {
        this.initNextZeroCompensation(0);
    }

    @Override
    public int routOut() {
        ByteBuffer byteBuffer = this.wf.getADC_Buffer();
        double d = CalculatUtil.computeAverage(byteBuffer);
        int n = this.rout(d);
        this.logln("result[" + this.chl + "] = " + n);
        return n;
    }

    @Override
    public int getRoutCalType() {
        if (this.arg != null) {
            return this.arg.id;
        }
        return -1;
    }

    private void initNextZeroCompensation(int n) {
        if (n == 0) {
            this.wf.setZeroYLoc(0, true, false);
        }
        this.arg = this.ac.createBaselineArg(this.chl, n, ArgType.Compensation);
        this.wf.setVoltBaseIndex(n, false);
    }

    private void initNextZeroAmplitude(int n) {
        if (n == 0) {
            this.wf.setZeroYLoc(CalibrationRunner.ZEROSTEPCAL_BASE, true, false);
        }
        this.arg = this.ac.createBaselineArg(this.chl, n, ArgType.Step);
        this.wf.setVoltBaseIndex(n, false);
    }

    private int rout(double d) {
        this.logln("rout[" + this.chl + "] avg = " + d);
        if (this.arg != null) {
            this.logln(this.arg);
        }
        if (this.arg.id == ArgType.Compensation.ordinal()) {
            int n = 0;
            if (this.arg.isAcceptable(n, d)) {
                if (!this.arg.increaseFitTimes()) {
                    return 0;
                }
                this.nextZeroCompensation();
                return 1;
            }
            if (this.arg.isTriesEnough()) {
                this.logln("too long time to cal, break");
                this.nextZeroCompensation();
                return 1;
            }
            this.arg.resetFitTimes();
            this.argTuneAgain(d, n);
            return 0;
        }
        if (this.arg.id == ArgType.Step.ordinal()) {
            int n = CalibrationRunner.ZEROSTEPCAL_BASE;
            if (this.arg.isAcceptable(n, d)) {
                if (!this.arg.increaseFitTimes()) {
                    return 0;
                }
                this.nextZeroAmplitude();
                return 1;
            }
            if (this.arg.isTriesEnough()) {
                this.logln("too long time to cal, break");
                this.nextZeroAmplitude();
                return 1;
            }
            this.arg.resetFitTimes();
            this.argTuneAgain(d, n);
            return 0;
        }
        return -1;
    }

    private void nextZeroAmplitude() {
        int n = this.arg.vb + 1;
        if (n >= this.vbnum) {
            this.arg = null;
        } else {
            this.initNextZeroAmplitude(n);
        }
    }

    private void nextZeroCompensation() {
        this.arg.onFinishThisCompensation();
        int n = this.arg.vb + 1;
        if (n >= this.vbnum) {
            this.initNextZeroAmplitude(0);
        } else {
            this.initNextZeroCompensation(n);
        }
    }

    private void argTuneAgain(double d, int n) {
        double d2 = d - (double)n;
        this.arg.stepCrease(d2, this.arg.vb);
        this.wf.setZeroYLoc(n, true, false);
    }

    @Override
    public void log(Object object) {
        System.err.print(object);
    }

    @Override
    public void logln(Object object) {
        System.err.println(object);
    }
}

