/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.calibration;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.SampleControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.machine.MachineInfo;
import com.owon.uppersoft.vds.source.comm.InterCommTiny;
import com.owon.uppersoft.vds.source.comm.Submitor2;
import com.owon.uppersoft.vds.ui.dialog.ProgressObserver;
import com.owon.vds.calibration.SelCalSetting;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.tiny.firm.pref.PrefControl;
import java.beans.PropertyChangeSupport;

public abstract class AutomaticWorkManager {
    protected ControlManager cm;
    private InterCommTiny ict;
    protected DataHouse dh;
    private SelCalSetting scs;
    private PrefControl pc;

    public AutomaticWorkManager(ControlManager controlManager, InterCommTiny interCommTiny, DataHouse dataHouse) {
        this.cm = controlManager;
        this.ict = interCommTiny;
        this.dh = dataHouse;
    }

    public void getReady(final ProgressObserver progressObserver, ArgCreator argCreator, PrefControl prefControl) {
        this.pc = prefControl;
        this.scs = this.preSelCalSetting();
        this.getReadyForCalibration(progressObserver, argCreator, this.ict.getDataReceiveBroadcast(), new Runnable(){

            @Override
            public void run() {
                AutomaticWorkManager.this.onFinished(progressObserver);
            }
        });
    }

    protected abstract void getReadyForCalibration(ProgressObserver var1, ArgCreator var2, PropertyChangeSupport var3, Runnable var4);

    public abstract void cancel(Runnable var1);

    public void onFinished(ProgressObserver progressObserver) {
        if (this.cm.isExit()) {
            return;
        }
        Submitor2 submitor2 = this.ict.reinitSubmitor2();
        this.pc.save2DevicePart();
        this.resumeSelCalSetting(this.scs);
        this.cm.initDetail(submitor2);
        submitor2.apply();
        this.dh.getWaveFormManager().resumeDraw();
        this.dh.getControlApps().getOperateBlocker().kickThrough();
    }

    private void resumeSelCalSetting(SelCalSetting selCalSetting) {
        this.dh.getPersistentDisplay().fadeThdOn_Off_UI(selCalSetting.persistenceIndex);
        this.cm.getWaveFormInfoControl().customizeChannelCouplingNInverse(selCalSetting.css);
        this.cm.displayControl.setXYMode(selCalSetting.xymode);
        this.cm.getMeasureManager().setMeasureOn(selCalSetting.measureon);
        this.cm.getSampleControl().c_setModelIdx(selCalSetting.sampleIndex);
        this.cm.getTimeControl().c_setTimebase_HorTrgPos(selCalSetting.timebase, selCalSetting.htp);
        this.cm.getDeepMemoryControl().c_setDeepIdx(selCalSetting.deepIndex);
        TriggerControl triggerControl = this.cm.getTriggerControl();
        triggerControl.setChannelMode(selCalSetting.triggerMode);
        triggerControl.setSingleChannel(selCalSetting.triggerChannel);
        triggerControl.getSingleTriggerSet().setTrigger(selCalSetting.trigger);
        triggerControl.doSubmit();
        MainWindow mainWindow = Platform.getMainWindow();
        mainWindow.getToolPane().getTrgInfoPane().updateInfos(triggerControl);
    }

    protected SelCalSetting preSelCalSetting() {
        SelCalSetting selCalSetting = new SelCalSetting(this.cm);
        this.dh.getPersistentDisplay().fadeThdOn_Off_UI(0);
        this.presetChannels();
        this.cm.displayControl.setXYMode(false);
        this.cm.getMeasureManager().setMeasureOn(false);
        this.cm.getSampleControl().c_setModelIdx(SampleControl.Sample_Sampling);
        MachineInfo machineInfo = this.cm.getCoreControl().getMachineInfo();
        this.cm.getTimeControl().c_setTimebase_HorTrgPos(machineInfo.getTimebaseIndex("1us"), 0);
        this.cm.getDeepMemoryControl().c_setDeepIdx(0);
        TriggerControl triggerControl = this.cm.getTriggerControl();
        triggerControl.setChannelMode(0);
        triggerControl.setSingleChannel(this.cm.getAllChannelsNumber());
        triggerControl.doSubmit();
        MainWindow mainWindow = Platform.getMainWindow();
        mainWindow.getToolPane().getTrgInfoPane().updateInfos(triggerControl);
        return selCalSetting;
    }

    protected void presetChannels() {
        this.cm.getWaveFormInfoControl().turnOnAllChannelsACNotInverse();
    }
}

