/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.util.format;

import com.owon.uppersoft.vds.util.format.SFormatter;
import java.math.BigDecimal;

public class UnitConversionUtil {
    public static final String FrequencyLabel_Hz_BTW_Question = "?";
    public static final String FrequencyLabel_Hz_BTW_Empty = "";

    public static final String getTextFor_uS(double d) {
        double d2 = d;
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d2 <= 0.001 && d2 >= -0.001) {
            return SFormatter.UIformat("%.3f ns", d2 *= 1000.0);
        }
        if (d2 <= 1000.0 && d2 >= -1000.0) {
            return SFormatter.UIformat("%.3f us", d2);
        }
        if ((d2 /= 1000.0) <= 1000.0 && d2 >= -1000.0) {
            return SFormatter.UIformat("%.3f ms", d2);
        }
        return SFormatter.UIformat("%.3f s", d2 /= 1000.0);
    }

    public static final String getTimebaseLabel_mS(double d) {
        if (d == 0.0) {
            return "0.0 ns";
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d >= 1000.0 || d <= -1000.0) {
            return SFormatter.UIformat("%.3f s", d / 1000.0);
        }
        if (d >= 1.0 || d <= -1.0 || d == 0.0) {
            return SFormatter.UIformat("%.3f ms", d);
        }
        double d2 = d;
        if ((d2 *= 1000.0) >= 1.0 || d2 <= -1.0) {
            return SFormatter.UIformat("%.3f us", d2);
        }
        return SFormatter.UIformat("%.3f ns", d2 * 1000.0);
    }

    public static final String getSimplifiedTimebaseLabel_mS(double d) {
        if (d == 0.0) {
            return "0.0 ns";
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d >= 1000.0 || d <= -1000.0) {
            if (d >= 10000.0 || d <= -10000.0) {
                if (d >= 100000.0 || d <= -100000.0) {
                    return SFormatter.UIformat("%.1f s", d / 1000.0);
                }
                return SFormatter.UIformat("%.2f s", d / 1000.0);
            }
            return SFormatter.UIformat("%.3f s", d / 1000.0);
        }
        if (d >= 1.0 || d <= -1.0) {
            if (d >= 10.0 || d <= -10.0) {
                if (d >= 100.0 || d <= -100.0) {
                    return SFormatter.UIformat("%.1f ms", d);
                }
                return SFormatter.UIformat("%.2f ms", d);
            }
            return SFormatter.UIformat("%.3f ms", d);
        }
        double d2 = d;
        if ((d2 *= 1000.0) >= 1.0 || d2 <= -1.0) {
            if (d2 >= 10.0 || d2 <= -10.0) {
                if (d2 >= 100.0 || d2 <= -100.0) {
                    return SFormatter.UIformat("%.1f us", d2);
                }
                return SFormatter.UIformat("%.2f us", d2);
            }
            return SFormatter.UIformat("%.3f us", d2);
        }
        return SFormatter.UIformat("%.2f ns", d2 * 1000.0);
    }

    public static final String getVoltageLabel_mV(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d >= 1000.0 || d <= -1000.0) {
            return SFormatter.UIformat("%.3f V", d / 1000.0);
        }
        return SFormatter.UIformat("%.3f mV", d);
    }

    public static final String getSimplifiedVoltLabel_mV(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d < 1000.0 && d > -1000.0) {
            return SFormatter.UIformat("%d mV", Math.round(d));
        }
        if (d < 1000000.0 && d > -1000000.0) {
            return SFormatter.UIformat("%.2f V", d / 1000.0);
        }
        return SFormatter.UIformat("%.2f kV", d / 1000000.0);
    }

    public static final String getAmpererLabel_mA(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d < 1000.0 && d > -1000.0) {
            return SFormatter.UIformat("%d mA", Math.round(d));
        }
        if (d < 1000000.0 && d > -1000000.0) {
            return SFormatter.UIformat("%.2f A", d / 1000.0);
        }
        return SFormatter.UIformat("%.2f kA", d / 1000000.0);
    }

    public static final String getIntVoltageLabel_mV(int n) {
        if (n >= 1000 || n <= -1000) {
            return SFormatter.UIformat("%d V", n / 1000);
        }
        return SFormatter.UIformat("%d mV", n);
    }

    public static final String getIntVoltageLabel_xmV(int n) {
        if (n >= 1000 || n <= -1000) {
            return SFormatter.UIformat("%dV", n / 1000);
        }
        return SFormatter.UIformat("%dmV", n);
    }

    private static final String getVoltageLabel_mV2(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        boolean bl = true;
        if (d < 0.0) {
            bl = false;
            d = 0.0 - d;
        }
        String string = d >= 1000000.0 ? SFormatter.UIformat("%.2fkV", d / 1000000.0) : (d >= 1000.0 ? (d >= 100000.0 ? SFormatter.UIformat("%.1fV", d / 1000.0) : (d >= 10000.0 ? SFormatter.UIformat("%.2fV", d / 1000.0) : SFormatter.UIformat("%.3fV", d / 1000.0))) : (d >= 100.0 ? SFormatter.UIformat("%.1fmV", d) : (d >= 10.0 ? SFormatter.UIformat("%.2fmV", d) : SFormatter.UIformat("%.3fmV", d))));
        if (bl) {
            return string;
        }
        return "-" + string;
    }

    public static final String getVoltageLabel_V(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d >= 1.0 || d <= -1.0) {
            return SFormatter.UIformat("%.3f V", d);
        }
        return SFormatter.UIformat("%.3f mV", d * 1000.0);
    }

    public static final String getFrequencyLabel_Hz_withRestrict(double d, double d2) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        double d3 = d;
        double d4 = d2;
        if (d3 > -1000.0 && d3 < 1000.0) {
            String string = SFormatter.UIformat("%.3f Hz", d3);
            string = UnitConversionUtil.distrustCheck(d3, d4, string);
            return string;
        }
        d3 /= 1000.0;
        d4 /= 1000.0;
        if (d3 > -1000.0 && d3 < 1000.0) {
            String string = SFormatter.UIformat("%.3f kHz", d3);
            string = UnitConversionUtil.distrustCheck(d3, d4, string);
            return string;
        }
        d3 /= 1000.0;
        d4 /= 1000.0;
        if (d3 > -1000.0 && d3 < 1000.0) {
            String string = SFormatter.UIformat("%.3f MHz", d3);
            string = UnitConversionUtil.distrustCheck(d3, d4, string);
            return string;
        }
        String string = SFormatter.UIformat("%.3f GHz", d3 /= 1000.0);
        string = UnitConversionUtil.distrustCheck(d3, d4 /= 1000.0, string);
        return string;
    }

    private static String distrustCheck(double d, double d2, String string) {
        if ((d = BigDecimal.valueOf(d).setScale(3, 4).doubleValue()) > (d2 = BigDecimal.valueOf(d2).setScale(3, 4).doubleValue())) {
            string = string + FrequencyLabel_Hz_BTW_Question;
        }
        return string;
    }

    public static final String getSimplifiedFrequencyLabel_Hz(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        double d2 = BigDecimal.valueOf(d).setScale(5, 4).doubleValue();
        if (d2 > -1000.0 && d2 < 1000.0) {
            if (d2 > -100.0 && d2 < 100.0) {
                if (d2 > -10.0 && d2 < 10.0) {
                    return SFormatter.UIformat("%.3f Hz", d2);
                }
                return SFormatter.UIformat("%.2f Hz", d2);
            }
            return SFormatter.UIformat("%.1f Hz", d2);
        }
        if ((d2 /= 1000.0) > -1000.0 && d2 < 1000.0) {
            if (d2 > -100.0 && d2 < 100.0) {
                if (d2 > -10.0 && d2 < 10.0) {
                    return SFormatter.UIformat("%.3f kHz", d2);
                }
                return SFormatter.UIformat("%.2f kHz", d2);
            }
            return SFormatter.UIformat("%.1f kHz", d2);
        }
        if ((d2 /= 1000.0) > -1000.0 && d2 < 1000.0) {
            if (d2 > -100.0 && d2 < 100.0) {
                if (d2 > -10.0 && d2 < 10.0) {
                    return SFormatter.UIformat("%.3f MHz", d2);
                }
                return SFormatter.UIformat("%.2f MHz", d2);
            }
            return SFormatter.UIformat("%.1f MHz", d2);
        }
        return SFormatter.UIformat("%.3f GHz", d2 /= 1000.0);
    }

    public static final String getSimplifiedFrequencyLabel_Hz2(double d) {
        String string;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d < 10000.0) {
            string = " Hz";
        } else if (d < 1.0E7) {
            d /= 1000.0;
            string = " KHz";
        } else if (d < 1.0E11) {
            d /= 1000000.0;
            string = " MHz";
        } else {
            d /= 1.0E9;
            string = " GHz";
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        int n = bigDecimal.scale() - bigDecimal.precision() + 6;
        bigDecimal = bigDecimal.setScale(n, 4);
        if (bigDecimal.precision() > 6) {
            bigDecimal = bigDecimal.setScale(n - 1, 4);
        }
        return bigDecimal.toPlainString() + string;
    }

    public static final String getBytesNumber(int n) {
        int n2 = 1024;
        if (n < n2) {
            return n + "B";
        }
        return (n >> 10) + "kB";
    }

    public static final String getPercent(int n, int n2) {
        if (n >= n2) {
            return "100%";
        }
        return SFormatter.UIformat("%d%%", n * 100 / n2);
    }

    public static final String getPercent(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d < 0.0) {
            return FrequencyLabel_Hz_BTW_Question;
        }
        if (d == 0.0) {
            return SFormatter.UIformat("%.0f%%", d);
        }
        return SFormatter.UIformat("%.2f%%", d * 100.0);
    }

    public static final String getSpeed(int n, long l) {
        if (n <= 0 || l <= 0L) {
            return "-%";
        }
        return SFormatter.UIformat("%.2f kB/s", (double)n / (double)l);
    }

    public static void main(String[] stringArray) {
        double d = 1000.0;
        System.out.println(d <= 1000.0);
    }
}

