/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.util;

import com.owon.uppersoft.vds.core.measure.MeasureElem;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.data.RGB;
import com.owon.uppersoft.vds.util.StringPool;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

class PropertiesUtil {
    public static final String Language = "Language";
    public static final String Country = "Country";
    public static final String Variant = "Variant";

    PropertiesUtil() {
    }

    public static boolean loadBoolean(Properties properties, String string) {
        String string2 = properties.getProperty(string, "");
        return string2.equalsIgnoreCase("1");
    }

    public static void persistBoolean(Properties properties, String string, boolean bl) {
        String string2 = bl ? "1" : "0";
        properties.setProperty(string, string2);
    }

    public static Locale loadLocale(Properties properties) {
        Locale locale = Locale.ENGLISH;
        String string = properties.getProperty(Language, "");
        if (!string.equals("")) {
            String string2 = properties.getProperty(Country, "");
            String string3 = properties.getProperty(Variant, "");
            locale = new Locale(string, string2, string3);
        }
        return locale;
    }

    public static void persistLocale(Properties properties, Locale locale) {
        properties.setProperty(Language, locale.getLanguage());
        properties.setProperty(Country, locale.getCountry());
        properties.setProperty(Variant, locale.getVariant());
    }

    public static List<File> loadFileHistory(Properties properties, String string, int n) {
        ArrayList<File> arrayList = new ArrayList<File>(n);
        String string2 = properties.getProperty(string, "");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 != n) {
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists()) continue;
            arrayList.add(file);
            ++n2;
        }
        return arrayList;
    }

    public static void persistFileHistory(Properties properties, String string, List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            stringBuilder.append(file.getPath());
            stringBuilder.append(";");
        }
        properties.setProperty(string, stringBuilder.toString());
    }

    public static LinkedList<Integer> loadIntegerList(Properties properties, String string, String string2) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        String string3 = properties.getProperty(string, "");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(Integer.parseInt(stringTokenizer.nextToken()));
        }
        return linkedList;
    }

    public static void persistIntegerList(Properties properties, String string, List<Integer> list, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : list) {
            stringBuilder.append(n);
            stringBuilder.append(string2);
        }
        properties.setProperty(string, stringBuilder.toString());
    }

    public static List<String> loadStringList(Properties properties, String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = properties.getProperty(string, "");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken().trim());
        }
        return linkedList;
    }

    public static List<String> loadStringList(Properties properties, String string, String string2, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = properties.getProperty(string, "");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < n; ++i) {
            linkedList.add(stringTokenizer.nextToken().trim());
        }
        return linkedList;
    }

    public static void persistStringList(Properties properties, String string, List<String> list, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : list) {
            stringBuilder.append(string3);
            stringBuilder.append(string2);
        }
        properties.setProperty(string, stringBuilder.toString());
    }

    public static RGB loadRGB(Properties properties, String string, RGB rGB) {
        String string2 = properties.getProperty(string, "");
        return new RGB(string2);
    }

    public static void persistRGB(Properties properties, String string, RGB rGB) {
        properties.setProperty(string, rGB.toHexString());
    }

    public static int loadInt(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        if (string2.length() == 0) {
            return n;
        }
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    public static void persistInt(Properties properties, String string, int n) {
        properties.setProperty(string, String.valueOf(n));
    }

    public static Locale forLocale(String string) {
        String[] stringArray = string.split("_");
        switch (stringArray.length) {
            case 1: {
                return new Locale(stringArray[0]);
            }
            case 2: {
                return new Locale(stringArray[0], stringArray[1]);
            }
            case 3: {
                return new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
        }
        return null;
    }

    public static List<Locale> forNames(String[] stringArray) {
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        for (String string : stringArray) {
            Locale locale = PropertiesUtil.forLocale(string);
            if (locale == null) continue;
            linkedList.add(locale);
        }
        return linkedList;
    }

    public static Point loadPoint(Properties properties, String string, Point point) {
        String string2;
        String[] stringArray;
        if (point == null) {
            point = new Point(0, 0);
        }
        if ((stringArray = (string2 = properties.getProperty(string, "")).split(",")).length >= 2) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                point.x = n;
                point.y = n2;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return point;
    }

    public static void persistPoint(Properties properties, String string, Point point) {
        properties.setProperty(string, point.x + "," + point.y);
    }

    public static int[] loadInts(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string, "");
        String[] stringArray = string2.split(",");
        if (n > 0 && stringArray.length < n) {
            return StringPool.EmptyIntArray;
        }
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return StringPool.EmptyIntArray;
        }
    }

    public static void persistInts(Properties properties, String string, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (nArray != null && nArray.length != 0) {
            for (int n : nArray) {
                stringBuilder.append(n);
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        properties.setProperty(string, stringBuilder.toString());
    }

    public static byte[] loadBytes(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string, "");
        String[] stringArray = string2.split("\\.");
        if (n > 0 && stringArray.length < n) {
            return StringPool.EmptybyteArray;
        }
        byte[] byArray = new byte[n];
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = Integer.parseInt(stringArray[i]);
                byArray[i] = (byte)n2;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return StringPool.EmptybyteArray;
        }
    }

    public static void persistBytes(Properties properties, String string, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null && byArray.length != 0) {
            for (byte by : byArray) {
                stringBuilder.append(by & 0xFF);
                stringBuilder.append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        properties.setProperty(string, stringBuilder.toString());
    }

    public static void persistMeasureElem(Properties properties, LinkedList<MeasureElem> linkedList) {
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (MeasureElem measureElem : linkedList) {
            if (!measureElem.on) continue;
            linkedList2.add(measureElem.idx);
        }
        PropertiesUtil.persistIntegerList(properties, "MeasureDelayCode", linkedList2, ",");
    }
}

