/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.util;

import com.owon.uppersoft.vds.core.measure.MeasureElem;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.data.RGB;
import com.owon.uppersoft.vds.util.PropertiesUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class Pref
extends Properties {
    public static final String EmptyString = "";
    public static final String SemicolonString = ";";
    public static final String TRUE_STRING = "1";
    public static final String FALSE_STRING = "0";
    public static final String[] EmptyStringArray = new String[]{""};
    public static final int[] EmptyIntArray = new int[0];
    public static final byte[] EmptybyteArray = new byte[0];
    public static final String Language = "Language";
    public static final String Country = "Country";
    public static final String Variant = "Variant";

    public boolean loadBoolean(String string) {
        String string2 = this.getProperty(string, EmptyString);
        return string2.equalsIgnoreCase(TRUE_STRING);
    }

    public boolean loadBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string, EmptyString);
        if (string2 == null || EmptyString.equals(string2)) {
            return bl;
        }
        return string2.equalsIgnoreCase(TRUE_STRING);
    }

    public void persistBoolean(String string, boolean bl) {
        String string2 = bl ? TRUE_STRING : FALSE_STRING;
        this.setProperty(string, string2);
    }

    public Locale loadLocale() {
        Locale locale = Locale.ENGLISH;
        String string = this.getProperty(Language, EmptyString);
        if (!string.equals(EmptyString)) {
            String string2 = this.getProperty(Country, EmptyString);
            String string3 = this.getProperty(Variant, EmptyString);
            locale = new Locale(string, string2, string3);
        }
        return locale;
    }

    public void persistLocale(Locale locale) {
        this.setProperty(Language, locale.getLanguage());
        this.setProperty(Country, locale.getCountry());
        this.setProperty(Variant, locale.getVariant());
    }

    public List<File> loadFileHistory(String string, int n) {
        ArrayList<File> arrayList = new ArrayList<File>(n);
        String string2 = this.getProperty(string, EmptyString);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SemicolonString);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 != n) {
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists()) continue;
            arrayList.add(file);
            ++n2;
        }
        return arrayList;
    }

    public void persistFileHistory(String string, List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            stringBuilder.append(file.getPath());
            stringBuilder.append(SemicolonString);
        }
        this.setProperty(string, stringBuilder.toString());
    }

    public LinkedList<Integer> loadIntegerList(String string, String string2) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        String string3 = this.getProperty(string, EmptyString);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(Integer.parseInt(stringTokenizer.nextToken()));
        }
        return linkedList;
    }

    public void persistIntegerList(String string, List<Integer> list, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : list) {
            stringBuilder.append(n);
            stringBuilder.append(string2);
        }
        this.setProperty(string, stringBuilder.toString());
    }

    public List<String> loadStringList(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = this.getProperty(string, EmptyString);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken().trim());
        }
        return linkedList;
    }

    public List<String> loadStringList(String string, String string2, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = this.getProperty(string, EmptyString);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < n; ++i) {
            linkedList.add(stringTokenizer.nextToken().trim());
        }
        return linkedList;
    }

    public void persistStringList(String string, List<String> list, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : list) {
            stringBuilder.append(string3);
            stringBuilder.append(string2);
        }
        this.setProperty(string, stringBuilder.toString());
    }

    public RGB loadRGB(String string, RGB rGB) {
        String string2 = this.getProperty(string, EmptyString);
        return new RGB(string2);
    }

    public void persistRGB(String string, RGB rGB) {
        this.setProperty(string, rGB.toHexString());
    }

    public Color loadColor(String string) {
        return this.loadColor(string, Color.WHITE);
    }

    public Color loadColor(String string, Color color) {
        String string2 = this.getProperty(string);
        if (string2 == null || EmptyString.equals(string2)) {
            return color;
        }
        int n = Integer.parseInt(string2, 16);
        return new Color(n);
    }

    public void persistColor(String string, Color color) {
        int n = 0xFFFFFF & color.getRGB();
        this.setProperty(string, Integer.toHexString(n));
    }

    public int loadInt(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        if (string2.length() == 0) {
            return n;
        }
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    public int loadInt(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null || EmptyString.equals(string2)) {
            return n;
        }
        return Integer.valueOf(string2);
    }

    public void persistInt(String string, int n) {
        this.setProperty(string, String.valueOf(n));
    }

    public static final Locale forLocale(String string) {
        String[] stringArray = string.split("_");
        switch (stringArray.length) {
            case 1: {
                return new Locale(stringArray[0]);
            }
            case 2: {
                return new Locale(stringArray[0], stringArray[1]);
            }
            case 3: {
                return new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
        }
        return null;
    }

    public static final List<Locale> forNames(String[] stringArray) {
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        for (String string : stringArray) {
            Locale locale = PropertiesUtil.forLocale(string);
            if (locale == null) continue;
            linkedList.add(locale);
        }
        return linkedList;
    }

    public Point loadPoint(String string, Point point) {
        String string2;
        String[] stringArray;
        if (point == null) {
            point = new Point(0, 0);
        }
        if ((stringArray = (string2 = this.getProperty(string, EmptyString)).split(",")).length >= 2) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                point.x = n;
                point.y = n2;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return point;
    }

    public void persistPoint(String string, Point point) {
        this.setProperty(string, point.x + "," + point.y);
    }

    public int[] loadInts(String string, int n) {
        String string2 = this.getProperty(string, EmptyString);
        String[] stringArray = string2.split(",");
        if (n > 0 && stringArray.length < n) {
            return EmptyIntArray;
        }
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return EmptyIntArray;
        }
    }

    public void persistInts(String string, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (nArray != null && nArray.length != 0) {
            for (int n : nArray) {
                stringBuilder.append(n);
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.setProperty(string, stringBuilder.toString());
    }

    public byte[] loadBytes(String string, int n) {
        String string2 = this.getProperty(string, EmptyString);
        String[] stringArray = string2.split("\\.");
        if (n > 0 && stringArray.length < n) {
            return EmptybyteArray;
        }
        byte[] byArray = new byte[n];
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = Integer.parseInt(stringArray[i]);
                byArray[i] = (byte)n2;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return EmptybyteArray;
        }
    }

    public void persistBytes(String string, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null && byArray.length != 0) {
            for (byte by : byArray) {
                stringBuilder.append(by & 0xFF);
                stringBuilder.append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.setProperty(string, stringBuilder.toString());
    }

    public void persistMeasureElem(LinkedList<MeasureElem> linkedList) {
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (MeasureElem measureElem : linkedList) {
            if (!measureElem.on) continue;
            linkedList2.add(measureElem.idx);
        }
        this.persistIntegerList("MeasureDelayCode", linkedList2, ",");
    }
}

