/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.util;

import com.owon.uppersoft.vds.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class LoggerUtil {
    public static final int LogStrategy_FILEASCONSOLE = 1;
    public static int LogStrategy = 0;
    public static final String LogDir = "log.txt";
    public static final String ErrDir = "err.txt";

    public static final void redirect2FileLog(File file) {
        String string = ErrDir;
        String string2 = LogDir;
        File file2 = new File(file, string);
        File file3 = new File(file, string2);
        FileUtil.checkPath(file2);
        FileUtil.checkPath(file3);
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        try {
            printStream = new PrintStream(file2);
            printStream2 = new PrintStream(file3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (printStream2 != null) {
            System.setOut(printStream2);
            System.out.println("start log:");
        }
        if (printStream != null) {
            System.setErr(printStream);
        }
    }

    public static Logger getFileLogger(String string, Level level, String string2) {
        Logger logger = Logger.getLogger(string);
        StreamHandler streamHandler = null;
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        File file = new File(string2);
        file.mkdirs();
        try {
            streamHandler = new StreamHandler(new FileOutputStream(new File(file, string)), simpleFormatter);
            streamHandler.setLevel(level);
            logger.addHandler(streamHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        logger.setLevel(level);
        return logger;
    }

    public static Logger getConsoleLogger(String string, Level level, final Textable textable) {
        Logger logger = Logger.getLogger(string);
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        Handler handler = new Handler(){

            @Override
            public synchronized void publish(LogRecord logRecord) {
                String string = logRecord.getMessage();
                textable.appendText(string);
            }

            @Override
            public void close() {
                this.flush();
            }

            @Override
            public void flush() {
                System.out.flush();
            }
        };
        handler.setLevel(level);
        logger.addHandler(handler);
        logger.setLevel(level);
        return logger;
    }

    public static interface Textable {
        public void appendText(String var1);
    }
}

