/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.util;

import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.TimeMeasure;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.List;
import javax.swing.JFileChooser;

public class FileUtil {
    public static String getExtension(File file) {
        return file != null ? FileUtil.getExtension(file.getName()) : "";
    }

    public static String getExtension(String string) {
        return FileUtil.getExtension(string, "");
    }

    public static String getExtension(String string, String string2) {
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(".");
            if (n > 0 && n < string.length() - 1) {
                return string.substring(n + 1);
            }
            return string2;
        }
        return string2;
    }

    public static void checkPath(String string) {
        FileUtil.checkPath(new File(string));
    }

    public static void checkPath(File file) {
        if (file.exists()) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
    }

    public static File checkFileSuffix(JFileChooser jFileChooser, String string) {
        File file = jFileChooser.getSelectedFile();
        boolean bl = file.getName().toUpperCase().endsWith("." + string.toUpperCase());
        if (!bl) {
            file = new File(file.getAbsolutePath() + "." + string);
        }
        return file;
    }

    public static File cutFileSuffix(JFileChooser jFileChooser, String string) {
        File file = jFileChooser.getSelectedFile();
        int n = file.getAbsolutePath().toUpperCase().lastIndexOf("." + string.toUpperCase());
        if (n < 0) {
            return file;
        }
        String string2 = file.getAbsolutePath().substring(0, n);
        file = new File(string2);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                byte[] byArray = new byte[8192];
                int n = 0;
                while (-1 != (n = fileInputStream.read(byArray))) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean copyFile2(File file, File file2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            FileChannel fileChannel = fileInputStream.getChannel();
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
            fileInputStream.close();
            fileOutputStream.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutFiles2one(File file, File file2, int n, int n2, File file3) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStream fileInputStream2 = new FileInputStream(file2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            try {
                byte[] byArray = new byte[0x100000];
                int n3 = 0;
                fileInputStream.read(byArray, 0, n);
                fileOutputStream.write(byArray, 0, n);
                fileInputStream2.skip(n2);
                while (-1 != (n3 = fileInputStream2.read(byArray))) {
                    fileOutputStream.write(byArray, 0, n3);
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void deleteFile(String string) {
        FileUtil.deleteFile(new File(string));
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                FileUtil.deleteFile(file2);
            }
            file.delete();
            return;
        }
    }

    public static void replaceFile(File file, File file2) {
        if (file2.exists()) {
            FileUtil.deleteFile(file2);
        }
        file.renameTo(file2);
    }

    public static void replaceInFile(File file, File file2) {
        File file3 = new File(file2, file.getName());
        FileUtil.replaceFile(file, file3);
    }

    public static void main(String[] stringArray) {
        TimeMeasure timeMeasure = new TimeMeasure();
        timeMeasure.start();
        FileUtil.deleteFile("F:/Alisoft");
        timeMeasure.stop();
        System.out.println(timeMeasure.measure());
    }

    public static final String getFileCanonicalPath(File file) {
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public static String readDefaultFPGAVersion() {
        InputStream inputStream = FileUtil.fileToInputStream();
        if (inputStream == null) {
            return null;
        }
        Pref pref = new Pref();
        try {
            pref.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        List<String> list = pref.loadStringList("defaultFPGAVersion", ",");
        if (list.size() > 0) {
            return pref.loadStringList("defaultFPGAVersion", ",").get(0);
        }
        return null;
    }

    private static File m1(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    private static InputStream fileToInputStream() {
        File file = FileUtil.m1("initInfo");
        if (file == null) {
            return null;
        }
        ByteBuffer byteBuffer = null;
        FileChannel fileChannel = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            fileChannel = randomAccessFile.getChannel();
            byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.limit() - byteBuffer.position();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new ByteArrayInputStream(byArray);
    }
}

