/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.widget.custom;

import com.owon.uppersoft.vds.ui.widget.help.RolloverProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class CLButton
extends JButton {
    public static final Color bg = Color.LIGHT_GRAY;
    public static final Color border = Color.DARK_GRAY;
    private Color bgColor;
    private Color borderColor;
    private RolloverProvider rollover;
    private String rollvoerText;
    private String originText;
    private boolean rollvoerTextOn;

    public CLButton() {
        this.setOpaque(false);
        this.setUI(new BasicButtonUI());
        this.bgColor = bg;
        this.borderColor = border;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (!CLButton.this.rollover.isOrNot()) {
                    CLButton.this.rollover.set(true);
                    CLButton.this.repaint();
                }
                if (CLButton.this.rollvoerTextOn && CLButton.this.rollvoerText != null) {
                    CLButton.this.setText(CLButton.this.rollvoerText);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (CLButton.this.rollover.isOrNot()) {
                    CLButton.this.rollover.set(false);
                    CLButton.this.repaint();
                }
                if (CLButton.this.rollvoerTextOn && CLButton.this.originText != null) {
                    CLButton.this.setText(CLButton.this.originText);
                }
            }
        });
        this.rollover = new RolloverProvider();
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setRolloverProvider(RolloverProvider rolloverProvider) {
        this.rollover = rolloverProvider;
    }

    public void setRolloverText(String string) {
        this.rollvoerTextOn = true;
        this.rollvoerText = string;
        this.originText = this.getText();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean bl;
        boolean bl2 = bl = this.rollover.isOrNot() && this.isEnabled();
        if (bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.bgColor);
            graphics2D.fillRoundRect(0, 3, n, n2 - 6, 5, 5);
            graphics2D.setColor(this.borderColor);
            graphics2D.drawRoundRect(0, 3, n - 1, n2 - 6, 5, 5);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        super.paintComponent(graphics);
    }
}

