/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class LightenButton
extends JButton
implements MouseListener {
    private boolean pressed;
    public static final Stroke Stroke2 = new BasicStroke(2.0f);

    public LightenButton() {
        this.setUI(new BasicButtonUI());
        this.setOpaque(false);
        this.setForeground(Color.WHITE);
        this.pressed = false;
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setForeground(Color.ORANGE);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setForeground(Color.WHITE);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        int n = this.getFontMetrics(this.getFont()).stringWidth(string) + 8;
        int n2 = 25;
        this.setPreferredSize(new Dimension(n, n2));
        this.setToolTipText(this.getText());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(Stroke2);
        graphics2D.drawRoundRect(2, 2, n - 4, n2 - 4, 8, 8);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void setFont_Text(Font font, String string) {
        this.setFont(font);
        this.setText(string);
    }
}

