/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.widget;

import com.owon.uppersoft.dso.model.trigger.helper.EnumTypeNValue;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.text.DefaultFormatterFactory;

public class CSpinner
extends JSpinner {
    private SpinnerModel model;
    private int isteps;

    public CSpinner(SpinnerModel spinnerModel, int n) {
        super(spinnerModel);
        this.model = spinnerModel;
        this.isteps = n;
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
        jFormattedTextField.setEditable(true);
        jFormattedTextField.setFocusable(true);
        jFormattedTextField.setHorizontalAlignment(4);
        jFormattedTextField.setFocusLostBehavior(2);
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new MetricFormatter()));
        jFormattedTextField.setFont(jFormattedTextField.getFont().deriveFont(14.0f));
    }

    public CSpinner(JSpinner jSpinner, int n) {
        this.model = jSpinner.getModel();
        this.isteps = n;
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
        jFormattedTextField.setVisible(false);
        this.setPreferredSize(new Dimension(18, 28));
    }

    @Override
    public Object getPreviousValue() {
        ((EnumTypeNValue)this.model.getValue()).nextStep(this.isteps);
        Object object = this.model.getPreviousValue();
        if (object != null) {
            this.model.setValue(object);
        }
        return null;
    }

    @Override
    public Object getNextValue() {
        ((EnumTypeNValue)this.model.getValue()).nextStep(this.isteps);
        Object object = this.model.getNextValue();
        if (object != null) {
            this.model.setValue(object);
        }
        return null;
    }

    @Override
    public void commitEdit() throws ParseException {
    }

    static class MetricFormatter
    extends JFormattedTextField.AbstractFormatter {
        MetricFormatter() {
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                return "";
            }
            return object.toString();
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            try {
                String string2 = string.trim().toLowerCase();
                int n = string2.length();
                if (n < 1) {
                    throw new ParseException("Invalid value", 0);
                }
                if (string2.charAt(n - 1) == 's') {
                    --n;
                }
                Double d = 1.0E9;
                switch (string2.charAt(n - 1)) {
                    case 'n': {
                        --n;
                        d = 1.0;
                        break;
                    }
                    case 'u': {
                        --n;
                        d = 1000.0;
                        break;
                    }
                    case 'm': {
                        --n;
                        d = 1000000.0;
                    }
                }
                return Double.parseDouble(string2.substring(0, n)) * d;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid value", 0);
            }
        }
    }
}

