/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.slider;

import com.owon.uppersoft.vds.ui.slider.ISliderView;
import com.owon.uppersoft.vds.ui.slider.SliderDelegate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class SymmetrySliderView
implements ISliderView {
    public Stroke Stroke3 = new BasicStroke(3.0f);
    private final Dimension sz;
    private int vRange;
    private int vPos;
    private int middle0;
    private boolean vertical;
    private Color vco;
    private int defaultValue;
    private SliderDelegate delegate;
    private int max;
    private int value;
    public static final int critical1 = 100;
    public static final int Gap = 2;
    public static final int tail = 8;
    private int ga;

    public SymmetrySliderView(Dimension dimension, int n, int n2, int n3, boolean bl, Color color, SliderDelegate sliderDelegate) {
        this.sz = new Dimension(dimension);
        this.delegate = sliderDelegate;
        this.vertical = bl;
        this.vco = color;
        this.defaultValue = n2;
        this.max = n;
        this.vRange = bl ? dimension.height : dimension.width;
        this.middle0 = this.vRange >> 1;
        this.value = n3;
        this.vPos = n3 * this.vRange / n;
        if (bl) {
            this.restrict(this.vPos, dimension.height - 8);
        } else {
            this.restrict(this.vPos, dimension.width - 8);
        }
    }

    private void setValue(int n) {
        int n2;
        int n3 = n;
        int n4 = this.value;
        if (n3 > this.max - 1) {
            n3 = this.max - 1;
        } else if (n3 < 0) {
            n3 = 0;
        }
        if (n3 == n4) {
            return;
        }
        this.value = n3;
        this.delegate.valueChanged(n4, n3);
        this.vPos = n2 = n3 * this.vRange / this.max;
        if (this.vertical) {
            this.restrict(this.vPos, this.sz.height - 8);
        } else {
            this.restrict(this.vPos, this.sz.width - 8);
        }
    }

    @Override
    public void adjustAdd(int n) {
        int n2 = n >> 2;
        if (Math.abs(n2) < 100) {
            n2 /= 2;
        }
        if (n2 == 0) {
            n2 = n > 0 ? 1 : -1;
        }
        this.add(n2);
    }

    private void add(int n) {
        this.setValue(this.value + n);
    }

    private void restrict(int n, int n2) {
        int n3 = 0;
        if (n < 8) {
            n3 = 8 - n + 1;
        } else if (n > n2) {
            n3 = n - n2 + 1;
        }
        this.ga = n3 + 2;
    }

    @Override
    public void actionOff() {
        this.delegate.actionOff();
    }

    @Override
    public void setDefault() {
        this.setValue(this.defaultValue);
        this.delegate.actionOff();
    }

    @Override
    public void paintSelf(Graphics2D graphics2D) {
        graphics2D.setColor(Color.DARK_GRAY);
        int n = this.sz.width;
        int n2 = this.sz.height;
        graphics2D.setStroke(this.Stroke3);
        if (this.vertical) {
            graphics2D.drawLine(2, this.middle0, n - 2, this.middle0);
        } else {
            graphics2D.drawLine(this.middle0, 2, this.middle0, n2 - 2);
        }
        graphics2D.setColor(this.vco);
        if (this.vertical) {
            graphics2D.drawLine(this.ga, this.vPos, n - this.ga, this.vPos);
        } else {
            graphics2D.drawLine(this.vPos, this.ga, this.vPos, n2 - this.ga);
        }
    }
}

