/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.slider;

import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.slider.FocusControlButton;
import com.owon.uppersoft.vds.ui.slider.ISliderView;
import com.owon.uppersoft.vds.ui.slider.SliderDelegate;
import com.owon.uppersoft.vds.ui.slider.SliderView;
import com.owon.uppersoft.vds.ui.slider.SymmetrySliderView;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SymmetrySliderBar
extends JPanel
implements MouseListener,
MouseMotionListener,
Runnable {
    public static final AlphaComposite composite80 = LineDrawTool.getAlphaComposite(0.8f);
    public static final AlphaComposite composite100 = LineDrawTool.getAlphaComposite(1.0f);
    public static final String ImageDirectory = "/com/owon/uppersoft/vds/ui/slider/image/";
    public static final Image thumbv = SwingResourceManager.getIcon(SymmetrySliderBar.class, "/com/owon/uppersoft/vds/ui/slider/image/thumbv.png").getImage();
    public static final Image sliderbgv = SwingResourceManager.getIcon(SymmetrySliderBar.class, "/com/owon/uppersoft/vds/ui/slider/image/sliderbgv.png").getImage();
    public static final Image sliderbgh = SwingResourceManager.getIcon(SymmetrySliderBar.class, "/com/owon/uppersoft/vds/ui/slider/image/sliderbgh.png").getImage();
    public static final Image thumbh = SwingResourceManager.getIcon(SymmetrySliderBar.class, "/com/owon/uppersoft/vds/ui/slider/image/thumbh.png").getImage();
    public static final int sliderheight = 178;
    public static final int sliderwidth = 19;
    public static final int thumbwidth = 16;
    public static final int thumbheight = 24;
    private Dimension sz;
    private Color sco = Color.DARK_GRAY;
    private boolean sliderSelected = false;
    private int rangeLength;
    private int thumbLength;
    private int tPos;
    private int thumbRange;
    private int lastv;
    private int middlePos;
    private int middle0;
    private ISliderView sv;
    private boolean vertical;
    private int increment = 0;
    private Thread t = null;
    private static final int INFOBLOCK = 1;
    private static final int LABEL = 2;
    private static final int EDGEPANE = 3;
    private static final int PULSEPANE = 4;
    private static final int SLOPEPANE = 5;
    private static final int DETAILPANE = 7;

    public SymmetrySliderBar(ISliderView iSliderView, Dimension dimension, boolean bl) {
        this.sz = new Dimension(dimension);
        this.setPreferredSize(dimension);
        this.vertical = bl;
        this.setOpaque(false);
        this.sv = iSliderView;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.rangeLength = bl ? dimension.height : dimension.width;
        this.thumbLength = 24;
        this.thumbRange = this.rangeLength - this.thumbLength;
        this.middle0 = this.rangeLength >> 1;
        this.middlePos = this.thumbRange >> 1;
        this.resetSpos();
    }

    private final void resetSpos() {
        this.tPos = this.middlePos;
    }

    private final int getMousePos(MouseEvent mouseEvent) {
        return this.vertical ? mouseEvent.getY() : mouseEvent.getX();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.sliderSelected) {
            return;
        }
        int n = this.getMousePos(mouseEvent);
        int n2 = this.tPos + n - this.lastv;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.thumbRange) {
            n2 = this.thumbRange;
        }
        this.lastv = this.lastv + n2 - this.tPos;
        this.tPos = n2;
        this.repaint();
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getMousePos(mouseEvent);
        this.sliderSelected = false;
        if (n < this.middlePos) {
            this.increment = -1;
        } else if (n >= this.middlePos + this.thumbLength) {
            this.increment = 1;
        } else {
            this.increment = 0;
            this.sliderSelected = true;
        }
        if (this.sliderSelected) {
            this.lastv = n;
        } else if (this.t == null) {
            final int n2 = this.increment;
            this.t = new Thread(){

                @Override
                public void run() {
                    try {
                        if (n2 != 0) {
                            SymmetrySliderBar.this.sv.adjustAdd(n2);
                            SymmetrySliderBar.this.repaint();
                            Thread.sleep(500L);
                        }
                        while (SymmetrySliderBar.this.increment != 0) {
                            Thread.sleep(100L);
                            SymmetrySliderBar.this.sv.adjustAdd(n2);
                            SymmetrySliderBar.this.repaint();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            };
            this.t.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.increment = 0;
        this.sliderSelected = false;
        if (this.t != null) {
            try {
                this.t.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.t = null;
        }
        this.resetSpos();
        this.sv.actionOff();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.vertical) {
            graphics.drawImage(sliderbgv, 0, 0, null);
        } else {
            graphics.drawImage(sliderbgh, 0, 0, null);
        }
        this.sv.paintSelf(graphics2D);
        graphics2D.setComposite(composite80);
        graphics.setColor(this.sco);
        if (this.vertical) {
            graphics.drawImage(thumbv, 1, this.tPos, null);
        } else {
            graphics.drawImage(thumbh, this.tPos, 1, null);
        }
        graphics2D.setComposite(composite100);
    }

    @Override
    public void run() {
        try {
            while (this.sliderSelected) {
                Thread.sleep(50L);
                int n = this.tPos - this.middlePos;
                this.sv.adjustAdd(n);
                this.repaint();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1;
        if (!bl) {
            return;
        }
        int n = this.vertical ? mouseEvent.getY() : mouseEvent.getX();
        if (n >= this.middlePos && n <= this.middlePos + this.thumbLength) {
            this.resetSpos();
            this.sv.setDefault();
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static final JDialog createAssistZoomViewSliderFrame(Window window, int n, int n2, boolean bl, ISliderView iSliderView, ResourceBundle resourceBundle) {
        return SymmetrySliderBar.createCViewSliderFrame(window, n, n2, bl, iSliderView, resourceBundle);
    }

    public static final JDialog createCViewSliderFrame(Window window, int n, int n2, boolean bl, ISliderView iSliderView, ResourceBundle resourceBundle) {
        int n3;
        int n4;
        if (bl) {
            n4 = 19;
            n3 = 178;
        } else {
            n4 = 178;
            n3 = 19;
        }
        SliderPopup sliderPopup = new SliderPopup(window);
        sliderPopup.setBounds(n, n2, n4, n3);
        Dimension dimension = new Dimension(n4, n3);
        SymmetrySliderBar symmetrySliderBar = new SymmetrySliderBar(iSliderView, dimension, bl);
        symmetrySliderBar.setBounds(0, 0, sliderPopup.getWidth(), sliderPopup.getHeight());
        FocusListener focusListener = FocusControlButton.addShareFocusControlButtons(iSliderView, symmetrySliderBar, sliderPopup, false, resourceBundle);
        sliderPopup.setVisible(true);
        return sliderPopup;
    }

    public static final JDialog createUnsymmetrySliderFrame(Window window, int n, int n2, int n3, int n4, boolean bl, int n5, SliderDelegate sliderDelegate, ResourceBundle resourceBundle) {
        int n6;
        int n7;
        if (bl) {
            n7 = 19;
            n6 = 178;
        } else {
            n7 = 178;
            n6 = 19;
        }
        SliderPopup sliderPopup = new SliderPopup(window, sliderDelegate);
        sliderPopup.setBounds(n, n2, n7 << 1, n6);
        Dimension dimension = new Dimension(n7, n6);
        SliderView sliderView = new SliderView(n3, n4, n5, sliderDelegate);
        SymmetrySliderBar symmetrySliderBar = new SymmetrySliderBar(sliderView, dimension, bl);
        symmetrySliderBar.setBounds(0, 0, n7, n6);
        FocusListener focusListener = FocusControlButton.addShareFocusControlButtons(sliderView, symmetrySliderBar, sliderPopup, 1, sliderDelegate, false, resourceBundle);
        sliderPopup.setVisible(true);
        return sliderPopup;
    }

    public static final JDialog createSymmetrySliderFrame(Window window, int n, int n2, int n3, int n4, int n5, boolean bl, Color color, int n6, SliderDelegate sliderDelegate, ResourceBundle resourceBundle) {
        int n7;
        int n8;
        if (bl) {
            n8 = 19;
            n7 = 178;
        } else {
            n8 = 178;
            n7 = 19;
        }
        SliderPopup sliderPopup = new SliderPopup(window, sliderDelegate);
        sliderPopup.setBounds(n, n2, n8, n7);
        Dimension dimension = new Dimension(n8, n7);
        SymmetrySliderView symmetrySliderView = new SymmetrySliderView(dimension, (n3 << 1) + 1, n4, n5, bl, color, sliderDelegate);
        SymmetrySliderBar symmetrySliderBar = new SymmetrySliderBar(symmetrySliderView, dimension, bl);
        symmetrySliderBar.setBounds(0, 0, n8, n7);
        FocusListener focusListener = FocusControlButton.addShareFocusControlButtons(symmetrySliderView, symmetrySliderBar, sliderPopup, n6, sliderDelegate, true, resourceBundle);
        sliderPopup.setVisible(true);
        return sliderPopup;
    }

    private static final int symmetry2zeroDown(int n, int n2) {
        return n - n2;
    }

    public static void main(String[] stringArray) {
    }

    static class SliderPopup
    extends JDialog
    implements AWTEventListener {
        private int mouseDown = -1;
        private boolean enteredOnce = false;
        private SliderDelegate pcl;

        SliderPopup(Window window) {
            this(window, (SliderDelegate)null);
        }

        SliderPopup(Window window, SliderDelegate sliderDelegate) {
            super(window);
            this.pcl = sliderDelegate;
            this.setLayout(null);
            this.enableInputMethods(false);
            this.setUndecorated(true);
            this.setFocusableWindowState(false);
            try {
                this.setBackground(new Color(0, 0, 0, 1));
            }
            catch (Exception exception) {
                this.setBackground(new Color(0, 0, 0));
            }
            this.getToolkit().addAWTEventListener(this, 16L);
        }

        @Override
        public void dispose() {
            this.getToolkit().removeAWTEventListener(this);
            if (this.pcl != null) {
                this.pcl.onDispose();
            }
            super.dispose();
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            switch (aWTEvent.getID()) {
                case 501: {
                    this.mouseDown = 1;
                    break;
                }
                case 502: {
                    this.mouseDown = 0;
                    return;
                }
                case 504: {
                    if (this.mouseDown == 0) break;
                    return;
                }
                default: {
                    return;
                }
            }
            for (Component component = ((MouseEvent)aWTEvent).getComponent(); component != this; component = component.getParent()) {
                if (component != null) continue;
                if (this.mouseDown == 1 || this.enteredOnce) {
                    this.dispose();
                }
                return;
            }
            this.enteredOnce = true;
        }
    }
}

