/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.prompt;

import com.owon.uppersoft.vds.ui.prompt.IPopDown;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.LineBorder;

public class PromptDialog
extends JPanel
implements IPopDown {
    public static final int RESHAPEPEROID = 100;
    public static final int RESHAPETIMES = 8;
    private int ytop;
    private Dimension maxSize = new Dimension(500, 400);
    private JOBOBSERVER jo = new JOBOBSERVER();
    private Rectangle2D r2d = new Rectangle2D.Double();
    public static final String LastPromptDispose = "LastPromptDispose";

    public PromptDialog(int n) {
        this.ytop = n;
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.removeAll();
    }

    @Override
    public void promptUp() {
        Rectangle rectangle = this.getBounds();
        rectangle.height = 1;
        this.arrange(rectangle, new Runnable(){

            @Override
            public void run() {
                PromptDialog.this.promptClose();
            }
        });
    }

    @Override
    public void prompt(JComponent jComponent, Runnable runnable) {
        if (this.getComponentCount() > 0) {
            this.promptShift(jComponent, runnable);
        } else {
            this.setVisible(false);
            this.promptDown(jComponent, runnable);
        }
    }

    private void setContent(JComponent jComponent) {
        this.removeAll();
        this.add((Component)jComponent, "Center");
        this.setPreferredSize(jComponent.getPreferredSize());
    }

    private void logln(Object object) {
    }

    private void arrange(Rectangle rectangle, Runnable runnable) {
        if (rectangle.width > this.maxSize.width) {
            rectangle.width = this.maxSize.width;
        }
        if (rectangle.height > this.maxSize.height) {
            rectangle.height = this.maxSize.height;
        }
        this.doTime_reshape(rectangle, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTime_reshape(Rectangle rectangle, Runnable runnable) {
        JOBOBSERVER jOBOBSERVER = this.jo;
        synchronized (jOBOBSERVER) {
            int n = ++this.jo.seq;
            Rectangle rectangle2 = this.getBounds();
            int n2 = rectangle2.width;
            int n3 = rectangle2.height;
            int n4 = rectangle.width;
            int n5 = rectangle.height;
            int n6 = rectangle2.x;
            int n7 = 8;
            int n8 = this.getXLoc(n4);
            this.logln(n6 + ", " + n8);
            double d = n8 - n6;
            double d2 = n5 - n3;
            double d3 = n4 - n2;
            int n9 = rectangle2.y;
            this.logln(d + ", " + d2);
            double d4 = d / (double)n7;
            double d5 = d2 / (double)n7;
            double d6 = d3 / (double)n7;
            Job job = new Job(n7, rectangle, d4, d6, d5, n9, runnable, n);
            Timer timer = new Timer(0, job);
            timer.setRepeats(false);
            timer.start();
        }
    }

    private void promptDown(JComponent jComponent, Runnable runnable) {
        this.setContent(jComponent);
        Rectangle rectangle = new Rectangle();
        Dimension dimension = jComponent.getPreferredSize();
        rectangle.width = dimension.width;
        rectangle.height = 0;
        rectangle.x = this.getXLoc(rectangle.width);
        rectangle.y = this.ytop;
        this.setBounds(rectangle);
        rectangle.height = dimension.height;
        this.revalidate();
        this.setVisible(true);
        this.arrange(rectangle, runnable);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.r2d.setRect(d, d2, d3, d4);
        super.setBounds((int)d, (int)d2, (int)d3, (int)d4);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.r2d.setRect(rectangle);
    }

    public void promptShift(JComponent jComponent, Runnable runnable) {
        this.fireLastComponent();
        this.setContent(jComponent);
        this.revalidate();
        Rectangle rectangle = new Rectangle();
        Dimension dimension = jComponent.getPreferredSize();
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        rectangle.x = this.getXLoc(rectangle.width);
        rectangle.y = this.ytop;
        this.arrange(rectangle, runnable);
    }

    private int getXLoc(int n) {
        Container container = this.getParent();
        int n2 = container.getWidth();
        int n3 = n2 - n >> 1;
        return n3;
    }

    private void fireLastComponent() {
        int n = this.getComponentCount();
        if (n > 0) {
            JComponent jComponent = (JComponent)this.getComponent(0);
            jComponent.firePropertyChange(LastPromptDispose, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promptClose() {
        this.fireLastComponent();
        this.removeAll();
        Object object = this.jo;
        synchronized (object) {
            this.jo.seq = 0;
        }
        object = this.getParent();
        ((Component)object).setVisible(false);
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        JButton jButton = new JButton("do");
        container.add((Component)jButton, "North");
        container.add((Component)new JPanel(), "Center");
        JButton jButton2 = new JButton("do2");
        container.add((Component)jButton2, "South");
        final JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("fdsfsd");
        jLabel.setBorder(new LineBorder(Color.RED, 1));
        jPanel.setBackground(Color.LIGHT_GRAY);
        jPanel.setPreferredSize(new Dimension(600, 400));
        jPanel.add((Component)jLabel, "Center");
        final JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel("fdsfsd2");
        jLabel2.setBorder(new LineBorder(Color.BLACK, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setPreferredSize(new Dimension(200, 100));
        jPanel2.add((Component)jLabel2, "Center");
        JPanel jPanel3 = new JPanel();
        container.add((Component)jPanel3, "Center");
        jFrame.setSize(800, 600);
        final PromptDialog promptDialog = new PromptDialog(60);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                promptDialog.prompt(jPanel, null);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                promptDialog.promptShift(jPanel2, null);
            }
        });
        jFrame.setVisible(true);
    }

    class Job
    implements ActionListener {
        int times;
        Rectangle dest;
        double xstep;
        double wstep;
        double hstep;
        int y;
        Runnable endMission;
        int t;

        public Job(int n, Rectangle rectangle, double d, double d2, double d3, int n2, Runnable runnable, int n3) {
            this.times = n;
            this.dest = rectangle;
            this.xstep = d;
            this.wstep = d2;
            this.hstep = d3;
            this.y = n2;
            this.endMission = runnable;
            this.t = n3;
            String string = SFormatter.UIformat("times: %d, xstep: %.2f, wstep: %.2f, hstep: %.2f, y: %d, t: %d", n, d, d2, d3, n2, this.t);
            PromptDialog.this.logln(string);
            PromptDialog.this.logln(rectangle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JOBOBSERVER jOBOBSERVER = PromptDialog.this.jo;
            synchronized (jOBOBSERVER) {
                if (((PromptDialog)PromptDialog.this).jo.seq != this.t) {
                    return;
                }
                boolean bl = this.shapeUnit();
                if (bl) {
                    PromptDialog.this.logln("done");
                    PromptDialog.this.doLayout();
                    if (this.endMission != null) {
                        this.endMission.run();
                    }
                    return;
                }
                PromptDialog.this.logln("repeat");
                Timer timer = new Timer(100 / this.times, this);
                timer.setRepeats(false);
                timer.start();
            }
        }

        private boolean shapeUnit() {
            boolean bl;
            Rectangle2D rectangle2D = PromptDialog.this.r2d;
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getWidth();
            double d3 = rectangle2D.getHeight();
            PromptDialog.this.logln((d += this.xstep) + ", " + (d2 += this.wstep) + ", " + (d3 += this.hstep));
            PromptDialog.this.setBounds(d, (double)this.y, d2, d3);
            PromptDialog.this.revalidate();
            boolean bl2 = bl = Math.abs((double)this.dest.width - d2) < 1.0 && Math.abs((double)this.dest.height - d3) < 1.0;
            if (Math.abs(d2) > (double)((PromptDialog)PromptDialog.this).maxSize.width || Math.abs(d3) > (double)((PromptDialog)PromptDialog.this).maxSize.height) {
                return true;
            }
            return bl;
        }
    }

    class JOBOBSERVER {
        int seq = 0;

        JOBOBSERVER() {
        }
    }
}

