/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class OneRowLayout
implements LayoutManager {
    private Dimension sz = new Dimension();
    private Insets insets;
    private int gap;

    public OneRowLayout() {
        this.insets = new Insets(0, 0, 0, 0);
    }

    public OneRowLayout(int n) {
        this.insets = new Insets(0, n, 0, 0);
    }

    public OneRowLayout(Insets insets, int n) {
        this.insets = insets;
        this.gap = n;
    }

    public OneRowLayout(int n, int n2) {
        this(n);
        this.gap = n2;
    }

    @Override
    public void layoutContainer(Container container) {
        container.getSize(this.sz);
        int n = container.getComponentCount();
        int n2 = this.insets.top;
        int n3 = this.sz.height - this.insets.top - this.insets.bottom;
        int n4 = this.insets.left;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            int n5 = dimension.width;
            component.setBounds(n4, n2, n5, n3);
            n4 += n5 + this.gap;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        int n2 = this.insets.left;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            n3 = Math.max(n3, dimension.height + this.insets.top + this.insets.bottom);
            if (!component.isVisible()) continue;
            n2 += dimension.width + this.gap;
        }
        return new Dimension(n2 += -this.gap + this.insets.right, n3);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return container.getPreferredSize();
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

