/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.dialog;

import com.owon.uppersoft.vds.ui.dialog.PopUp;
import com.owon.uppersoft.vds.ui.dialog.ProgressExecutor;
import com.owon.uppersoft.vds.ui.dialog.ProgressObserver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressableDialog
extends PopUp
implements ProgressObserver {
    private JProgressBar jpb;
    private String title;
    private String canceltxt;
    private String cancelPrompt;
    private ProgressExecutor runner;
    private static KeyEventDispatcher ked;

    public ProgressableDialog(Window window, boolean bl, final ProgressExecutor progressExecutor, String string, String string2, String string3) {
        super(window);
        this.runner = progressExecutor;
        this.title = string;
        this.canceltxt = string2;
        this.cancelPrompt = string3;
        this.jpb = this.CreateProgressBar();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                progressExecutor.execute(ProgressableDialog.this);
            }
        });
        this.pack();
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public void setMaximum(int n) {
        this.jpb.setMaximum(n);
    }

    @Override
    public void setValue(int n) {
        this.jpb.setValue(n);
    }

    @Override
    public void dispose() {
        boolean bl = false;
        if (!bl) {
            this.runner.cancel(new Runnable(){

                @Override
                public void run() {
                    ProgressableDialog.super.dispose();
                }
            });
        }
    }

    @Override
    public void shutdown() {
        super.dispose();
    }

    @Override
    public void increaseValue(int n) {
        this.setValue(this.jpb.getValue() + n);
    }

    public JProgressBar CreateProgressBar() {
        JProgressBar jProgressBar = new JProgressBar();
        JLabel jLabel = new JLabel(this.title);
        jLabel.setFont(PopUp.FONT);
        jLabel.setForeground(Color.WHITE);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(4));
        jPanel.setOpaque(false);
        JButton jButton = new JButton(this.canceltxt);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressableDialog.this.dispose();
            }
        });
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jProgressBar, "Center");
        jPanel2.add((Component)jPanel, "South");
        jProgressBar.setPreferredSize(new Dimension(500, 25));
        return jProgressBar;
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame();
        jFrame.setSize(800, 600);
        jFrame.setLocation(200, 200);
        jFrame.setVisible(true);
        ProgressableDialog progressableDialog = new ProgressableDialog(jFrame, true, new ProgressExecutor(){

            @Override
            public void cancel(Runnable runnable) {
            }

            @Override
            public void execute(final ProgressObserver progressObserver) {
                new Thread(){

                    @Override
                    public void run() {
                        int n = 0;
                        progressObserver.setMaximum(5);
                        try {
                            while (n < 5) {
                                Thread.sleep(1000L);
                                progressObserver.setValue(++n);
                            }
                            Thread.sleep(100000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        progressObserver.shutdown();
                    }
                }.start();
            }
        }, "Self-calibration in progress...Don`t disconnect connection.", "Cancel", "Are you sure to cancel? If YES, please reconnect the data cable and reboot the software.");
        progressableDialog.setVisible(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 27) {
                    ProgressableDialog.closeOwnedWindow(jFrame);
                }
                return false;
            }
        });
    }

    private static void closeOwnedWindow(JFrame jFrame) {
        Window[] windowArray = jFrame.getOwnedWindows();
        int n = windowArray.length;
        while (n-- > 0) {
            Window window = windowArray[n];
            if (!window.isVisible()) continue;
            window.dispose();
            break;
        }
    }
}

