/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.ui.dialog;

import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressMonitorDialog
extends JDialog {
    public static final String DefaultLabelText = "Progressing";
    public static final String DefaultBarText = "going...";
    public static final String DefaultTitleName = "PMDialog";
    public static final String DefaultButtonText = "cancel";
    private String titleName = "PMDialog";
    private String buttonText = "cancel";
    private int WIDTH = 580;
    private int LENGTH = 150;
    private JLabel label;
    private JProgressBar pBar;
    private JPanel panel;
    private JButton button;
    private int min = 0;
    private int max = 100;

    private ProgressMonitorDialog(String string) {
        this(null, string, DefaultLabelText, DefaultBarText, 0, 100);
    }

    public ProgressMonitorDialog(int n, int n2) {
        this(null, DefaultTitleName, DefaultLabelText, DefaultBarText, n, n2);
    }

    public ProgressMonitorDialog(Component component, String string, String string2, String string3, int n, int n2) {
        this.CreatDialog();
        this.setTitle(string);
        this.label.setText(string2);
        this.pBar.setString(string3);
        this.pBar.setMinimum(n);
        this.pBar.setMaximum(n2);
        if (component != null) {
            this.setLocationRelativeTo(component);
        } else {
            this.setLocationRelativeTo(null);
        }
        this.pack();
        this.setVisible(true);
    }

    private void CreatDialog() {
        Container container = this.getContentPane();
        this.setSize(new Dimension(this.WIDTH, this.LENGTH));
        this.setLayout(new OneColumnLayout(new Insets(0, 2, 2, 2), 0));
        this.setResizable(false);
        this.pBar = new JProgressBar(this.min, this.max);
        this.pBar.setStringPainted(true);
        this.pBar.setBorderPainted(true);
        this.label = new JLabel();
        this.panel = new JPanel();
        this.button = new JButton();
        this.setTitle(this.titleName);
        this.button.setText(this.buttonText);
        this.label.setPreferredSize(new Dimension(580, 40));
        this.panel.setLayout(new FlowLayout(2));
        this.panel.add(this.button);
        container.add(this.label);
        container.add(this.pBar);
        container.add(this.panel);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressMonitorDialog.this.close();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProgressMonitorDialog.this.close();
            }
        });
    }

    public void setMinimum(int n) {
        this.min = n;
        if (this.pBar != null) {
            this.pBar.setMinimum(n);
        }
    }

    public void setMaximum(int n) {
        this.max = n;
        if (this.pBar != null) {
            this.pBar.setMaximum(n);
        }
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (this.pBar != null) {
            this.pBar.setModel(boundedRangeModel);
        }
        this.repaint();
    }

    public void updateUI() {
        if (this.pBar != null) {
            this.pBar.updateUI();
        }
        this.repaint();
    }

    public void setMessage(String string) {
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    public void setNote(String string) {
        if (this.pBar != null) {
            this.pBar.setString(string);
        }
    }

    public void setValue(int n) {
        if (this.pBar != null) {
            if (n < this.min || n > this.max) {
                if (n < this.min) {
                    n = this.min;
                } else if (n > this.max) {
                    n = this.max;
                }
            }
            this.pBar.setValue(n);
        }
    }

    public void addProgressValue(int n) {
        if (this.pBar != null) {
            int n2 = this.pBar.getValue() + n;
            if (n2 > this.pBar.getMaximum()) {
                n2 = this.pBar.getMaximum();
            }
            this.pBar.setValue(n2);
        }
    }

    public void setValue_Note(int n) {
        if (this.pBar != null) {
            if (n < this.min || n > this.max) {
                if (n < this.min) {
                    n = this.min;
                } else if (n > this.max) {
                    n = this.max;
                }
            }
            this.pBar.setValue(n);
            this.setNote(n + "%");
        }
    }

    public void addProgressValue_Note(int n) {
        if (this.pBar != null) {
            int n2 = this.pBar.getValue() + n;
            if (n2 > this.pBar.getMaximum()) {
                n2 = this.pBar.getMaximum();
            }
            this.pBar.setValue(n2);
            this.setNote(n2 + "%");
        }
    }

    public void setButtonText(String string) {
        this.buttonText = string;
        this.button.setText(string);
    }

    public JProgressBar getProgressBar() {
        return this.pBar;
    }

    public void close() {
        this.dispose();
        this.pBar = null;
    }

    public boolean isCanceled() {
        return this.pBar == null;
    }

    public static void main(String[] stringArray) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog("ProgressMonitorDialog");
        progressMonitorDialog.setSize(400, 150);
        progressMonitorDialog.setButtonText("CANCEL");
        progressMonitorDialog.setMessage("Checking...");
        progressMonitorDialog.setNote("Contrasting Version.......");
        progressMonitorDialog.setMinimum(1);
        progressMonitorDialog.setMaximum(100);
        for (int i = 0; i < 100; ++i) {
            if (i == 50) {
                progressMonitorDialog.setNote("Contrast is done\uff0cdownload now?");
            }
            if (i == 90) {
                progressMonitorDialog.setNote("Download list has built,Contrast is closing...");
            }
            if (progressMonitorDialog.getProgressBar() != null) {
                progressMonitorDialog.setValue(i);
            }
            if (progressMonitorDialog.isCanceled()) {
                System.out.println("iscanceled " + i);
                break;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

