/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.tool.simple;

import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.tool.simple.InfiniteGetData;
import com.owon.uppersoft.vds.tool.simple.InteractiveBranch;
import com.owon.uppersoft.vds.tool.simple.UCModel;
import com.owon.uppersoft.vds.tool.simple.UsbComControl;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.util.ui.ListComboBoxModel;
import com.owon.uppersoft.vds.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UsbCommunicator {
    private JFrame frame;
    private JComboBox usbListcbb;
    private JToggleButton connectButton;
    private JToggleButton acceptButton;
    private JToggleButton startGetButton;
    private JLabel timelbl;
    private JButton sendButton;
    private JButton LoadButton;
    private JPanel viewchart;
    private JTextArea consoleArea;
    private JTextField msginputTf;
    private JTextField tf_value;
    private JTextField tf_bytes;
    private JTextField tf_add;
    private JTextField tf_byte;
    private JTextField tf_Int;
    private List<IDevice> devs;
    private Thread ui;
    private UsbComControl ucc;
    public Runnable m_startGet;
    public InteractiveBranch m_fpgaSend;
    private UCModel um = new UCModel();
    public boolean keepGet = false;
    public boolean addingcmd = false;

    public UsbComControl getUsbComControl() {
        return this.ucc;
    }

    public USBSourceManager getUSBSourceManager() {
        return this.ucc.getUSBSourceManager();
    }

    public void re_paint() {
        this.viewchart.repaint();
    }

    public static void main(String[] stringArray) {
        UsbCommunicator.launch();
    }

    public static void launch() {
        UIUtil.modifyui();
        final UsbCommunicator usbCommunicator = new UsbCommunicator();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    usbCommunicator.ui = Thread.currentThread();
                }
            });
            usbCommunicator.ui.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public UsbCommunicator() {
        this.ucc = new UsbComControl(this);
        this.m_startGet = new InfiniteGetData(this);
        this.m_fpgaSend = new InteractiveBranch(this, this.getUsbComControl().getUSBSourceManager());
        this.prepare();
        this.initialize();
        this.frame.setVisible(true);
    }

    private void prepare() {
        this.devs = this.ucc.refreshUSBPort();
    }

    private void initialize() {
        DBG.prepareLogType(4, new File("log"));
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.setDefaultCloseOperation(2);
        this.CreateSouthPane();
        JPanel jPanel = new JPanel();
        this.frame.getContentPane().add((Component)jPanel, "North");
        jPanel.setLayout(new OneColumnLayout());
        this.CreatePortPanel(jPanel);
        this.CreateTxtPanel(jPanel);
        this.CreateAddrPanel(jPanel);
        this.CreateHexPanel(jPanel);
        this.updateElapsedTimeLab(0L);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                UsbCommunicator.this.setGetDataKeep(false);
                DBG.errprintln("exit");
            }
        });
        DBG.dbgln("chart w=" + this.viewchart.getWidth() + ",chart y=" + this.viewchart.getHeight());
    }

    private void CreateSouthPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OneColumnLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 10, 10), new LineBorder(Color.black, 1, false)));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(1000, 200));
        jScrollPane2.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 10, 10), new LineBorder(Color.black, 1, false)));
        this.consoleArea = new JTextArea();
        this.consoleArea.setLineWrap(true);
        this.consoleArea.setWrapStyleWord(true);
        jScrollPane2.setViewportView(this.consoleArea);
        this.viewchart = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                UsbCommunicator.this.um.paint((Graphics2D)graphics);
            }
        };
        this.viewchart.setBackground(Color.black);
        this.viewchart.setPreferredSize(new Dimension(1000, 251));
        jScrollPane.setViewportView(this.viewchart);
        jPanel.add(jScrollPane);
        jPanel.add(jScrollPane2);
        this.frame.getContentPane().add((Component)jPanel, "South");
        this.um.viewchartClear();
    }

    private void CreatePortPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3));
        jPanel.add((Component)jPanel2, "North");
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(52, 15));
        jPanel2.add(jLabel);
        jLabel.setText("USBPort");
        this.usbListcbb = new JComboBox(new ListComboBoxModel(this.devs));
        this.usbListcbb.setPreferredSize(new Dimension(120, 28));
        jPanel2.add(this.usbListcbb);
        JButton jButton = new JButton();
        jPanel2.add(jButton);
        jButton.setText("Refresh");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UsbCommunicator.this.refresh();
            }
        });
        this.connectButton = new JToggleButton();
        jPanel2.add(this.connectButton);
        this.connectButton.setText("Connect");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = UsbCommunicator.this.connectButton.isSelected();
                UsbCommunicator.this.refresh();
                if (bl) {
                    int n = UsbCommunicator.this.usbListcbb.getSelectedIndex();
                    UsbCommunicator.this.ucc._getUSBSource((IDevice)UsbCommunicator.this.devs.get(n));
                } else {
                    UsbCommunicator.this.ucc.releaseUSBSource();
                    UsbCommunicator.this.setGetDataKeep(false);
                }
                UsbCommunicator.this.updateConnectStatus();
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setText("clear");
        jPanel2.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UsbCommunicator.this.consoleArea.setText(null);
                UsbCommunicator.this.viewchartClear();
            }
        });
        this.timelbl = new JLabel();
        jPanel2.add(this.timelbl);
    }

    private void CreateTxtPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        jPanel2.setLayout(flowLayout);
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel = new JLabel();
        jPanel2.add(jLabel);
        jLabel.setVerticalTextPosition(3);
        jLabel.setPreferredSize(new Dimension(52, 15));
        jLabel.setComponentPopupMenu(null);
        jLabel.setText("Message");
        this.sendButton = new JButton();
        jPanel2.add(this.sendButton);
        this.sendButton.setText("FPGAsend");
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(UsbCommunicator.this.m_fpgaSend);
                thread.start();
            }
        });
        this.startGetButton = new JToggleButton();
        this.startGetButton.setText("StartGet");
        this.startGetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = UsbCommunicator.this.startGetButton.isSelected();
                UsbCommunicator.this.startGetButton.setText(bl ? "stop" : "StartGet");
                if (bl) {
                    UsbCommunicator.this.setGetDataKeep(true);
                    Thread thread = new Thread(UsbCommunicator.this.m_startGet);
                    thread.start();
                } else {
                    UsbCommunicator.this.setGetDataKeep(false);
                }
            }
        });
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(InfiniteGetData.LTimeOut, 1, 10000, 1));
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InfiniteGetData.LTimeOut = (Integer)jSpinner.getValue();
            }
        });
        jSpinner.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                InfiniteGetData.LTimeOut = (Integer)jSpinner.getValue();
            }
        });
        this.acceptButton = new JToggleButton();
        this.acceptButton.setText("accept");
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = UsbCommunicator.this.acceptButton.isSelected();
                UsbCommunicator.this.sendButton.setEnabled(false);
                Thread thread = new Thread(UsbCommunicator.this.m_fpgaSend.acp);
                if (bl) {
                    if (!UsbCommunicator.this.ucc.isConnect()) {
                        int n = UsbCommunicator.this.usbListcbb.getSelectedIndex();
                        UsbCommunicator.this.ucc._getUSBSource((IDevice)UsbCommunicator.this.devs.get(n));
                    }
                    thread.start();
                    UsbCommunicator.this.addTextArea("start to accept...");
                } else {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    UsbCommunicator.this.addTextArea("stop accepting...");
                    UsbCommunicator.this.connectButton.setSelected(bl);
                    UsbCommunicator.this.updateConnectStatus();
                }
            }
        });
        this.LoadButton = new JButton("Load");
        this.LoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showOpenDialog(UsbCommunicator.this.frame);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    int n2 = (int)file.length();
                    byte[] byArray = new byte[n2];
                    CByteArrayInputStream cByteArrayInputStream = new CByteArrayInputStream(file);
                    cByteArrayInputStream.get(byArray, 0, n2);
                    if (cByteArrayInputStream != null) {
                        cByteArrayInputStream.dispose();
                    }
                    String string = file.getName();
                    UsbCommunicator.this.msginputTf.setText(string);
                    UsbCommunicator.this.addTextArea("LoadFileSize:" + n2);
                }
            }
        });
        jPanel2.add(this.startGetButton);
        jPanel2.add(jSpinner);
    }

    private void CreateAddrPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3));
        jPanel.add((Component)jPanel2, "South");
        JLabel jLabel = new JLabel("addr 0x");
        jPanel2.add(jLabel);
        this.tf_add = new JTextField();
        jPanel2.add(this.tf_add);
        this.tf_add.setColumns(6);
        JLabel jLabel2 = new JLabel("bytes 0x");
        jPanel2.add(jLabel2);
        this.tf_bytes = new JTextField();
        jPanel2.add(this.tf_bytes);
        this.tf_bytes.setColumns(6);
        JLabel jLabel3 = new JLabel("value 0x");
        jPanel2.add(jLabel3);
        this.tf_value = new JTextField();
        jPanel2.add(this.tf_value);
        this.tf_value.setColumns(6);
        JButton jButton = new JButton("add");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UsbCommunicator.this.um.setNdrawTrglevel(UsbCommunicator.this.tf_add.getText(), UsbCommunicator.this.tf_bytes.getText(), UsbCommunicator.this.tf_value.getText());
                UsbCommunicator.this.re_paint();
                UsbCommunicator.this.ucc.add2CMDList(UsbCommunicator.this.tf_add, UsbCommunicator.this.tf_bytes, UsbCommunicator.this.tf_value);
                UsbCommunicator.this.setInAddcmd(true);
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("send");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UsbCommunicator.this.um.setNdrawTrglevel(UsbCommunicator.this.tf_add.getText(), UsbCommunicator.this.tf_bytes.getText(), UsbCommunicator.this.tf_value.getText());
                UsbCommunicator.this.re_paint();
                if (UsbCommunicator.this.isKeepGet()) {
                    UsbCommunicator.this.ucc.add2CMDList(UsbCommunicator.this.tf_add, UsbCommunicator.this.tf_bytes, UsbCommunicator.this.tf_value);
                } else {
                    UsbCommunicator.this.ucc.sendNAcceptOneCMD(UsbCommunicator.this.tf_add, UsbCommunicator.this.tf_bytes, UsbCommunicator.this.tf_value);
                }
                UsbCommunicator.this.setInAddcmd(false);
            }
        });
        jPanel2.add(jButton2);
    }

    private void CreateHexPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3));
        jPanel.add((Component)jPanel2, "South");
        JLabel jLabel = new JLabel(" HEX byte 0x");
        jPanel2.add(jLabel);
        this.tf_byte = new JTextField();
        this.tf_byte.setColumns(5);
        jPanel2.add(this.tf_byte);
        JLabel jLabel2 = new JLabel(" HEX Int ");
        jPanel2.add(jLabel2);
        this.tf_Int = new JTextField();
        this.tf_Int.setColumns(6);
        jPanel2.add(this.tf_Int);
        JButton jButton = new JButton("send");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UsbCommunicator.this.ucc.sendByte_Int(UsbCommunicator.this.tf_byte, UsbCommunicator.this.tf_Int);
            }
        });
        jPanel2.add(jButton);
    }

    public String getMsgInputText() {
        return this.msginputTf.getText();
    }

    public void setGetDataKeep(boolean bl) {
        this.keepGet = bl;
    }

    public boolean isKeepGet() {
        return this.keepGet;
    }

    public void setInAddcmd(boolean bl) {
        this.addingcmd = bl;
    }

    public boolean canAddcmd() {
        return this.addingcmd;
    }

    public void updateElapsedTimeLab(long l) {
        this.timelbl.setText("t : " + l + " ms");
    }

    protected void viewchartClear() {
        this.um.viewchartClear();
        this.viewchart.repaint();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void updateConnectStatus() {
        boolean bl = this.connectButton.isSelected();
        if (bl) {
            if (this.ucc.isConnect()) {
                this.connectButton.setText("DisConnect");
                this.addTextArea("-----Conneted successfully-----");
            } else {
                this.addTextArea("-----Connection failure----");
            }
        } else {
            this.connectButton.setText("Connect");
            this.addTextArea("releaseUSBSource----");
            this.sendButton.setEnabled(true);
            this.acceptButton.setEnabled(true);
        }
    }

    protected void addTextArea(String string) {
        this.consoleArea.append(string + "\r\n");
    }

    protected void appendTextArea(String string) {
        this.consoleArea.append(string);
    }

    protected void addwordinLine(byte by) {
        this.consoleArea.append(by + ",");
    }

    private void refresh() {
        this.devs = this.ucc.refreshUSBPort();
        this.usbListcbb.removeAllItems();
        if (this.devs.size() <= 0) {
            this.addTextArea("*****No USB Detected*****");
            return;
        }
        for (IDevice iDevice : this.devs) {
            this.usbListcbb.addItem(iDevice);
        }
    }

    public int acceptResponse(byte[] byArray, int n) {
        return this.ucc.acceptResponse(byArray, n);
    }

    public int write(byte[] byArray, int n) {
        return this.ucc.write(byArray, n);
    }

    public UCModel getUCModel() {
        return this.um;
    }
}

