/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.tool.simple;

import ch.ntb.usb.USBException;
import com.owon.uppersoft.dso.source.usb.USBSource;
import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.vds.core.usb.CDevice;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.tool.simple.UCModel;
import com.owon.uppersoft.vds.tool.simple.UsbCommunicator;
import com.owon.uppersoft.vds.util.format.EndianUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextField;

public class UsbComControl {
    public static final int hcenter = 125;
    private UsbCommunicator uct;
    private USBSourceManager usm;
    private ByteBuffer sendCMDbuf = ByteBuffer.allocate(255);
    private byte[] acpCMDbuf = new byte[5];
    UCModel um;
    private static final int ReceiveSize = 5100;
    private byte[] adcbuf = new byte[10000];
    private byte[] usbbuf = new byte[5100];

    public ByteBuffer getSendCMDbuf() {
        return this.sendCMDbuf;
    }

    public UsbComControl(UsbCommunicator usbCommunicator) {
        this.uct = usbCommunicator;
        this.um = usbCommunicator.getUCModel();
        this.usm = new USBSourceManager(null);
    }

    public void addTextArea(String string) {
        this.uct.addTextArea(string);
    }

    public int insertdata(byte[] byArray) {
        int n = 0;
        byArray[n++] = 0;
        byArray[n++] = 66;
        byArray[n++] = 85;
        byArray[n++] = 83;
        byArray[n++] = 89;
        int n2 = -128;
        boolean bl = true;
        while (n < byArray.length) {
            byArray[n] = n < 1000 ? 0 : n2;
            n2 = bl ? (int)((byte)(n2 + 1)) : (int)((byte)(n2 - 1));
            if (n2 == -128 || n2 == 127) {
                bl = !bl;
            }
            ++n;
        }
        return n;
    }

    @Deprecated
    public void sendCommandtogetVDS_Version() {
        String string = ":SDSLVER";
        byte[] byArray = ":SDSLVER#".getBytes();
        this.write(byArray, byArray.length);
        int n = 33;
        byte[] byArray2 = new byte[n];
        int n2 = this.acceptResponse(byArray2, n);
        if (n2 != n) {
            DBG.outprintln("rn != " + n);
            return;
        }
        int n3 = 8;
        String string2 = new String(byArray2, 0, n3);
        if (!string2.equals(string)) {
            DBG.outprintln("recieve arr!=" + string);
            return;
        }
        this.uct.addTextArea("version:" + new String(byArray2, 0, n2));
    }

    public List<IDevice> refreshUSBPort() {
        try {
            List<IDevice> list = CDevice.getDevices((short)21317, (short)4660, null);
            return this.collectPorts(list);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new LinkedList<IDevice>();
        }
    }

    private List<IDevice> collectPorts(List<IDevice> list) throws USBException {
        int n = 0;
        for (IDevice iDevice : list) {
            String string = iDevice.getSerialNumber();
            if (string == null || string.isEmpty()) {
                iDevice.setSerialNumber("" + n);
            }
            ++n;
        }
        return list;
    }

    protected boolean isConnect() {
        return this.usm.isConnected();
    }

    protected USBSource _getUSBSource(IDevice iDevice) {
        return this.usm._getUSBSource(iDevice);
    }

    public USBSourceManager getUSBSourceManager() {
        return this.usm;
    }

    protected void releaseUSBSource() {
        this.usm.releaseUSBSource();
    }

    public int acceptResponse(byte[] byArray, int n) {
        return this.usm.acceptResponse(byArray, n);
    }

    public int write(byte[] byArray, int n) {
        return this.usm.write(byArray, n);
    }

    public void addCMD(int n, int n2, int n3, ByteBuffer byteBuffer) {
        int n4;
        int n5;
        byte[] byArray = byteBuffer.array();
        int n6 = n5 = byteBuffer.position();
        EndianUtil.writeIntL(byArray, n5, n);
        n2 = this.multBytesWriteL(n2, n3, byArray, n5 += 4);
        int n7 = 5 + n2;
        if (!this.uct.isKeepGet()) {
            this.addTextArea("[ADD (" + n7 + ") >>] 0x" + Integer.toHexString(n) + ", 0x" + Integer.toHexString(n2) + ", 0x" + Integer.toHexString(n3));
            n4 = 0;
            int n8 = n4 + n7;
            for (int i = n4; i < n8; ++i) {
                this.uct.addwordinLine(byArray[i]);
            }
            this.addTextArea("");
        }
        n4 = n6 + n7;
        byteBuffer.position(n4);
    }

    private int multBytesWriteL(int n, int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)n;
        switch (n) {
            case 1: {
                byArray[n3++] = (byte)n2;
                break;
            }
            case 2: {
                byArray[n3++] = (byte)n2;
                byArray[n3++] = (byte)(n2 >> 8);
                break;
            }
            case 3: {
                byArray[n3++] = (byte)n2;
                byArray[n3++] = (byte)(n2 >> 8);
                byArray[n3++] = (byte)(n2 >> 16);
                break;
            }
            case 4: {
                byArray[n3++] = (byte)n2;
                byArray[n3++] = (byte)(n2 >> 8);
                byArray[n3++] = (byte)(n2 >> 16);
                byArray[n3++] = (byte)(n2 >> 24);
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    protected void sendByte_Int(JTextField jTextField, JTextField jTextField2) {
        int n = 0;
        byte[] byArray = new byte[5];
        byte by = (byte)Integer.parseInt(jTextField.getText(), 16);
        int n2 = Integer.parseInt(jTextField2.getText(), 16);
        byArray[n++] = by;
        byArray[n++] = (byte)n2;
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n] = (byte)(n2 >> 24);
        int n3 = this.write(byArray, byArray.length);
        this.addTextArea("[send " + n3 + ":]0x" + jTextField.getText() + ", 0x" + jTextField2.getText());
        Arrays.fill(byArray, (byte)0);
        int n4 = this.acceptResponse(byArray, 5);
        int n5 = EndianUtil.nextIntL(byArray, 1);
        this.addTextArea("[GET (" + n4 + ") >>] " + (char)byArray[0] + " 0x" + Integer.toHexString(n5));
    }

    protected void acceptOneFrame(int n) {
        int n2 = 0;
        int n3 = this.acceptResponse(this.usbbuf, 5100);
        this.addTextArea("[GET (" + n3 + ") >>] " + n2 + ", " + n3);
        System.arraycopy(this.usbbuf, 0, this.adcbuf, n2, n3);
        n2 += n3;
        if (this.adcbuf[0] == 69) {
            String string = (char)this.adcbuf[0] + "";
            for (int i = 1; i <= 4; ++i) {
                string = string + (char)this.adcbuf[i];
            }
            this.addTextArea(string);
        } else if (n3 < 5000) {
            this.addTextArea("failed");
            this.uct.viewchartClear();
        } else {
            this.addTextArea("[GET adcData] ");
            for (int i = n - 1; i > 0; --i) {
                n3 = this.acceptResponse(this.usbbuf, 5100);
                this.addTextArea("[GET (" + n3 + ") adcData] " + n2 + ", " + n3);
                System.arraycopy(this.usbbuf, 0, this.adcbuf, n2, n3);
                n2 += n3;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.adcbuf, 0, n2);
            byteBuffer.position(0);
            this.um.resetNtailorBuf(byteBuffer, 125);
            this.uct.re_paint();
        }
    }

    protected void add2CMDList(JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        int n = Integer.parseInt(jTextField.getText(), 16);
        int n2 = Integer.parseInt(jTextField2.getText(), 16);
        int n3 = Integer.parseInt(jTextField3.getText(), 16);
        this.addCMD(n, n2, n3, this.sendCMDbuf);
    }

    protected void sendNAcceptOneCMD(JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        if (this.sendCMDbuf.position() == 0) {
            this.add2CMDList(jTextField, jTextField2, jTextField3);
        }
        this.dealCMDInteractive();
    }

    protected void dealCMDInteractive() {
        int n = this.sendCMDbuf.position();
        System.out.println("position:" + n);
        this.write(this.sendCMDbuf.array(), n);
        this.sendCMDbuf.position(0);
        this.acceptResponse(this.acpCMDbuf, 5);
        int n2 = EndianUtil.nextIntL(this.acpCMDbuf, 1);
        this.addTextArea("[GET (5) >>] " + (char)this.acpCMDbuf[0] + " 0x" + Integer.toHexString(n2));
    }
}

