/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.tool.simple;

import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.vds.core.rt.WFDrawRTUtil;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import java.awt.Color;
import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.List;

public class UCModel {
    private List<ChlModel> chls = new LinkedList<ChlModel>();
    private static final int adcmin = -125;
    private static final int adcmax = 125;
    public static final int _1k = 1000;

    public UCModel() {
        int n = 0;
        this.chls.add(new ChlModel());
        this.chls.add(new ChlModel());
        for (ChlModel chlModel : this.chls) {
            chlModel.number = n;
            if (n == 0) {
                chlModel.on = true;
                chlModel.co = Color.RED;
            } else {
                chlModel.on = true;
                chlModel.co = Color.YELLOW;
            }
            ++n;
        }
    }

    public void resetNtailorBuf(ByteBuffer byteBuffer, int n) {
        for (ChlModel chlModel : this.chls) {
            if (!chlModel.on) continue;
            byteBuffer.position(byteBuffer.position() + 1000);
            chlModel.resetNtailorBuf(byteBuffer, n);
        }
    }

    protected void viewchartClear() {
        for (ChlModel chlModel : this.chls) {
            chlModel.pixbuf.clear();
        }
    }

    public void paint(Graphics2D graphics2D) {
        this.drawGrids(graphics2D);
        for (ChlModel chlModel : this.chls) {
            if (!chlModel.on) continue;
            chlModel.paint(graphics2D);
        }
    }

    public ChlModel getChl(int n) {
        for (ChlModel chlModel : this.chls) {
            if (chlModel.number != n) continue;
            return chlModel;
        }
        return null;
    }

    private void drawGrids(Graphics2D graphics2D) {
        graphics2D.setColor(Color.white);
        LineDrawTool.drawSashLine(graphics2D, false, 500, 0, 1000, 125, 9);
        LineDrawTool.drawSashLine(graphics2D, true, 125, 0, 250, 375, 9);
    }

    public void setNdrawTrglevel(String string, String string2, String string3) {
        boolean bl = string.equalsIgnoreCase("2E") && string2.equals("1");
        boolean bl2 = string.equalsIgnoreCase("30") && string2.equals("1");
        int n = Integer.parseInt(string3, 16);
        if (bl) {
            this.getChl(0).setNdrawTrglevel(n);
        } else if (bl2) {
            this.getChl(1).setNdrawTrglevel(n);
        }
    }

    public class ChlModel {
        public int number = -1;
        public static final int _4k = 4000;
        public IntBuffer pixbuf = IntBuffer.allocate(4000);
        public int trg;
        public Color co = null;
        public boolean on = false;

        public void resetNtailorBuf(ByteBuffer byteBuffer, int n) {
            int n2 = byteBuffer.position();
            int n3 = n2 + 4000;
            int n4 = 0;
            DBG.dbgln(n2 + "," + n3);
            this.pixbuf.position(n4);
            int[] nArray = this.pixbuf.array();
            byte[] byArray = byteBuffer.array();
            while (n2 < n3) {
                int n5 = byArray[n2];
                if (n5 > 125) {
                    n5 = 125;
                } else if (n5 < -125) {
                    n5 = -125;
                }
                nArray[n4] = n - n5;
                ++n2;
                ++n4;
            }
            this.pixbuf.limit(n4);
            byteBuffer.position(n2);
        }

        public void setNdrawTrglevel(int n) {
            this.trg = n;
            if (this.trg > 127) {
                this.trg -= 256;
            }
            this.trg = 125 - this.trg;
        }

        public void paint(Graphics2D graphics2D) {
            int n = 0;
            boolean bl = false;
            int n2 = 4;
            this.drawTrgTriangle(graphics2D, this.co, this.trg);
            WFDrawRTUtil.paintDrawMode(graphics2D, this.pixbuf, n2, n, bl);
        }

        private void drawTrgTriangle(Graphics2D graphics2D, Color color, int n) {
            graphics2D.setColor(color);
            graphics2D.drawLine(0, n, 10, n);
            graphics2D.drawLine(0, n, 4, n - 4);
            graphics2D.drawLine(0, n, 4, n + 4);
            String string = 125 - n + "";
            graphics2D.drawString(string + "", 15, n + 5);
        }
    }
}

