/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.source.front;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.mode.control.DeepMemoryControl;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.uppersoft.vds.core.data.MinMax;
import com.owon.uppersoft.vds.core.deep.struct.RangeInfo4in1;
import com.owon.uppersoft.vds.machine.LowControlManger;
import com.owon.uppersoft.vds.machine.MachineInfo_Tiny;
import com.owon.uppersoft.vds.source.comm.data.ChannelDataInfo_Tiny;
import com.owon.uppersoft.vds.source.comm.data.ChannelsTransportInfo_Tiny;
import com.owon.uppersoft.vds.source.front.SmallTimebasePreHandler;
import com.owon.uppersoft.vds.source.front.TrgLocateInfo;
import com.owon.uppersoft.vds.util.LoadArrayUtil;
import java.nio.ByteBuffer;

public abstract class AbsPreHandler {
    public static final int TRANBUFLOC_TRGBEG = 11;
    public static final int TRANBUFLEN_TRG = 100;
    public static final int TRANBUFLOC_DMBEG = 111;
    public static final int TRANBUFLEN_PREDM = 50;
    public static final int TRANBUFLEN_SUFDM = 50;
    public static final int TRANBUFLEN_DM = 5000;
    public static final int TRANBUFLEN_ALLDM = 5100;
    public static final int BufferSize = 5211;
    public static final int ReceiveSize = 5211;
    protected ControlManager cm;
    protected TimeControl tc;
    protected LowControlManger lcm;
    protected TrgLocateInfo tli = new TrgLocateInfo();
    protected SmallTimebasePreHandler stp;
    public static final int ADC_MAX = 125;
    public static final int ADC_MIN = -125;
    protected VLog vl = new VLog();
    private ByteBuffer[] temp;

    public AbsPreHandler(ControlManager controlManager, LowControlManger lowControlManger) {
        this.cm = controlManager;
        this.lcm = lowControlManger;
        this.tc = controlManager.getTimeControl();
        this.temp = new ByteBuffer[controlManager.getAllChannelsNumber()];
        this.stp = new SmallTimebasePreHandler(controlManager);
        this.vl.on = false;
    }

    protected DeepMemoryControl getDeepMemoryControl() {
        return this.cm.getDeepMemoryControl();
    }

    protected WaveFormInfoControl getWaveFormInfoControl() {
        return this.cm.getWaveFormInfoControl();
    }

    protected MachineInfo_Tiny getMachineInfo() {
        return (MachineInfo_Tiny)this.cm.getMachineInfo();
    }

    public static final byte limitValue2Byte(int n) {
        n = n > 125 ? 125 : n;
        n = n < -125 ? -125 : n;
        return (byte)n;
    }

    protected int getFullScreen() {
        return this.getMachineInfo().getFullScreen(0, this.getDeepMemoryControl().getDeepIdx())[this.tc.getTimebaseIdx()];
    }

    public abstract void preLoadReceiveData(ChannelsTransportInfo_Tiny var1);

    protected void handelData_noplug(ByteBuffer byteBuffer, ChannelDataInfo_Tiny channelDataInfo_Tiny, ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny, int n, int n2) {
        this.vl.logln("handelData_noplug");
        ByteBuffer byteBuffer2 = this.allocate(channelDataInfo_Tiny.chl, n2);
        byte[] byArray = byteBuffer2.array();
        byte[] byArray2 = byteBuffer.array();
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        this.vl.logln(channelDataInfo_Tiny.chl + ", " + n3 + ", " + n4);
        int n5 = (n3 + n4 >> 1) - (n2 >> 1);
        int n6 = 0;
        byteBuffer2.position(n6);
        System.arraycopy(byArray2, n5, byArray, n6, n2);
        byteBuffer2.limit(n6 += n2);
        channelDataInfo_Tiny.dmInitPos = n5 - n3;
        channelDataInfo_Tiny.dmfullscreen = n2;
        channelDataInfo_Tiny.dmslowMove = 0;
        channelsTransportInfo_Tiny.tailhandle(channelDataInfo_Tiny, byteBuffer2, 0);
    }

    protected void handelData_fullscreen(ByteBuffer byteBuffer, ChannelDataInfo_Tiny channelDataInfo_Tiny, ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny, boolean bl, int n) {
        int n2;
        Object object;
        this.vl.logln("handelData_fullscreen " + n);
        int n3 = 1000;
        int n4 = n3 * n;
        ByteBuffer byteBuffer2 = this.allocate(channelDataInfo_Tiny.chl, n4);
        byte[] byArray = byteBuffer2.array();
        byte[] byArray2 = byteBuffer.array();
        int n5 = byteBuffer.position();
        int n6 = byteBuffer.limit();
        int n7 = n6 - n5;
        int n8 = n7 / n3;
        int n9 = 0;
        byteBuffer2.position(n9);
        this.vl.logln(channelDataInfo_Tiny.chl + ": " + n5 + " -> " + n6);
        if (n == 4) {
            object = new RangeInfo4in1();
            for (n2 = n5; n2 != n6; n2 += n8) {
                LoadArrayUtil._4for1((RangeInfo4in1)object, byArray2, n2, n8);
                n9 = ((RangeInfo4in1)object).fillArray(byArray, n9);
            }
        } else if (n == 2) {
            object = new MinMax();
            while (n2 != n6) {
                LoadArrayUtil._2for1((MinMax)object, byArray2, n2, n8);
                n2 += n8;
                n9 = ((MinMax)object).fillArray(byArray, n9);
            }
        } else {
            System.err.println("err uncheck situation: PreHandler handelData_fullscreen");
        }
        byteBuffer2.limit(n9);
        int n10 = 0;
        int n11 = 0;
        if (bl || channelDataInfo_Tiny.slowMove < n7) {
            n10 = channelDataInfo_Tiny.slowMove;
            if (n10 > n7) {
                n10 = n7;
            }
            n11 = n10 / n8 * n;
        }
        channelDataInfo_Tiny.dmInitPos = 0;
        channelDataInfo_Tiny.dmfullscreen = n7;
        channelDataInfo_Tiny.dmslowMove = n10;
        channelsTransportInfo_Tiny.tailhandle(channelDataInfo_Tiny, byteBuffer2, n11);
    }

    protected ByteBuffer allocate(int n, int n2) {
        ByteBuffer byteBuffer = this.temp[n];
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(5000);
        }
        byteBuffer.position(0);
        byteBuffer.limit(n2);
        return byteBuffer;
    }
}

