/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.source.comm.ext;

import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.EdgeTrigger;
import com.owon.uppersoft.dso.model.trigger.PulseTrigger;
import com.owon.uppersoft.dso.model.trigger.SlopeTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.VideoTrigger;
import com.owon.uppersoft.dso.model.trigger.common.Thredshold;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_Holdoff;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_TrgConditon;
import com.owon.uppersoft.vds.device.interpret.util.CBitSet;
import com.owon.uppersoft.vds.source.comm.Submitor2;

public class TinyTrgSubmitHandler {
    private static final int[] Tiny_TrgType = new int[]{0, 2, 1, 3};
    private static final int[] Tiny_Sweep = new int[]{0, 1, 2};
    private static final int[] Tiny_SYNC = new int[]{0, 1, 2, 3, 4};
    private static final int[] Tiny_CONDITIONS_PULSE = new int[]{0, 1, 2, 4, 5, 6};
    private static final int[] Tiny_CONDITIONS_SLOPE = new int[]{0, 1, 2, 4, 5, 6};

    public void selfSubmit_Tiny(Submitor2 submitor2, TriggerControl triggerControl) {
        byte by = triggerControl.getChannelModeAlpha();
        if (triggerControl.getChannelMode() == 1) {
            boolean bl = false;
            int n = triggerControl.getChannelsNumber();
            for (int i = 0; i < n; ++i) {
                TriggerSet triggerSet = triggerControl.getAlternateTriggerSet(i);
                if (triggerSet == null) continue;
                this.handleSubmit_trg_type(by, i, submitor2, bl, triggerSet, triggerControl);
                submitor2.wrEmpty();
            }
        } else {
            boolean bl = true;
            TriggerSet triggerSet = triggerControl.getSingleTriggerSet();
            this.handleSubmit_trg_type(by, triggerSet.getChannel(), submitor2, bl, triggerSet, triggerControl);
        }
    }

    private void handleSubmit_trg_type(int n, int n2, Submitor2 submitor2, boolean bl, TriggerSet triggerSet, TriggerControl triggerControl) {
        CBitSet cBitSet = new CBitSet(16);
        cBitSet.clear();
        boolean bl2 = !bl;
        AbsTrigger absTrigger = triggerSet.getTrigger();
        int n3 = triggerSet.getChannel();
        int n4 = Tiny_TrgType[absTrigger.type.ordinal()];
        if (bl) {
            cBitSet.set1(bl2, 15);
            cBitSet.setN(n4, 8, 14);
            if (triggerControl.isExtTrg(n3)) {
                cBitSet.set1(0, 13);
                cBitSet.set1(1, 0);
            } else {
                cBitSet.set1(n3, 13);
                cBitSet.set1(0, 0);
            }
        } else {
            cBitSet.set1(bl2, 15);
            cBitSet.setN(n4, 13, 8);
            cBitSet.set1(n3, 14);
        }
        if (absTrigger instanceof VideoTrigger) {
            VideoTrigger videoTrigger = (VideoTrigger)absTrigger;
            cBitSet.setN(videoTrigger.module, 7, 9);
        }
        this.submit_trg_type(absTrigger, cBitSet, bl);
        submitor2.wrTrg(cBitSet.getValue());
        this.submit_trg_addition(n, n2, absTrigger, submitor2);
    }

    private void submit_trg_type(AbsTrigger absTrigger, CBitSet cBitSet, boolean bl) {
        switch (absTrigger.type) {
            case Edge: {
                EdgeTrigger edgeTrigger = (EdgeTrigger)absTrigger;
                int n = 0;
                int n2 = Tiny_Sweep[edgeTrigger.getSweep()];
                if (bl) {
                    cBitSet.set1(edgeTrigger.raisefall, 12);
                    cBitSet.setN(n2, 10, 11);
                    cBitSet.set1(n, 9);
                    break;
                }
                cBitSet.set1(edgeTrigger.raisefall, 12);
                break;
            }
            case Video: {
                VideoTrigger videoTrigger = (VideoTrigger)absTrigger;
                int n = Tiny_SYNC[videoTrigger.sync];
                if (bl) {
                    cBitSet.setN(n, 10, 11, 12);
                    break;
                }
                cBitSet.setN(n, 10, 11, 12);
                break;
            }
            case Slope: {
                SlopeTrigger slopeTrigger = (SlopeTrigger)absTrigger;
                int n = Tiny_Sweep[slopeTrigger.getSweep()];
                int n3 = Tiny_CONDITIONS_SLOPE[slopeTrigger.condition];
                if (bl) {
                    cBitSet.setN(n, 10, 11);
                    cBitSet.setN(n3, 5, 6, 7);
                    break;
                }
                cBitSet.setN(n3, 5, 6, 7);
                break;
            }
            case Pulse: {
                PulseTrigger pulseTrigger = (PulseTrigger)absTrigger;
                int n = Tiny_Sweep[pulseTrigger.getSweep()];
                int n4 = Tiny_CONDITIONS_PULSE[pulseTrigger.condition];
                if (bl) {
                    cBitSet.setN(n, 10, 11);
                    cBitSet.setN(n4, 5, 6, 7);
                    break;
                }
                cBitSet.setN(n4, 5, 6, 7);
            }
        }
    }

    private void submit_trg_addition(int n, int n2, AbsTrigger absTrigger, Submitor2 submitor2) {
        ETV_Holdoff eTV_Holdoff = absTrigger.etvho;
        switch (absTrigger.type) {
            case Edge: {
                EdgeTrigger edgeTrigger = (EdgeTrigger)absTrigger;
                submitor2.c_trg_edge(n, n2, (byte)4, eTV_Holdoff.toInt(), eTV_Holdoff.getValueDivTimeOnStage(), eTV_Holdoff.enumPart());
                submitor2.c_trg_edge(n, n2, (byte)6, edgeTrigger.c_getVoltsense(), edgeTrigger.raisefall);
                break;
            }
            case Video: {
                VideoTrigger videoTrigger = (VideoTrigger)absTrigger;
                submitor2.c_trg_video(n, n2, (byte)4, eTV_Holdoff.toInt(), eTV_Holdoff.getValueDivTimeOnStage(), eTV_Holdoff.enumPart());
                submitor2.c_trg_video(n, n2, (byte)3, videoTrigger.sync, videoTrigger.syncValue);
                break;
            }
            case Slope: {
                Object object;
                SlopeTrigger slopeTrigger = (SlopeTrigger)absTrigger;
                ETV_TrgConditon eTV_TrgConditon = slopeTrigger.trgcondition;
                submitor2.c_trg_slope(n, n2, (byte)4, eTV_Holdoff.toInt(), eTV_Holdoff.getValueDivTimeOnStage(), eTV_Holdoff.enumPart());
                if (SoftwareControl.firmware > 2) {
                    object = eTV_TrgConditon.getValue();
                    submitor2.c_trg_slope(n2, (byte)5, slopeTrigger.condition, eTV_TrgConditon.toInt(), object[0], object[1]);
                } else {
                    submitor2.c_trg_slope(n, n2, (byte)5, slopeTrigger.condition, eTV_TrgConditon.toInt(), eTV_TrgConditon.getValueDivTimeOnStage(), eTV_TrgConditon.enumPart());
                }
                object = slopeTrigger.getThredshold();
                submitor2.c_trg_slope(n, n2, (byte)2, ((Thredshold)object).c_getUppest());
                submitor2.c_trg_slope(n, n2, (byte)6, ((Thredshold)object).c_getLowest());
                break;
            }
            case Pulse: {
                PulseTrigger pulseTrigger = (PulseTrigger)absTrigger;
                ETV_TrgConditon eTV_TrgConditon = pulseTrigger.trgcondition;
                submitor2.c_trg_pulse(n, n2, (byte)4, eTV_Holdoff.toInt(), eTV_Holdoff.getValueDivTimeOnStage(), eTV_Holdoff.enumPart());
                submitor2.c_trg_pulse(n, n2, (byte)6, pulseTrigger.c_getVoltsense(), pulseTrigger.getRaiseNFall());
                if (SoftwareControl.firmware > 2) {
                    int[] nArray = eTV_TrgConditon.getValue();
                    submitor2.c_trg_pulse(n2, (byte)5, pulseTrigger.condition, eTV_TrgConditon.toInt(), nArray[0], nArray[1]);
                    break;
                }
                submitor2.c_trg_pulse(n, n2, (byte)5, pulseTrigger.condition, eTV_TrgConditon.toInt(), eTV_TrgConditon.getValueDivTimeOnStage(), eTV_TrgConditon.enumPart());
            }
        }
    }
}

