/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.source.comm.data;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.device.interpret.DeviceAddressTable;
import com.owon.uppersoft.vds.device.interpret.util.Sendable;
import com.owon.uppersoft.vds.source.comm.data.ChannelsTransportInfo_Tiny;
import com.owon.uppersoft.vds.source.comm.data.GetDataRunner2;
import com.owon.uppersoft.vds.util.ArrayLogger;
import com.owon.uppersoft.vds.util.format.EndianUtil;
import com.owon.vds.firm.protocol.AddressAttachCommand;

public class TrgStatusInvestigator {
    private VLog el = new VLog();
    private ControlManager cm;
    private WaveFormInfoControl wfic;
    private DeviceAddressTable table;
    private GetDataRunner2.DataReceiveHandler drh;
    private byte[] RESPONSE_BUF = new byte[5];

    public TrgStatusInvestigator(ControlManager controlManager, DeviceAddressTable deviceAddressTable, GetDataRunner2.DataReceiveHandler dataReceiveHandler) {
        this.cm = controlManager;
        this.drh = dataReceiveHandler;
        this.table = deviceAddressTable;
        this.wfic = controlManager.getWaveFormInfoControl();
        this.el.on = false;
    }

    protected int getTrgStatus(ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny, ICommunicateManager iCommunicateManager) {
        AddressAttachCommand addressAttachCommand = this.table.TRG_D_ADD;
        this.el.logln(addressAttachCommand);
        int n = 0;
        int n2 = Sendable.writeCommmand(iCommunicateManager, addressAttachCommand, 0);
        if (n2 <= 0) {
            channelsTransportInfo_Tiny.status = 4;
            return -1;
        }
        byte[] byArray = this.RESPONSE_BUF;
        int n3 = iCommunicateManager.acceptResponse(byArray, byArray.length);
        if (n3 <= 0) {
            channelsTransportInfo_Tiny.status = 4;
            return -1;
        }
        ArrayLogger.outArray2Logable((Logable)this.el, byArray, 0, n3);
        n = EndianUtil.nextIntL(byArray, 1);
        this.el.logln("trg_d: " + n);
        WaveFormInfo[] waveFormInfoArray = this.wfic.getWaveFormInfos();
        int n4 = waveFormInfoArray.length;
        for (int i = 0; i < n4; ++i) {
            if (waveFormInfoArray[i].ci.isOn()) continue;
            n &= ~(1 << i);
        }
        return n;
    }

    protected int getDataFinishedStatus(ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny, ICommunicateManager iCommunicateManager) {
        AddressAttachCommand addressAttachCommand = this.table.datafinished_ADD;
        this.el.logln(addressAttachCommand);
        int n = 0;
        int n2 = Sendable.writeCommmand(iCommunicateManager, addressAttachCommand, 0);
        if (n2 <= 0) {
            channelsTransportInfo_Tiny.status = 4;
            return -1;
        }
        byte[] byArray = this.RESPONSE_BUF;
        int n3 = iCommunicateManager.acceptResponse(byArray, byArray.length);
        if (n3 <= 0) {
            channelsTransportInfo_Tiny.status = 4;
            return -1;
        }
        ArrayLogger.outArray2Logable((Logable)this.el, byArray, 0, n3);
        n = EndianUtil.nextIntL(byArray, 1);
        this.el.logln("datafinished: " + n);
        return Math.abs(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkStatusForGetDataT(ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny, ICommunicateManager iCommunicateManager) {
        int n;
        channelsTransportInfo_Tiny.channel_trg_status = 0;
        TriggerControl triggerControl = this.cm.getCoreControl().getTriggerControl();
        channelsTransportInfo_Tiny.resetTrg_d();
        int n2 = this.getTrgStatus(channelsTransportInfo_Tiny, iCommunicateManager);
        if (n2 < 0) {
            return false;
        }
        if (this.cm.getTimeControl().isOnSlowMoveTimebase()) {
            channelsTransportInfo_Tiny.channel_trg_status = n2;
            if (triggerControl.isSweepNormal()) {
                if (n2 == 0) {
                    channelsTransportInfo_Tiny.triggerStatus = TrgStatus.Ready.ordinal();
                    channelsTransportInfo_Tiny.status = 0;
                    channelsTransportInfo_Tiny.setFrameCount(0);
                    this.dealTrgStatus(channelsTransportInfo_Tiny);
                    return false;
                }
                channelsTransportInfo_Tiny.triggerStatus = TrgStatus.Trg_d.ordinal();
                return true;
            }
            if (!triggerControl.isSweepOnce()) {
                channelsTransportInfo_Tiny.triggerStatus = TrgStatus.Scan.ordinal();
                return true;
            }
            if (channelsTransportInfo_Tiny.frameAllNum == 0 || channelsTransportInfo_Tiny.trigPos == 0) {
                if (n2 == 0) {
                    channelsTransportInfo_Tiny.trigPos = Integer.MAX_VALUE;
                }
                channelsTransportInfo_Tiny.triggerStatus = TrgStatus.Ready.ordinal();
                return true;
            }
            if (n2 == 0) return true;
            if (channelsTransportInfo_Tiny.trigTime == Long.MAX_VALUE) {
                channelsTransportInfo_Tiny.trigTime = System.nanoTime();
            }
            channelsTransportInfo_Tiny.triggerStatus = TrgStatus.Trg_d.ordinal();
            return true;
        }
        int n3 = this.getDataFinishedStatus(channelsTransportInfo_Tiny, iCommunicateManager);
        if (n3 < 0) {
            return false;
        }
        if (triggerControl.isSingleTrg()) {
            if (triggerControl.isSweepAuto()) {
                n = n2 != 0 ? TrgStatus.Trg_d.ordinal() : TrgStatus.Auto.ordinal();
            } else if (triggerControl.isSweepOnce()) {
                if (channelsTransportInfo_Tiny.trigPos == 0) {
                    channelsTransportInfo_Tiny.trigPos = n2 == 0 || n3 != 0 ? -1 : 0;
                    channelsTransportInfo_Tiny.status = 0;
                    channelsTransportInfo_Tiny.setFrameCount(0);
                    channelsTransportInfo_Tiny.triggerStatus = TrgStatus.Ready.ordinal();
                    this.dealTrgStatus(channelsTransportInfo_Tiny);
                    return false;
                }
                n = TrgStatus.Ready.ordinal();
                if (n2 == 0) {
                    if (n3 <= 0) {
                        channelsTransportInfo_Tiny.status = 0;
                        channelsTransportInfo_Tiny.setFrameCount(0);
                        channelsTransportInfo_Tiny.channel_trg_status = n2;
                        channelsTransportInfo_Tiny.triggerStatus = n;
                        this.dealTrgStatus(channelsTransportInfo_Tiny);
                        return false;
                    }
                    n = TrgStatus.Stop.ordinal();
                    this.onSweepOutAsOnce();
                } else {
                    n = TrgStatus.Stop.ordinal();
                    channelsTransportInfo_Tiny.fetchUntilData = true;
                }
            } else {
                n = n2 == 0 ? TrgStatus.Ready.ordinal() : TrgStatus.Trg_d.ordinal();
                if (n3 == 0) {
                    channelsTransportInfo_Tiny.status = 0;
                    channelsTransportInfo_Tiny.setFrameCount(0);
                    channelsTransportInfo_Tiny.channel_trg_status = n2;
                    channelsTransportInfo_Tiny.triggerStatus = n;
                    this.dealTrgStatus(channelsTransportInfo_Tiny);
                    return false;
                }
            }
            boolean bl = triggerControl.isOnExtTrgMode();
            if (bl) {
                n2 = 0;
            }
        } else {
            n = n2 != 0 ? TrgStatus.Trg_d.ordinal() : TrgStatus.Auto.ordinal();
        }
        channelsTransportInfo_Tiny.channel_trg_status = n2;
        this.el.logln("trg_status: " + n2);
        channelsTransportInfo_Tiny.triggerStatus = n;
        return true;
    }

    protected void onSweepOutAsOnce() {
        this.drh.onSweepOutAsOnce();
    }

    public void dealTrgStatus(ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny) {
        boolean bl;
        int n;
        TriggerControl triggerControl = this.cm.getCoreControl().getTriggerControl();
        TimeControl timeControl = this.cm.getTimeControl();
        if (timeControl.isOnSlowMoveTimebase() && triggerControl.isSweepOnce()) {
            boolean bl2;
            long l;
            n = channelsTransportInfo_Tiny.getUnUsedChannelDataInfo((int)0).slowMove;
            if (channelsTransportInfo_Tiny.channel_trg_status != 0 && channelsTransportInfo_Tiny.trigPos == Integer.MAX_VALUE) {
                channelsTransportInfo_Tiny.trigPos = n;
            }
            boolean bl3 = (double)(l = (System.nanoTime() - channelsTransportInfo_Tiny.trigTime) / 1000000L) > timeControl.getSlowTriggerTime();
            boolean bl4 = bl2 = (double)(n - channelsTransportInfo_Tiny.trigPos) > timeControl.getSlowTriggerPos();
            if (bl3 || bl2) {
                channelsTransportInfo_Tiny.triggerStatus = TrgStatus.Stop.ordinal();
                this.onSweepOutAsOnce();
            }
        }
        n = channelsTransportInfo_Tiny.triggerStatus;
        TrgStatus trgStatus = TrgStatus.Scan;
        boolean bl5 = bl = n < TrgStatus.VALUES.length && n >= 0;
        if (!bl) {
            channelsTransportInfo_Tiny.triggerStatus = n = TrgStatus.Error.ordinal();
        }
        trgStatus = TrgStatus.VALUES[n];
        Platform.getMainWindow().updateStatus(trgStatus);
    }

    public void onDataReceive(ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny) {
    }
}

