/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.source.comm.data;

import ch.ntb.usb.USBException;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.source.comm.AbsGetDataRunner;
import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.vds.core.aspect.base.EchoLogger;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import com.owon.uppersoft.vds.device.interpret.util.Sendable;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.source.comm.SourceManagerTiny;
import com.owon.uppersoft.vds.source.comm.data.ADCMemory;
import com.owon.uppersoft.vds.source.comm.data.ChannelDataInfo_Tiny;
import com.owon.uppersoft.vds.source.comm.data.ChannelsTransportInfo_Tiny;
import com.owon.uppersoft.vds.source.comm.data.TrgStatusInvestigator;
import com.owon.uppersoft.vds.source.comm.data.ValueFeeder;
import com.owon.uppersoft.vds.source.front.AbsPreHandler;
import com.owon.uppersoft.vds.util.ArrayLogger;
import com.owon.vds.firm.protocol.AddValueAttachCommand;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;

public class GetDataRunner2
extends AbsGetDataRunner {
    private AbsPreHandler ph;
    private ChannelsTransportInfo_Tiny ci;
    private Source src;
    private DataReceiveHandler dataReceiveListener;
    private WaveFormInfoControl wfic;
    public static AddValueAttachCommand GETDATA_ADD = new AddValueAttachCommand("GETDATA_ADD", 4096, 2, 0);
    private TinyMachine tm;
    private ValueFeeder vf;
    private TrgStatusInvestigator si;
    public static final int timeout = 50;
    public static final int DefaultNoDataTimes = 15;
    private int noDataTimes = 0;
    private ADCMemory adcm;
    private EchoLogger echo_vl = new EchoLogger();
    private VLog vl = new VLog();

    @Override
    public ChannelsTransportInfo_Tiny getChannelsTransportInfo() {
        return this.ci;
    }

    public ValueFeeder getValueFeeder() {
        return this.vf;
    }

    public GetDataRunner2(DataHouse dataHouse, final ICommunicateManager iCommunicateManager, AbsPreHandler absPreHandler, DataReceiveHandler dataReceiveHandler, TinyMachine tinyMachine) {
        super(dataHouse, iCommunicateManager);
        this.dataReceiveListener = dataReceiveHandler;
        this.tm = tinyMachine;
        this.ph = absPreHandler;
        this.wfic = this.cm.getWaveFormInfoControl();
        this.adcm = new ADCMemory(this.cm.getAllChannelsNumber(), 5211);
        this.ci = new ChannelsTransportInfo_Tiny();
        this.vl.on = false;
        this.echo_vl.on = false;
        this.si = new TrgStatusInvestigator(this.cm, tinyMachine.getDeviceAddressTable(), dataReceiveHandler);
        this.src = new Source(){

            @Override
            public int acceptResponse(byte[] byArray, int n) {
                SourceManagerTiny sourceManagerTiny = (SourceManagerTiny)iCommunicateManager;
                if (sourceManagerTiny.isUSBConnect()) {
                    USBSourceManager uSBSourceManager = sourceManagerTiny.getUSBSourceManager();
                    return uSBSourceManager.acceptResponse(byArray, n, 50);
                }
                return sourceManagerTiny.getChoice().acceptResponse(byArray, n);
            }
        };
        this.vf = new ValueFeeder(tinyMachine.getDeviceAddressTable().channel_freqref);
    }

    @Override
    public ChannelsTransportInfo getData() {
        if (!this.cm.isRuntime()) {
            if (this.ci.getFrameCount() <= 0) {
                return this.ci;
            }
            if (this.dh.getControlApps().isDMDataGotAlready()) {
                return this.ci;
            }
            this.handleFilter(this.ci, false);
            if (this.ph != null) {
                this.ph.preLoadReceiveData(this.ci);
            }
            this.dh.reloadRTData(this.ci);
            return this.ci;
        }
        if (this.si.checkStatusForGetDataT(this.ci, this.ism)) {
            if (this.ci.fetchUntilData) {
                do {
                    this.routineGetData(GETDATA_ADD);
                } while (this.ci.getFrameCount() <= 0);
                this.ci.fetchUntilData = false;
            } else {
                this.routineGetData(GETDATA_ADD);
            }
            boolean bl = this.cm.getFFTControl().isFFTon();
            if (this.ci.status == 0 && this.ci.getFrameCount() > 0) {
                this.vl.logln("ok");
                this.handleGroundNInverse(this.ci);
                this.handleFilter(this.ci, true);
                if (bl) {
                    if (this.ph != null) {
                        this.ph.preLoadReceiveData(this.ci);
                    }
                    this.ci.slowMove = 0;
                } else {
                    if (this.ph != null) {
                        this.ph.preLoadReceiveData(this.ci);
                    }
                    this.handleAverage(this.ci);
                }
                this.dh.receiveRTData(this.ci);
                this.vf.syncChannelsMiddle(this.ism, this.dh.getWaveFormManager().on_wf_Iterator());
                if (this.dataReceiveListener != null) {
                    this.dataReceiveListener.onReceive();
                }
                this.checkTrgEdgeMiddle();
            } else {
                this.vl.logln("bad");
            }
        }
        return this.ci;
    }

    protected Source getSource() {
        return this.src;
    }

    private void routineGetData(AddValueAttachCommand addValueAttachCommand) {
        int n;
        WaveFormInfo[] waveFormInfoArray = this.wfic.getWaveFormInfos();
        int n2 = 0;
        int n3 = waveFormInfoArray.length;
        for (n = n3 - 1; n >= 0; --n) {
            int n4 = waveFormInfoArray[n].ci.isOn() ? 5 : 4;
            n2 = n2 << 8 | n4;
        }
        addValueAttachCommand.value = n2;
        n = Sendable.writeCommmand(this.ism, addValueAttachCommand);
        if (n <= 0) {
            this.ci.status = 4;
        }
        Source source = this.getSource();
        int n5 = this.wfic.getOnWaveFormNumber();
        this.acceptNMData(this.ci, n5, source);
        this.updateFrame(1);
        this.si.dealTrgStatus(this.ci);
    }

    private void acceptNMData(ChannelsTransportInfo_Tiny channelsTransportInfo_Tiny, int n, Source source) {
        channelsTransportInfo_Tiny.status = 1;
        try {
            this.vl.logln("---------------:");
            byte[] byArray = this.adcm.firstReceiveBuf;
            byte[][] byArray2 = this.adcm.usbbufs;
            int n2 = source.acceptResponse(byArray, 5211);
            this.vl.logln("receive 1st: " + n2);
            if (byArray[0] == 69) {
                String string = new String(byArray, 0, 5);
                this.vl.logln("receive :" + string);
                channelsTransportInfo_Tiny.status = 0;
                channelsTransportInfo_Tiny.setFrameCount(0);
                ++this.noDataTimes;
                return;
            }
            if (n2 < 5211) {
                channelsTransportInfo_Tiny.status = 0;
                channelsTransportInfo_Tiny.setFrameCount(0);
                ++this.noDataTimes;
                return;
            }
            this.noDataTimes = 0;
            this.si.onDataReceive(channelsTransportInfo_Tiny);
            channelsTransportInfo_Tiny.reset('T');
            channelsTransportInfo_Tiny.gatherEnoughChannelDataInfos(n);
            channelsTransportInfo_Tiny.setDataComplete(1);
            Iterator<ChannelDataInfo_Tiny> iterator = channelsTransportInfo_Tiny.iterator_ChannelDataInfo();
            this.adcm.firstReceiveBuf = byArray2[0];
            byArray2[0] = byArray;
            byte[] byArray3 = byArray;
            int n3 = 0;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3, 11, 100).order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray3, byteBuffer.limit(), 5100).order(ByteOrder.LITTLE_ENDIAN);
            this.acceptChannelDataT2(iterator.next(), n3, byteBuffer2, byteBuffer);
            ++n3;
            while (n3 < n) {
                byArray3 = byArray2[n3];
                n2 = source.acceptResponse(byArray3, 5211);
                this.vl.logln("receive next: " + n2);
                if (n2 < 5211) {
                    throw new Exception("receive size < 5211, on pool_idx" + n3);
                }
                byteBuffer = ByteBuffer.wrap(byArray3, 11, 100).order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer2 = ByteBuffer.wrap(byArray3, byteBuffer.limit(), 5100).order(ByteOrder.LITTLE_ENDIAN);
                this.acceptChannelDataT2(iterator.next(), n3, byteBuffer2, byteBuffer);
                ++n3;
            }
            this.vl.logln("*********************!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            channelsTransportInfo_Tiny.status = 0;
            channelsTransportInfo_Tiny.setFrameCount(1);
            return;
        }
        catch (USBException uSBException) {
            channelsTransportInfo_Tiny.status = 3;
            this.vl.logln(uSBException.getMessage());
            uSBException.printStackTrace();
        }
        catch (Exception exception) {
            this.vl.logln(exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected void acceptChannelDataT2(ChannelDataInfo_Tiny channelDataInfo_Tiny, int n, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws USBException {
        float f;
        int n2 = 0;
        byte by = byteBuffer.get(n2);
        channelDataInfo_Tiny.chl = by;
        this.vl.logln("cdi.chl: " + by);
        channelDataInfo_Tiny.trg_d = (this.ci.channel_trg_status >>> by & 1) != 0;
        boolean bl = channelDataInfo_Tiny.trg_d;
        int n3 = byteBuffer.getInt(++n2);
        int n4 = byteBuffer.getInt(n2 += 4);
        this.vl.logln(by + "trg_d: " + (bl ? 1 : 0) + " time_sum: " + n3 + ", peroid_num: " + n4);
        this.echo_vl.logln("ch" + (by + 1));
        if (!bl || n3 <= 0 || n4 <= 0 || this.tm == null) {
            f = -1.0f;
        } else {
            f = (float)this.tm.doFrequencyCompute(n4, n3);
            this.vl.logln("freq: " + f);
        }
        channelDataInfo_Tiny.setFreq(f);
        short s = byteBuffer.getShort(n2 += 4);
        n2 += 2;
        this.vl.logln("slow number: " + s);
        channelDataInfo_Tiny.slowMove = Math.abs(s);
        channelDataInfo_Tiny.resetPi();
        channelDataInfo_Tiny.setAllDMBuffer(byteBuffer);
        this.echo_vl.logln("screen center data:");
        ArrayLogger.outArray2Logable((Logable)this.echo_vl, byteBuffer.array(), byteBuffer.position() + 2500, 100);
        channelDataInfo_Tiny.setTrgLocBuffer(byteBuffer2);
        this.echo_vl.logln("pull trg data:");
        ArrayLogger.outArray2Logable((Logable)this.echo_vl, byteBuffer2.array(), byteBuffer2.position(), byteBuffer2.remaining());
    }

    public static interface DataReceiveHandler {
        public void onReceive();

        public void onSweepOutAsOnce();
    }

    static interface Source {
        public int acceptResponse(byte[] var1, int var2);
    }
}

