/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.source.comm.data;

import com.owon.uppersoft.vds.core.filter.FilterADC;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.PlugInfo;
import com.owon.uppersoft.vds.source.front.PreHandler;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class ChannelDataInfo_Tiny
extends ChannelDataInfo {
    public PlugInfo pi = new PlugInfo();
    private byte[] dmcache = null;
    private int dmcache_start;
    private int dmcache_stop;
    private int dmcache_slowmove;
    private double filter_wn = 0.0;
    private double[] filter_b = null;
    private double[] filter_a = null;
    private ByteBuffer alldmbuf;
    private ByteBuffer trglocbuf;
    public int dmInitPos;
    public int dmfullscreen;
    public int dmslowMove;
    public boolean trg_d;

    @Override
    public void computeFreq(BigDecimal bigDecimal, MachineType machineType) {
    }

    @Override
    public void handleADCBoundNInverse(int n, boolean bl) {
        this.handleADCBoundNInverseForFrame(n, bl, this.alldmbuf);
    }

    @Override
    public void applyFilter(double d, boolean bl) {
        if (bl) {
            this.dmcache_start = this.alldmbuf.position();
            this.dmcache_stop = this.alldmbuf.limit();
            this.dmcache_slowmove = this.slowMove;
            if (d < 1.0E-5) {
                this.filter_wn = 0.0;
                return;
            }
        }
        byte[] byArray = this.alldmbuf.array();
        int n = this.dmcache_start;
        int n2 = this.dmcache_stop;
        if (bl || this.filter_wn == 0.0) {
            if (this.dmcache == null) {
                this.dmcache = new byte[byArray.length];
            }
            System.arraycopy(byArray, 0, this.dmcache, 0, byArray.length);
        } else {
            System.arraycopy(this.dmcache, 0, byArray, 0, byArray.length);
        }
        this.alldmbuf.position(n);
        this.alldmbuf.limit(n2);
        this.slowMove = this.dmcache_slowmove;
        double d2 = 1.0 / ((double)((n2 - n) / 2) * d);
        if (d2 > 0.0 && d2 < 1.0) {
            if (d2 != this.filter_wn) {
                this.filter_wn = d2;
                this.filter_b = FilterADC.computeB(3, d2);
                this.filter_a = FilterADC.computeA(3, d2);
            }
            if (this.slowMove < n2 - n) {
                n = Math.max(n, n2 - this.slowMove);
            }
            FilterADC.filtfilt(byArray, n, n2, this.filter_b, this.filter_a);
        }
    }

    public void setAllDMBuffer(ByteBuffer byteBuffer) {
        this.alldmbuf = ByteBuffer.wrap(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
    }

    public void resetPi() {
        this.pi.reset();
    }

    public ByteBuffer getALLDMBuffer() {
        return this.alldmbuf;
    }

    @Override
    public void forceGround(int n) {
        this.gndByteBuffer(this.alldmbuf, n);
    }

    @Override
    public void reset() {
        super.reset();
        this.setFreq(-1.0f);
    }

    public void setTrgLocBuffer(ByteBuffer byteBuffer) {
        this.trglocbuf = byteBuffer;
    }

    public ByteBuffer getTrgLocBuffer() {
        return this.trglocbuf;
    }

    public void save2DMDataInfo(DMDataInfo dMDataInfo) {
        ByteBuffer byteBuffer = this.alldmbuf;
        dMDataInfo.datalen = byteBuffer.remaining();
        dMDataInfo.setFreq(this.getFrequencyFloat());
        dMDataInfo.screendatalen = this.dmfullscreen;
        PlugInfo plugInfo = dMDataInfo.pi;
        plugInfo.copyFrom(this.pi);
        dMDataInfo.initPos = this.dmInitPos;
        dMDataInfo.slowMove = this.dmslowMove;
    }

    public void setResultRTBuf(ByteBuffer byteBuffer) {
        this.initPos = 0;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byte[] byArray = byteBuffer.array();
        for (int i = n; i < n2; ++i) {
            byArray[i] = PreHandler.limitValue2Byte(byArray[i]);
        }
        this.setUniqueAdcbuf(byteBuffer);
    }

    public ByteBuffer trimNgetADCByteBuffer() {
        ByteBuffer byteBuffer = this.getALLDMBuffer();
        if (byteBuffer == null) {
            return byteBuffer;
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.limit(n2 -= 50);
        byteBuffer.position(n += 50);
        return byteBuffer;
    }
}

