/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.source.comm;

import ch.ntb.usb.USBException;
import com.owon.uppersoft.dso.source.usb.USBPortsFilter;
import com.owon.uppersoft.dso.source.usb.USBSource;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.util.format.EndianUtil;
import com.owon.vds.firm.protocol.AddValueAttachCommand;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class PortFilterTiny
implements USBPortsFilter {
    public static final AddValueAttachCommand MACHINE_TYPE_ADD = new AddValueAttachCommand("MACHINE_TYPE_ADD", 16385, 1, 86);

    @Override
    public boolean collectPort(IDevice iDevice) throws USBException {
        String string = iDevice.getSerialNumber();
        if (string != null && !string.isEmpty()) {
            return false;
        }
        USBSource uSBSource = new USBSource(iDevice);
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        AddValueAttachCommand addValueAttachCommand = MACHINE_TYPE_ADD;
        byteBuffer.putInt(addValueAttachCommand.address);
        byteBuffer.put((byte)addValueAttachCommand.bytes);
        byteBuffer.put((byte)addValueAttachCommand.value);
        int n = uSBSource.write(byteBuffer.array(), 6);
        if (n <= 0) {
            return false;
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n2 = 5;
        byte[] byArray = new byte[n2];
        int n3 = uSBSource.acceptResponse(byArray, n2);
        if (n3 < n2) {
            return false;
        }
        int n4 = EndianUtil.nextIntL(byArray, 1);
        if (n4 <= 0) {
            return false;
        }
        String string2 = this.getMachineNameFromCode(n4);
        if (string2 == null) {
            return false;
        }
        iDevice.setSerialNumber(string2);
        this.rehandleIDevice(iDevice);
        return true;
    }

    protected abstract String getMachineNameFromCode(int var1);

    protected void rehandleIDevice(IDevice iDevice) {
    }
}

