/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.source.comm;

import com.owon.uppersoft.dso.data.AbsDataSaver;
import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.DataSaverTiny;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ToolPane;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.auto.AutosetRunner2;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.pref.StaticPref;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.device.interpret.DeviceAddressTable;
import com.owon.uppersoft.vds.machine.PrincipleTiny;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.source.comm.SourceManagerTiny;
import com.owon.uppersoft.vds.source.comm.Submitor2;
import com.owon.uppersoft.vds.source.comm.data.ChannelsTransportInfo_Tiny;
import com.owon.uppersoft.vds.source.comm.data.GetDataRunner2;
import com.owon.uppersoft.vds.source.comm.data.TinyDMSourceManager;
import com.owon.uppersoft.vds.source.comm.data.ValueFeeder;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.vds.calibration.BaselineCalDelegateTiny;
import com.owon.vds.firm.protocol.AddressAttachCommand;
import com.owon.vds.tiny.firm.DeviceFlashCommunicator;
import com.owon.vds.tiny.firm.FPGADownloader;
import com.owon.vds.tiny.firm.pref.PrefControl;
import com.owon.vds.tiny.firm.pref.PrefSync;
import com.owon.vds.tiny.firm.pref.model.Register;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;

public class InterCommTiny
extends AbsInterCommunicator {
    private static final String NO_FOUND_DEVICE_PREFERENCE = "Tiny.Prompt.Comm.NoFoundDevicePreference";
    private static final String FOUND_DEVICE_PREFERENCE = "Tiny.Prompt.Comm.FoundDevicePreference";
    public static final String NEW_DATA_RECEIVE = "NewDataReceive";
    private SourceManagerTiny sm;
    private PrincipleTiny pp;
    private PropertyChangeSupport data_receive_broadcast;
    private boolean askDM;

    @Override
    public void rebootMachine() {
    }

    public ToolPane getToolPane() {
        return this.getMainWindow().getToolPane();
    }

    @Override
    public ControlManager getControlManager() {
        return this.cm;
    }

    public WaveFormManager getWaveFormManager() {
        return this.dh.getWaveFormManager();
    }

    @Override
    protected void invokeLater_Autoset(Runnable runnable) {
        AutosetRunner2 autosetRunner2 = new AutosetRunner2(runnable, this);
        autosetRunner2.getReady();
    }

    public TinyMachine getTinyMachine() {
        return (TinyMachine)this.dh.getControlManager().getMachine();
    }

    @Override
    public boolean isTimeOperatableNTryGetDM() {
        if (this.cm.isRuntime()) {
            return true;
        }
        if (!this.sm.isConnected()) {
            return true;
        }
        if (!this.cm.isRuntimeStop()) {
            return false;
        }
        boolean bl = this.cm.playCtrl.confirmGoOnPlaying();
        if (bl) {
            return true;
        }
        if (this.cc.getTriggerControl().isSweepNormal() && this.getChannelsTransportInfo().getFrameCount() == 0) {
            return true;
        }
        boolean bl2 = this.ca.isDMAvailable();
        if (!bl2) {
            return true;
        }
        if (!this.ca.isDMDataGotAlready()) {
            this.persistDMData();
            return true;
        }
        return true;
    }

    public InterCommTiny(DataHouse dataHouse, MainWindow mainWindow, ControlApps controlApps, SourceManagerTiny sourceManagerTiny, PrincipleTiny principleTiny) {
        super(dataHouse, mainWindow, controlApps);
        this.sm = sourceManagerTiny;
        this.pp = principleTiny;
        this.data_receive_broadcast = new PropertyChangeSupport(this);
    }

    public PropertyChangeSupport getDataReceiveBroadcast() {
        return this.data_receive_broadcast;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.data_receive_broadcast.addPropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.data_receive_broadcast.firePropertyChange(string, object, object2);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.data_receive_broadcast.removePropertyChangeListener(propertyChangeListener);
    }

    public Submitor2 reinitSubmitor2() {
        return (Submitor2)SubmitorFactory.reInit();
    }

    @Override
    public void onExport_get() {
        boolean bl = this.getDMDataBackgroundWhenAsk();
        if (!bl) {
            this.cm.ewc.setAuthorizeExport(false);
        }
    }

    private boolean getDMDataBackgroundWhenAsk() {
        if (this.sm.isConnected()) {
            if (!this.ca.isDMDataGotAlready()) {
                this.persistDMData();
                return true;
            }
        } else {
            FadeIOShell fadeIOShell = new FadeIOShell();
            String string = I18nProvider.bundle().getString("M.Utility.ExportWave.Confirm");
            fadeIOShell.prompt(string, this.getMainWindow().getFrame());
        }
        return false;
    }

    protected MainWindow getMainWindow() {
        return Platform.getMainWindow();
    }

    private void persistDMData() {
        this.prepare2PersistDMData();
        DMInfo dMInfo = new DataSaverTiny().saveFileM(this.cm, dmf, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }
        }, new TinyDMSourceManager(this.getChannelsTransportInfo()));
        this.dh.receiveRTDMData(dMInfo);
        this.ca.setDMDataGotAlready(true);
        this.cm.pcs.firePropertyChange("afterGotDMData", null, this.dh.getWaveFormManager());
    }

    private ChannelsTransportInfo_Tiny getChannelsTransportInfo() {
        return (ChannelsTransportInfo_Tiny)Platform.getControlApps().getDaemon().getChannelsTransportInfo();
    }

    @Override
    public void statusStop(boolean bl) {
        this.askDM = bl;
        super.statusStop(bl);
    }

    @Override
    public void afterkeepload() {
        if (!this.ca.isDMDataGotAlready() && this.askDM) {
            this.persistDMData();
        }
    }

    @Override
    public void queryALL() {
    }

    @Override
    public void doSyncFactorySet2Machine() {
        Submitor2 submitor2 = this.reinitSubmitor2();
        PrefControl prefControl = this.pp.getPrefControl();
        prefControl.rollFactory2Device();
        this.cm.initDetail(submitor2);
        submitor2.apply();
    }

    protected ICommunicateManager getICommunicateManager() {
        return this.sm;
    }

    private void syncFlash() {
        PrefControl prefControl = this.pp.getPrefControl();
        new PrefSync().syncFlash(prefControl.outputAsSyncImage(), this.ca.getJobUnitDealer());
    }

    @Override
    public void initDetail() {
        Submitor2 submitor2 = this.reinitSubmitor2();
        this.cm.initDetail(submitor2);
        submitor2.apply();
    }

    protected String getMachineType() {
        if (this.sm.isUSBConnect()) {
            USBSourceManager uSBSourceManager = this.sm.getUSBSourceManager();
            String string = uSBSourceManager.getUsbs().getId().getSerialNumber();
            return string;
        }
        return "VDS1022";
    }

    protected String getMachineText() {
        if (this.sm.isUSBConnect()) {
            USBSourceManager uSBSourceManager = this.sm.getUSBSourceManager();
            String string = uSBSourceManager.getUsbs().getId().toString();
            return string;
        }
        return "?";
    }

    @Override
    public boolean initMachine(PropertyChangeListener propertyChangeListener) {
        Object object;
        Submitor2 submitor2 = this.reinitSubmitor2();
        DeviceAddressTable deviceAddressTable = this.getTinyMachine().getDeviceAddressTable();
        SoftwareControl softwareControl = this.cm.getSoftwareControl();
        String string = this.getMachineType();
        softwareControl.machine_name = this.getTinyMachine().name();
        if (!softwareControl.machine_name.equalsIgnoreCase(string)) {
            this.cm.reloadManager.restartInLinking(string);
            return false;
        }
        softwareControl.setMachineHeader("SPB" + softwareControl.machine_name);
        this.mw.updateStatus(TrgStatus.Detect);
        propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "Status", null, I18nProvider.bundle().getString("Label.detect")));
        this.mw.updateStatus(TrgStatus.Initialize);
        propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "Status", null, I18nProvider.bundle().getString("Label.initialize") + ": "));
        StaticPref staticPref = this.cm.getConfig().getStaticPref();
        if (softwareControl.machine_name.equalsIgnoreCase("VDS1021")) {
            staticPref.setProductId(this.getMachineText().substring(0, 3));
        }
        propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "Info", null, null));
        ICommunicateManager iCommunicateManager = this.getICommunicateManager();
        FPGADownloader fPGADownloader = new FPGADownloader();
        int n = fPGADownloader.queryFPGADownloaded(iCommunicateManager);
        if (n < 0) {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "Status", null, "fpga download status query err response."));
            return false;
        }
        boolean bl = n == 0;
        DeviceFlashCommunicator deviceFlashCommunicator = new DeviceFlashCommunicator();
        byte[] byArray = deviceFlashCommunicator.fetchPrefernce(iCommunicateManager, bl);
        PrefControl prefControl = this.pp.getPrefControl();
        boolean bl2 = prefControl.loadSyncImageFromDevice(byArray);
        Register register = this.pp.getTuneFunction().getTuneModel().getRegister();
        softwareControl.setBoardVersion(register.version);
        softwareControl.setBoardSeries(register.serialNumber);
        this.cm.getConfig().updateLocales(register.getSelectedLocaleObject());
        this.cm.pcs.firePropertyChange("updateTxtLocales", null, null);
        if (bl) {
            object = fPGADownloader.checkFPGAAvailable(string, register.version);
            if (object == null) {
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "FPD_NOFILE", null, null));
                return false;
            }
            boolean bl3 = fPGADownloader.downloadFPGA(propertyChangeListener, iCommunicateManager, (File)object);
            if (!bl3) {
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "Status", null, "fpga download fail."));
                return false;
            }
            this.initializeDevice(propertyChangeListener, register);
        }
        if (this.getTinyMachine().name().equals("VDS2052")) {
            submitor2.d_chl_vb(0, 9, null);
            submitor2.d_chl_vb(1, 9, null);
            submitor2.sendCMD(new AddressAttachCommand("reset_adc_0x22", 34, 1), 1);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            submitor2.sendCMD(new AddressAttachCommand("reset_adc_0x21", 33, 1), 1);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            try {
                this.sendCmd(submitor2, 32);
                this.sendCmd(submitor2, 29185);
                this.sendCmd(submitor2, 29505);
                this.sendCmd(submitor2, 29696);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.ca.getJobQueueDispatcher().dealQueue();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        object = this.dh.getWaveFormManager().getWaveForm((int)1).wfi.ci;
        boolean bl4 = ((ChannelInfo)object).isOn();
        if (this.getTinyMachine().name().equals("VDS2052")) {
            ((ChannelInfo)object).c_setOn(true);
        }
        this.initDetail();
        this.ca.getJobQueueDispatcher().dealQueue();
        if (this.getTinyMachine().name().equals("VDS2052")) {
            ((ChannelInfo)object).c_setOn(bl4);
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "Status", null, "initializing..."));
            int n2 = 5000;
            int n3 = 200;
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "ProgressStart", null, n2));
            for (int i = 0; i < n2; i += n3) {
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "ProgressIncrease", null, n3));
                try {
                    Thread.sleep(n3);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "ProgressDone", null, null));
            submitor2.sendCMDbyBytes(deviceAddressTable.RE_COLLECT, 1, null);
            this.ca.getJobQueueDispatcher().dealQueue();
        }
        this.mw.updateStatus(TrgStatus.Auto);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.ca.keepload();
        if (this.getTinyMachine().name().equals("VDS2052")) {
            try {
                this.sendCmd(submitor2, 8712);
                this.sendCmd(submitor2, 9088);
                this.sendCmd(submitor2, 9344);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.cm.pcs.firePropertyChange("OPERATE_RUN", null, null);
        return true;
    }

    private void sendCmd(Submitor2 submitor2, int n) throws InterruptedException {
        Thread.sleep(500L);
        submitor2.sendCMD(new AddressAttachCommand("", 20, 3), n);
    }

    protected void initializeDevice(PropertyChangeListener propertyChangeListener, Register register) {
        DeviceAddressTable deviceAddressTable = this.getTinyMachine().getDeviceAddressTable();
        Submitor2 submitor2 = this.reinitSubmitor2();
        submitor2.sendCMDbyBytes(deviceAddressTable.PHASE_FINE, register.getPhaseFine().getWrValue(), null);
        if (this.getTinyMachine().name().equals("VDS2052")) {
            // empty if block
        }
    }

    @Override
    public AbsDataSaver createDatasaver() {
        return new DataSaverTiny();
    }

    public ValueFeeder getValueFeeder() {
        return ((GetDataRunner2)Platform.getControlApps().getDaemon().getAbsGetDataRunner()).getValueFeeder();
    }

    public void selfCalibration() {
        new BaselineCalDelegateTiny(this.mw.getWindow(), this.ca, this.getTinyMachine(), this.pp).askAutoCalibration();
    }
}

