/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.server;

import com.owon.uppersoft.vds.socket.command.CmdFactory;
import com.owon.uppersoft.vds.socket.server.ScpiConsole;
import com.owon.uppersoft.vds.socket.server.Server;
import com.owon.uppersoft.vds.util.Pref;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class ServerControl {
    private Server socketServer;
    private int mPort = 5188;
    private final int DATABLOCK = 2048;
    private final int net_dmbuflen = 4288;

    public ServerControl(Pref pref) {
        this.load(pref);
    }

    private void load(Pref pref) {
        this.mPort = pref.loadInt("ScpiPort");
    }

    public void persist(Pref pref) {
        pref.persistInt("ScpiPort", this.mPort);
    }

    public void startServer() {
        this.startServer(this.mPort);
    }

    public void startServer(int n) {
        if (n > 0 && n < 65535) {
            this.socketServer = new Server(this, n);
            this.socketServer.start();
            this.mPort = n;
        }
    }

    public void destroyServer() {
        if (this.socketServer != null) {
            this.socketServer.terminateServer();
            this.socketServer = null;
            this.mPort = -1;
        }
    }

    public void startSCPIConsole() {
        ScpiConsole.getInstance();
    }

    public boolean setPort(int n) {
        boolean bl;
        if (this.socketServer != null && n == this.socketServer.getPort()) {
            return true;
        }
        boolean bl2 = bl = n > 0 && n < 65535;
        if (bl) {
            this.destroyServer();
            this.socketServer = null;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.startServer(n);
        }
        return bl;
    }

    public int getPort() {
        if (this.socketServer == null) {
            return 5188;
        }
        return this.socketServer.getPort();
    }

    public void writeLargeData(SocketChannel socketChannel, CmdFactory cmdFactory, String string) throws IOException {
        byte[] byArray = cmdFactory.getProvider().getData(string);
        if (byArray != null) {
            int n = byArray.length;
            int n2 = 0;
            int n3 = 2048;
            int n4 = 0;
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putInt(n).flip();
            socketChannel.write(byteBuffer);
            while (n2 < n) {
                if (n3 > n - n2) {
                    n3 = n - n2;
                }
                ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray, n2, n3);
                n4 = socketChannel.write(byteBuffer2);
                this.println("p:" + (n2 += n4), false);
            }
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putInt(-1).flip();
            socketChannel.write(byteBuffer);
            ByteBuffer byteBuffer3 = ByteBuffer.wrap("FIALED".getBytes());
            socketChannel.write(byteBuffer3);
        }
    }

    private void println(String string, boolean bl) {
    }
}

