/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.server;

import com.owon.uppersoft.vds.socket.command.CmdFactory;
import com.owon.uppersoft.vds.socket.command.CommandKey;
import com.owon.uppersoft.vds.socket.server.ScpiConsole;
import com.owon.uppersoft.vds.socket.server.ServerControl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class Server
extends Thread {
    public static final int DEFAULT_PORT = 5188;
    private int mPort;
    private CmdFactory factory;
    private ServerControl svCtr;
    private ScpiConsole dbgView;
    private boolean onlargeTransmit = false;
    private boolean onDmTransmit = false;
    protected boolean isRemoteTransmit = false;
    private boolean isExit = false;
    protected ByteBuffer clientBuffer = ByteBuffer.allocate(1024);
    protected Selector selector;
    ServerSocketChannel server;

    public Server(ServerControl serverControl, int n) {
        this.mPort = n;
        this.svCtr = serverControl;
        this.factory = new CmdFactory();
    }

    public void terminateServer() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
        this.isExit = true;
        try {
            this.server.socket().close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            this.selector = this.getSelector(this.mPort);
            this.listen();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected Selector getSelector(int n) throws IOException {
        this.server = ServerSocketChannel.open();
        Selector selector = Selector.open();
        this.server.socket().bind(new InetSocketAddress(n));
        this.server.configureBlocking(false);
        this.server.register(selector, 16);
        return selector;
    }

    public void listen() {
        try {
            while (!this.isExit) {
                this.selector.select();
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    this.process(selectionKey);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void process(SelectionKey selectionKey) throws IOException {
        if (selectionKey.isAcceptable()) {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
            SocketChannel socketChannel = serverSocketChannel.accept();
            socketChannel.configureBlocking(false);
            socketChannel.register(this.selector, 1);
        } else if (selectionKey.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            int n = -1;
            try {
                n = socketChannel.read(this.clientBuffer);
            }
            catch (Exception exception) {
                socketChannel.close();
            }
            if (n > 0) {
                String string;
                this.clientBuffer.flip();
                byte[] byArray = this.clientBuffer.array();
                String string2 = new String(byArray, 0, n).trim();
                if (this.dbgView != null) {
                    this.dbgView.addReadText(string2);
                }
                if ((string = this.translation(string2 = string2 + "\r")) != null && !string.equalsIgnoreCase("")) {
                    SelectionKey selectionKey2 = socketChannel.register(this.selector, 4);
                    selectionKey2.attach(string);
                }
            } else {
                socketChannel.close();
            }
            this.clientBuffer.clear();
        } else if (selectionKey.isWritable()) {
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            String string = (String)selectionKey.attachment();
            if (this.onlargeTransmit) {
                String[] stringArray = string.trim().split(";");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.svCtr.writeLargeData(socketChannel, this.factory, stringArray[i]);
                }
                this.onlargeTransmit = false;
            } else if (this.onDmTransmit) {
                this.onDmTransmit = false;
                this.isRemoteTransmit = false;
            } else {
                ByteBuffer byteBuffer = ByteBuffer.wrap((string + "\r").getBytes());
                if (this.dbgView != null) {
                    this.dbgView.addWriteText(string);
                }
                socketChannel.write(byteBuffer);
            }
            socketChannel.register(this.selector, 1);
        }
    }

    protected String translation(String string) {
        String[] stringArray = string.split(";");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(this.analyse(stringArray[i]));
        }
        return stringBuffer.toString() + "\n";
    }

    private String analyse(String string) {
        string = string.trim();
        return (String)this.analyseCMDs_1(string);
    }

    public Object analyseCMDs_1(String string) {
        if (this.dealADC_CMDs(string = string.toUpperCase().replaceAll("\\s*", ""))) {
            return string + ";";
        }
        CommandKey commandKey = this.pickOutTrunk(string);
        CommandKey commandKey2 = null;
        if (commandKey != null) {
            commandKey2 = commandKey.hasKey(string, null);
        }
        if (commandKey2 != null) {
            return commandKey2.handle();
        }
        return "CAN NOT ANALYSE THE ORDER";
    }

    private boolean dealADC_CMDs(String string) {
        boolean bl = string.startsWith("*ADC?");
        boolean bl2 = string.startsWith("*LDM?");
        boolean bl3 = string.startsWith("*RDM?");
        if (bl) {
            this.onlargeTransmit = true;
            return true;
        }
        if (bl2) {
            this.onDmTransmit = true;
            this.isRemoteTransmit = false;
            return true;
        }
        if (bl3) {
            this.onDmTransmit = true;
            this.isRemoteTransmit = true;
            return true;
        }
        return false;
    }

    private CommandKey pickOutTrunk(String string) {
        CommandKey commandKey = null;
        String string2 = string;
        if (string.startsWith(":")) {
            string2 = string.split(":", 3)[1];
        }
        for (CommandKey commandKey2 : this.factory.getKeys()) {
            if (!string2.startsWith(commandKey2.getFitPre()) && !string2.startsWith(commandKey2.getShortPre())) continue;
            commandKey = commandKey2;
            break;
        }
        return commandKey;
    }

    public void setupConsole() {
        this.dbgView = ScpiConsole.getInstance();
    }

    public int getPort() {
        return this.mPort;
    }
}

