/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.server;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.socket.server.ServerControl;
import com.owon.uppersoft.vds.util.LocalizeCenter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ScpiConsole
implements Localizable {
    private static ScpiConsole instance = null;
    public JFrame console = new JFrame();
    private JPanel btnp;
    private JPanel viewp;
    private JTextArea consoleArea;
    private boolean writable = true;
    private boolean readable = true;
    private boolean scrollable;
    JCheckBox rcb;
    JCheckBox wcb;
    JCheckBox scroll;
    JButton cl;
    JLabel portlb;
    JButton portbt;

    public static ScpiConsole getInstance() {
        if (instance == null) {
            instance = new ScpiConsole();
        } else if (instance.checkInvisible()) {
            instance = null;
            instance = new ScpiConsole();
        } else {
            instance.toFront();
        }
        return instance;
    }

    private ScpiConsole() {
        this.console.setSize(800, 600);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.console.setContentPane(jPanel);
        this.initBtnPane(jPanel);
        this.initConsole(jPanel);
        this.console.setDefaultCloseOperation(2);
        this.console.setLocationRelativeTo(null);
        this.console.setVisible(true);
        LocalizeCenter localizeCenter = Platform.getControlManager().getLocalizeCenter();
        localizeCenter.addLocalizable(this);
        this.localize(I18nProvider.bundle());
    }

    private void initBtnPane(JPanel jPanel) {
        this.btnp = new JPanel();
        this.btnp.setLayout(new FlowLayout());
        this.btnp.setPreferredSize(new Dimension(this.console.getWidth(), 50));
        jPanel.add((Component)this.btnp, "North");
        this.rcb = new JCheckBox("Server Read");
        this.btnp.add(this.rcb);
        this.rcb.setSelected(this.readable);
        this.rcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScpiConsole.this.readable = ScpiConsole.this.rcb.isSelected();
            }
        });
        this.wcb = new JCheckBox("Server Write");
        this.btnp.add(this.wcb);
        this.wcb.setSelected(this.writable);
        this.wcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScpiConsole.this.writable = ScpiConsole.this.wcb.isSelected();
            }
        });
        this.scroll = new JCheckBox("scroll");
        this.btnp.add(this.scroll);
        this.scroll.setSelected(this.scrollable);
        this.scroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScpiConsole.this.scrollable = ScpiConsole.this.scroll.isSelected();
            }
        });
        this.cl = new JButton("Clear Console");
        this.btnp.add(this.cl);
        this.cl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScpiConsole.this.clearTextArea();
            }
        });
        this.portlb = new JLabel("Port:");
        this.btnp.add(this.portlb);
        final ServerControl serverControl = Platform.getControlManager().scpiServer;
        final JTextField jTextField = new JTextField();
        jTextField.setText(String.valueOf(serverControl.getPort()));
        jTextField.setColumns(5);
        this.btnp.add(jTextField);
        this.portbt = new JButton("Set");
        this.btnp.add(this.portbt);
        this.portbt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScpiConsole.this.btnp.setEnabled(false);
                String string = jTextField.getText().trim();
                if ("".equals(string)) {
                    serverControl.destroyServer();
                    jTextField.setText(String.valueOf(serverControl.getPort()));
                    ScpiConsole.this.updateText("Server closed");
                    return;
                }
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    jTextField.setText(String.valueOf(serverControl.getPort()));
                    ScpiConsole.this.updateText("Set port failed");
                    return;
                }
                boolean bl = serverControl.setPort(n);
                if (bl) {
                    ScpiConsole.this.updateText("Set port  " + serverControl.getPort() + "  success");
                } else {
                    jTextField.setText(String.valueOf(serverControl.getPort()));
                    ScpiConsole.this.updateText("Set port failed");
                }
                ScpiConsole.this.btnp.setEnabled(true);
            }
        });
    }

    private void initConsole(JPanel jPanel) {
        this.viewp = new JPanel();
        this.viewp.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 10, 10), new LineBorder(Color.black, 1, false)));
        this.consoleArea = new JTextArea();
        this.consoleArea.setLineWrap(true);
        this.consoleArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(this.consoleArea);
        this.viewp.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.viewp, "Center");
    }

    public boolean checkInvisible() {
        return !this.console.isDisplayable();
    }

    public void toFront() {
        if (this.console != null && this.console.isDisplayable()) {
            this.console.toFront();
        }
    }

    public void addReadText(String string) {
        if (this.readable) {
            this.updateText(string);
        }
    }

    public void addWriteText(String string) {
        if (this.writable) {
            this.updateText("/..   " + string);
        }
    }

    private void updateText(String string) {
        this.consoleArea.append(string + "\r\n");
        if (this.scrollable) {
            this.consoleArea.setCaretPosition(this.consoleArea.getText().length());
        }
    }

    protected void clearTextArea() {
        this.consoleArea.setText(null);
    }

    public static void main(String[] stringArray) {
        new ScpiConsole();
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.rcb.setText(resourceBundle.getString("ServerConsole.Readable"));
        this.wcb.setText(resourceBundle.getString("ServerConsole.Writable"));
        this.scroll.setText(resourceBundle.getString("ServerConsole.Scroll"));
        this.cl.setText(resourceBundle.getString("ServerConsole.Clear"));
        this.portlb.setText(resourceBundle.getString("M.Utility.MachineNet.Port") + ":");
        this.portbt.setText(resourceBundle.getString("Action.OK"));
    }
}

