/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.provider;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.VideoTrigger;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.socket.NB;

public class TrgScpiProvider {
    private ControlManager cm;
    private WaveFormManager wfm;
    private TriggerControl tc;
    private final String[] trgTypes = new String[]{"SINGle", "ALTernate"};
    private final String[] trgSweepMode = new String[]{"AUTO", "NORMal", "SINGle"};

    public TrgScpiProvider(ControlManager controlManager) {
        this.cm = controlManager;
        this.wfm = Platform.getDataHouse().getWaveFormManager();
        this.tc = this.cm.getTriggerControl();
    }

    private void updateAllTrgUI(int n) {
        MainWindow mainWindow = Platform.getMainWindow();
        mainWindow.getTitlePane().updateBtnSingle();
        this.updateTrgInfoPane();
        this.cm.pcs.firePropertyChange("APPLY_TRIGGER", null, (Object)n);
    }

    private void updateTrgInfoPane() {
        MainWindow mainWindow = Platform.getMainWindow();
        mainWindow.re_paint();
        mainWindow.getToolPane().getTrgInfoPane().updateInfos(this.tc);
    }

    private void applyTrgMode2(int n, int n2, TrgTypeDefine trgTypeDefine) {
        if (this.cm.singleVideoAlow(trgTypeDefine, n, this.tc)) {
            TriggerSet triggerSet = this.getTriggerSet(n2);
            this.getTriggerSet(n2).setTrigger(triggerSet.getTriggerSet(trgTypeDefine));
            this.tc.doSubmit();
        } else {
            this.cm.pcs.firePropertyChange("CHOOSE_TRGMODECB", null, (Object)this.getCurrentTrigger().type);
        }
    }

    public String getTrgType() {
        return this.trgTypes[this.tc.getChannelMode()];
    }

    public String setTrgType(String string) {
        for (int i = 0; i < this.trgTypes.length; ++i) {
            if (!string.equalsIgnoreCase(this.trgTypes[i])) continue;
            this.tc.c_setChannelMode(i);
            this.updateAllTrgUI(i);
            return "SUCCESS";
        }
        return "FIALED";
    }

    public String getSweepMode() {
        int n = this.getCurrentTrigger().getSweep();
        if (this.tc.getSingleTriggerSet().isCurrentTrigger_Video() && this.tc.isSingleTrg()) {
            return "FIALED,AT VIDEO MODE";
        }
        return this.trgSweepMode[n];
    }

    public String setSweepMode(String string) {
        TriggerSet triggerSet = this.tc.getSingleTriggerSet();
        if (!this.tc.isSingleTrg()) {
            return "FIALED,AT ALTERNATE MODE";
        }
        if (triggerSet.isCurrentTrigger_Video()) {
            return "FIALED,AT VIDEO MODE";
        }
        for (int i = 0; i < this.trgSweepMode.length; ++i) {
            if (!string.equalsIgnoreCase(this.trgSweepMode[i])) continue;
            triggerSet.getTrigger().c_setSweep(i, this.tc);
            this.tc.doSubmit();
            this.cm.pcs.firePropertyChange("T_SweepOnce2Auto", null, (Object)i);
            return "SUCCESS";
        }
        return "FIALED";
    }

    public String getTrgTypMode(int n) {
        TriggerSet triggerSet = this.getTriggerSet(n);
        return triggerSet.getTrigger().getName();
    }

    public String setTrgTypMode(int n, String string) {
        TrgTypeDefine trgTypeDefine = null;
        for (TrgTypeDefine trgTypeDefine2 : TrgTypeDefine.VALUES) {
            if (!trgTypeDefine2.name().equalsIgnoreCase(string)) continue;
            trgTypeDefine = trgTypeDefine2;
            break;
        }
        if (trgTypeDefine == null) {
            return "FIALED";
        }
        int n2 = this.getTriggerSetChannel(n);
        this.applyTrgMode2(n2, n, trgTypeDefine);
        this.updateTrgInfoPane();
        this.cm.pcs.firePropertyChange("APPLY_TRIGGER", null, (Object)n);
        return "SUCCESS";
    }

    public String getSingle_Source() {
        int n = 0;
        int n2 = this.getTriggerSetChannel(n) + 1;
        if (n2 > this.cm.getAllChannelsNumber()) {
            return "EXT";
        }
        return "CH" + n2;
    }

    public String getAlt_EdgeSource() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TriggerSet triggerSet : this.tc.getAltTriggerSets()) {
            if (!triggerSet.isCurrentTrigger_Edge()) continue;
            stringBuilder.append("CH" + (triggerSet.getChannel() + 1) + " ");
        }
        if (stringBuilder.length() == 0) {
            return "Edge Mode Not Selected";
        }
        return stringBuilder.toString();
    }

    public String getAlt_VideoSource() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TriggerSet triggerSet : this.tc.getAltTriggerSets()) {
            if (!triggerSet.isCurrentTrigger_Video()) continue;
            stringBuilder.append("CH" + (triggerSet.getChannel() + 1) + " ");
        }
        if (stringBuilder.length() == 0) {
            return "Video Mode Not Selected";
        }
        return stringBuilder.toString();
    }

    public String set_Source(String string, int n, TrgTypeDefine trgTypeDefine) {
        if (string.toUpperCase().startsWith("CH")) {
            string = string.substring("CH".length());
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string) - 1;
        }
        catch (Exception exception) {
            return "FIALED";
        }
        if (n2 < 0 || n2 > this.cm.getAllChannelsNumber() - 1) {
            return "ERR CHANNEL";
        }
        this.tc.c_setChannelMode(n);
        if (n == 1) {
            this.setCurrentAltChannel(n2);
        } else {
            this.tc.setSingleChannel(n2);
            this.cm.pcs.firePropertyChange("NextSingleChannel", null, (Object)this.tc.singleTriggerSet.getChannel());
            this.tc.doSubmit();
        }
        this.applyTrgMode2(n2, n, trgTypeDefine);
        this.updateAllTrgUI(n);
        return "SUCCESS";
    }

    public String get_EdgeSlope(int n) {
        return this.getTriggerSet((int)n).edge.getSlope();
    }

    public String set_EdgeSlope(int n, String string) {
        String string2 = this.getTriggerSet((int)n).edge.setSlope(string);
        this.tc.doSubmit();
        this.updateTrgInfoPane();
        this.cm.pcs.firePropertyChange("NextStatus", 0, 1);
        return string2;
    }

    public String get_EdgeLevel(int n) {
        int n2 = this.getTriggerSetChannel(n);
        if (this.tc.isExtTrg(n2)) {
            return "EXT";
        }
        ChannelInfo channelInfo = this.wfm.getWaveForm((int)n2).wfi.ci;
        TriggerSet triggerSet = this.getTriggerSet(n);
        String string = triggerSet.edge.getLabelText(channelInfo);
        return string;
    }

    private TriggerSet getTriggerSet(int n) {
        return this.tc.getTriggerUIInfo().getTriggerSet(n);
    }

    private int getTriggerSetChannel(int n) {
        return this.tc.getTriggerUIInfo().getTriggerSetChannel(n);
    }

    private AbsTrigger getCurrentTrigger() {
        return this.tc.getTriggerUIInfo().getCurrentTriggerSet().getTrigger();
    }

    private void setCurrentAltChannel(int n) {
        this.tc.getTriggerUIInfo().setCurrentAltChannel(n);
    }

    public String set_EdgeLevel(int n, String string) {
        int n2 = this.getTriggerSetChannel(n);
        if (this.tc.isExtTrg(n2)) {
            return "ERR CHANNEL:EXT";
        }
        TriggerSet triggerSet = this.getTriggerSet(n);
        ChannelInfo channelInfo = this.wfm.getWaveForm((int)n2).wfi.ci;
        VoltsensableTrigger voltsensableTrigger = (VoltsensableTrigger)triggerSet.getTrigger();
        if (!NB.isNum(string)) {
            return "NOT VALID NUMBER";
        }
        int n3 = (int)Double.parseDouble(string);
        boolean bl = voltsensableTrigger.c_setVoltsense(n3 = channelInfo.getInverseValue(n3));
        if (bl) {
            this.tc.getVTPatchable().submiteVoltsense(channelInfo.getNumber(), voltsensableTrigger);
        }
        this.cm.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
        this.cm.pcs.firePropertyChange("UpdateVoltsense", -1, channelInfo.getNumber());
        int n4 = triggerSet.getVoltsenseHalfRange();
        if (n3 > n4 || n3 < -n4) {
            return "SUCCESS," + voltsensableTrigger.c_getVoltsense();
        }
        return "SUCCESS";
    }

    public String get_VideoMod(int n) {
        return this.getTriggerSet((int)n).video.getMod();
    }

    public String set_VideoMod(int n, String string) {
        int n2;
        VideoTrigger videoTrigger = this.getTriggerSet((int)n).video;
        boolean bl = videoTrigger.setMod(string);
        if (!bl) {
            return "FIALED";
        }
        this.tc.doSubmit();
        int n3 = n2 = this.tc.isSingleTrg() ? 0 : 1;
        if (n == n2) {
            this.cm.pcs.firePropertyChange("updateVideoMod", null, videoTrigger);
        }
        return "SUCCESS";
    }

    public String get_VideoSync(int n) {
        return this.getTriggerSet((int)n).video.getSync();
    }

    public String set_VideoSync(int n, String string) {
        int n2;
        VideoTrigger videoTrigger = this.getTriggerSet((int)n).video;
        boolean bl = videoTrigger.setSync(string);
        if (!bl) {
            return "FIALED";
        }
        this.tc.doSubmit();
        int n3 = n2 = this.tc.isSingleTrg() ? 0 : 1;
        if (n == n2) {
            this.cm.pcs.firePropertyChange("NextStatus", null, videoTrigger);
        }
        this.updateTrgInfoPane();
        return "SUCCESS";
    }

    public String get_VideoLnum(int n) {
        return this.getTriggerSet((int)n).video.getLnum();
    }

    public String set_VideoLnum(int n, String string) {
        if (!NB.isNum(string)) {
            return "NOT VALID NUMBER";
        }
        VideoTrigger videoTrigger = this.getTriggerSet((int)n).video;
        if (videoTrigger.isSyncValueEnable()) {
            int n2;
            int n3;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                return "FIALED";
            }
            if (n3 < 0 && n3 >= 625) {
                return "NOT VALID NUMBER";
            }
            if (videoTrigger.syncValue != n3) {
                videoTrigger.syncValue = n3;
                this.tc.doSubmit();
            }
            this.updateTrgInfoPane();
            int n4 = n2 = this.tc.isSingleTrg() ? 0 : 1;
            if (n == n2) {
                this.cm.pcs.firePropertyChange("NextStatus", null, videoTrigger);
            }
            return "SUCCESS";
        }
        return "NOT ENABLE TO ADJUST";
    }
}

