/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.provider;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.measure.MeasureT;
import com.owon.uppersoft.vds.core.measure.VR;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class MeasureScpiProvider {
    private ControlManager cm;

    public MeasureScpiProvider(ControlManager controlManager) {
        this.cm = controlManager;
    }

    public String getRecVamp(int n) {
        ByteBuffer byteBuffer = Platform.getDataHouse().getWaveFormManager().getWaveForm(n).getADC_Buffer();
        if (byteBuffer == null) {
            return "?";
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.remaining();
        byte[] byArray = new byte[n3];
        System.arraycopy(byteBuffer.array(), n2, byArray, 0, n3);
        Arrays.sort(byArray);
        int n4 = 0;
        int n5 = (int)((double)byArray.length * 0.06);
        int n6 = byArray.length / 2 - n5;
        for (int i = n5; i < n6; ++i) {
            n4 += byArray[byArray.length - i] - byArray[i];
        }
        return Double.toString(1.0 * (double)n4 / (double)(n6 - n5));
    }

    public String getMeasureValue(int n, int n2, String[] stringArray) {
        if (!this.cm.getMeasureManager().ison()) {
            return "PLEASE ADD THE CHANNEL AND MEASURE TYPE FIRST";
        }
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        WaveForm waveForm = waveFormInfoControl.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        String string = stringArray[n2];
        if (string.equalsIgnoreCase("RECVamp")) {
            return this.getRecVamp(n);
        }
        boolean bl = this.isDelayType(string);
        if (bl) {
            double d = this.cm.measMod.getDelayValue(string, n);
            return d < 0.0 ? "?" : String.valueOf(d);
        }
        VR[] vRArray = waveForm.getMeasureADC().vrs;
        double d = vRArray[n2].v;
        MeasureT measureT = MeasureT.VALUES[n2];
        switch (measureT) {
            case PKPK: 
            case MAX: 
            case MIN: 
            case VAMP: 
            case VTOP: 
            case VBASe: 
            case AVERage: 
            case CYCRms: {
                d /= 1000.0;
            }
        }
        bl = vRArray[n2].vu == "?";
        return bl ? "?" : String.valueOf(d);
    }

    public String getMeasureSource() {
        return this.cm.measMod.getCHlinkElem();
    }

    public String setMeasureSource(String string) {
        String string2 = "CH";
        if (string.toUpperCase().startsWith(string2)) {
            string = string.substring(string2.length()).trim();
        }
        int n = -1;
        try {
            n = Integer.parseInt(string) - 1;
        }
        catch (Exception exception) {
            return "FIALED";
        }
        if (n < 0 || n > this.cm.getAllChannelsNumber() - 1) {
            return "ERR CHANNEL";
        }
        this.cm.measMod.addChElem(n);
        this.cm.getMeasureManager().setMeasureOn_enforce();
        return "SUCCESS";
    }

    public String addMeasureElem(String string) {
        boolean bl = this.isDelayType(string);
        if (bl) {
            bl = this.cm.measMod.addOrDelDelay(true, string);
            this.cm.getMeasureManager().setMeasureOn_enforce();
            return bl ? "SUCCESS" : "FIALED";
        }
        MeasureT[] measureTArray = MeasureT.VALUES;
        int n = MeasureT.Count;
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(measureTArray[i].toString())) continue;
            this.cm.measMod.addMtElem(i);
            this.cm.getMeasureManager().setMeasureOn_enforce();
            return "SUCCESS";
        }
        return "FIALED";
    }

    public String delMeasureElem(String string) {
        boolean bl = this.isDelayType(string);
        if (bl) {
            bl = this.cm.measMod.addOrDelDelay(false, string);
            this.cm.getMeasureManager().setMeasureOn_enforce();
            return bl ? "SUCCESS" : "FIALED";
        }
        if (string.equalsIgnoreCase("all")) {
            this.cm.measMod.removeAllMeasures();
            this.cm.getMeasureManager().setMeasureOn_enforce();
            return "SUCCESS";
        }
        MeasureT[] measureTArray = MeasureT.VALUES;
        int n = MeasureT.Count;
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(measureTArray[i].toString())) continue;
            boolean bl2 = this.cm.measMod.delMtElem(i);
            this.cm.getMeasureManager().setMeasureOn_enforce();
            return bl2 ? "SUCCESS" : "FIALED";
        }
        return "FIALED";
    }

    private boolean isDelayType(String string) {
        boolean bl = string.equalsIgnoreCase("RDELay") || string.equalsIgnoreCase("FDELay");
        return bl;
    }
}

