/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.provider;

import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.socket.provider.AcquireScpiProvider;
import com.owon.uppersoft.vds.socket.provider.ChannelScpiProvider;
import com.owon.uppersoft.vds.socket.provider.DisplayScpiProvider;
import com.owon.uppersoft.vds.socket.provider.FFTScpiProvider;
import com.owon.uppersoft.vds.socket.provider.LanScpiProvider;
import com.owon.uppersoft.vds.socket.provider.MeasureScpiProvider;
import com.owon.uppersoft.vds.socket.provider.TimebaseScpiProvider;
import com.owon.uppersoft.vds.socket.provider.TrgScpiProvider;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class MainProvider {
    protected ControlManager ctrm = Platform.getControlManager();
    private TrgScpiProvider trgPvd;
    private FFTScpiProvider fftPvd;
    private ChannelScpiProvider chlPvd;
    private MeasureScpiProvider measPvd;
    private AcquireScpiProvider acqPvd;
    private TimebaseScpiProvider tbPvd;
    private LanScpiProvider lanPvd;
    private DisplayScpiProvider dspPvd;

    public TrgScpiProvider getTrg() {
        if (this.trgPvd == null) {
            this.trgPvd = new TrgScpiProvider(this.ctrm);
        }
        return this.trgPvd;
    }

    public FFTScpiProvider getFFT() {
        if (this.fftPvd == null) {
            this.fftPvd = new FFTScpiProvider(this.ctrm);
        }
        return this.fftPvd;
    }

    public ChannelScpiProvider getChl() {
        if (this.chlPvd == null) {
            this.chlPvd = new ChannelScpiProvider(this.ctrm);
        }
        return this.chlPvd;
    }

    public AcquireScpiProvider getAcq() {
        if (this.acqPvd == null) {
            this.acqPvd = new AcquireScpiProvider(this.ctrm);
        }
        return this.acqPvd;
    }

    public TimebaseScpiProvider getTb() {
        if (this.tbPvd == null) {
            this.tbPvd = new TimebaseScpiProvider(this.ctrm);
        }
        return this.tbPvd;
    }

    public MeasureScpiProvider getMeas() {
        if (this.measPvd == null) {
            this.measPvd = new MeasureScpiProvider(this.ctrm);
        }
        return this.measPvd;
    }

    public LanScpiProvider getLan() {
        if (this.lanPvd == null) {
            this.lanPvd = new LanScpiProvider(this.ctrm);
        }
        return this.lanPvd;
    }

    public DisplayScpiProvider getDsp() {
        if (this.dspPvd == null) {
            this.dspPvd = new DisplayScpiProvider(this.ctrm);
        }
        return this.dspPvd;
    }

    public byte[] getData(String string) {
        Object object;
        int n = -1;
        if (string.trim().equals("*ADC?")) {
            n = this.getDefaultSelectWaveform();
        } else {
            int n2 = "*ADC?".length();
            string = string.substring(n2).trim();
            object = "CH";
            if (string.toUpperCase().startsWith((String)object)) {
                string = string.substring(((String)object).length()).trim();
            }
            try {
                n = Integer.parseInt(string) - 1;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (n < 0 || n > this.getMaxChannelIdx()) {
            return null;
        }
        WaveForm waveForm = Platform.getDataHouse().getWaveFormManager().getWaveForm(n);
        if (waveForm == null) {
            return null;
        }
        object = waveForm.getADC_Buffer();
        if (object == null) {
            return null;
        }
        int n3 = ((Buffer)object).position();
        int n4 = ((Buffer)object).remaining();
        byte[] byArray = new byte[n4];
        System.arraycopy(((ByteBuffer)object).array(), n3, byArray, 0, n4);
        return byArray;
    }

    public int getMaxChannelIdx() {
        return this.ctrm.getSupportChannelsNumber() - 1;
    }

    public int getDefaultSelectWaveform() {
        WaveFormInfoControl waveFormInfoControl = this.ctrm.getWaveFormInfoControl();
        return waveFormInfoControl.getSelectedWF().wfi.ci.getNumber();
    }

    public String getIDN() {
        SoftwareControl softwareControl = this.ctrm.getSoftwareControl();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.ctrm.getConfig().getStaticPref().getManufacturerId());
        stringBuilder.append(",");
        stringBuilder.append(this.ctrm.getCoreControl().getMachine().name());
        stringBuilder.append(",");
        stringBuilder.append(softwareControl.getBoardSeries());
        stringBuilder.append(",");
        stringBuilder.append(softwareControl.getBoardVersion());
        return stringBuilder.toString();
    }

    public String setFactoryDefault() {
        this.ctrm.factorySet();
        this.ctrm.pcs.firePropertyChange("UPDATE_FACTORY_VIEW", null, null);
        return "SUCCESS";
    }

    public String setAUTOset() {
        boolean bl = Platform.getControlApps().interComm.autoset();
        return bl ? "SUCCESS" : "FIALED";
    }

    public String setSHUTdown() {
        Platform.getMainWindow().getFrame().dispose();
        return "SUCCESS";
    }

    public String getRunStop() {
        return this.ctrm.isRuntime() ? "RUN" : "STOP";
    }

    public String setRunStop() {
        if (!this.ctrm.sourceManager.isConnected()) {
            return "NOT CONNECT";
        }
        boolean bl = this.ctrm.isRuntime();
        Platform.getMainWindow().getTitlePane().askSwitchRS();
        return !bl ? "SET RUN" : "SET STOP";
    }

    public String getTitleStatus() {
        return this.ctrm.getTitleStatusLabel();
    }
}

