/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.provider;

import com.owon.uppersoft.dso.function.FFTView;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.FFTControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.fft.WndType;

public class FFTScpiProvider {
    private ControlManager cm;
    private FFTControl fftc;
    private DataHouse dh;
    private FFTView fftv;

    public FFTScpiProvider(ControlManager controlManager) {
        this.cm = controlManager;
        this.dh = Platform.getDataHouse();
        this.fftc = this.cm.getFFTControl();
        this.fftv = this.dh.getWaveFormManager().getFFTView();
    }

    public String getIsDisplay() {
        return this.fftc.isFFTon() ? "ON" : "OFF";
    }

    public String setDisplay(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("ON")) {
            bl = true;
        } else if (string.equalsIgnoreCase("OFF")) {
            bl = false;
        } else {
            return "FIALED";
        }
        this.fftc.c_setFFTon(bl);
        this.dh.getMainWindow().getToolPane().getButtonPane().switch_3in1_fft(bl);
        if (!this.cm.sourceManager.isConnected() && bl) {
            this.fftv.updateFFT();
        }
        this.cm.pcs.firePropertyChange("CHANGE_FFT", null, (Object)bl);
        return "SUCCESS";
    }

    public String getSource() {
        return "CH" + (this.fftc.getFFTchl() + 1);
    }

    public String setSource(String string) {
        int n;
        String string2 = "CH";
        if (string.toUpperCase().startsWith(string2)) {
            string = string.substring(string2.length()).trim();
        }
        try {
            n = Integer.parseInt(string) - 1;
        }
        catch (Exception exception) {
            return "FIALED";
        }
        if (!this.fftc.isFFTon()) {
            return "TURN ON FFT FIRST";
        }
        WaveFormManager waveFormManager = this.dh.getWaveFormManager();
        WaveForm waveForm = waveFormManager.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        this.fftc.c_setFFTchl(n);
        this.fftv.updateFFT();
        this.dh.getMainWindow().getToolPane().getInfoPane().repaint();
        this.cm.pcs.firePropertyChange("UPDATE_FFT", null, (Object)false);
        return "SUCCESS";
    }

    public String getWINDow() {
        WndType[] wndTypeArray = FFTView.wndTypes;
        return wndTypeArray[this.fftc.getFFTwnd()].toString();
    }

    public String setWINDow(String string) {
        if (!this.fftc.isFFTon()) {
            return "TURN ON FFT FIRST";
        }
        WndType[] wndTypeArray = FFTView.wndTypes;
        for (int i = 0; i < wndTypeArray.length; ++i) {
            if (!string.equalsIgnoreCase(wndTypeArray[i].toString())) continue;
            this.fftc.setFFTwnd(i);
            this.fftv.updateFFT();
            this.cm.pcs.firePropertyChange("UPDATE_FFT", null, (Object)false);
            return "SUCCESS";
        }
        return "FIALED";
    }

    public String getFORMat() {
        return this.fftc.getFORMat();
    }

    public String setFORMat(String string) {
        Object object;
        int n;
        if (!this.fftc.isFFTon()) {
            return "TURN ON FFT FIRST";
        }
        int n2 = -1;
        String[] stringArray = FFTControl.format;
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n].toUpperCase();
            if (!string.startsWith((String)object)) continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            return "FIALED";
        }
        n = -1;
        block1 : switch (n2) {
            case 0: {
                string = string.substring(stringArray[0].length()).trim();
                try {
                    object = Double.parseDouble(string);
                    object = (Double)object * 1000.0;
                }
                catch (Exception exception) {
                    return "FIALED";
                }
                for (int i = 0; i < this.fftc.VOLTAGEs.length; ++i) {
                    if ((Double)object != (double)this.fftc.VOLTAGEs[i].getValue()) continue;
                    this.fftc.fftvaluetype = n2;
                    n = this.fftv.vrmsbaseidx = i;
                    break block1;
                }
                break;
            }
            case 1: {
                string = string.substring(stringArray[1].length()).trim();
                for (int i = 0; i < this.fftc.dBPerDiv.length; ++i) {
                    String string2 = this.fftc.dBPerDiv[i];
                    if (!string.equalsIgnoreCase(string2)) continue;
                    this.fftc.fftvaluetype = n2;
                    n = this.fftv.dBbaseidx = i;
                    break block1;
                }
                break;
            }
        }
        if (n < 0) {
            return "FIALED";
        }
        this.fftv.setVrmsIdx(n);
        this.fftv.updateFFT();
        this.cm.pcs.firePropertyChange("UPDATE_FFT", null, (Object)true);
        return "SUCCESS";
    }

    public String getZONE() {
        String[] stringArray = FFTControl.scale;
        return stringArray[this.fftc.fftscale];
    }

    public String setZONE(String string) {
        if (!this.fftc.isFFTon()) {
            return "TURN ON FFT FIRST";
        }
        String[] stringArray = FFTControl.scale;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            this.fftc.fftscale = i;
            this.fftv.scale();
            this.fftv.updateFFT();
            this.cm.pcs.firePropertyChange("UPDATE_FFT", null, (Object)false);
            return "SUCCESS";
        }
        return "FIALED";
    }

    public String getFREQbase() {
        int n = this.cm.getTimeControl().getTimebaseIdx();
        return this.cm.getMachineInfo().FFTTimeBases[n];
    }

    public String setFREQbase(String string) {
        if (!this.fftc.isFFTon()) {
            return "TURN ON FFT FIRST";
        }
        String[] stringArray = this.cm.getMachineInfo().FFTTimeBases;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].replaceAll("\\s*", "");
            if (!string.equalsIgnoreCase(string2)) continue;
            Platform.getMainWindow().getToolPane().getDetailPane().changeFFTTimeBase(i);
            this.fftv.updateFFT();
            this.cm.pcs.firePropertyChange("UPDATE_FFT", null, (Object)false);
            return "SUCCESS";
        }
        return "FIALED";
    }
}

