/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.provider;

import com.owon.uppersoft.dso.function.FFTCursorControl;
import com.owon.uppersoft.dso.function.MarkCursorControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;

public class DisplayScpiProvider {
    private ControlManager cm;
    private MarkCursorControl mcc;
    private FFTCursorControl fcc;
    private final String[] cursors = new String[]{"TIME", "VOLT", "FREQuency", "AMPLitude"};
    private final String VECTOR = "VECTOR";
    private final String DOT = "DOT";
    private final String[] persistence = new String[]{"Off", "0.5s", "1s", "2s", "5s", "Infinite", "Phosphor"};

    public DisplayScpiProvider(ControlManager controlManager) {
        this.cm = controlManager;
        this.mcc = this.cm.mcctr;
        this.fcc = this.cm.fftctr;
    }

    public String getCursor() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mcc.getOnTimebaseM()) {
            stringBuilder.append(this.cursors[0] + " ");
        }
        if (this.mcc.getOnVoltbaseM()) {
            stringBuilder.append(this.cursors[1] + " ");
        }
        if (this.fcc.getOnFrebaseMark()) {
            stringBuilder.append(this.cursors[2] + " ");
        }
        if (this.fcc.getOnVoltbaseMark()) {
            stringBuilder.append(this.cursors[3]);
        }
        if (stringBuilder.length() <= 0) {
            stringBuilder.append("CURSOR ALL CLOSED");
        }
        return stringBuilder.toString();
    }

    public String setCursor(String string, boolean bl) {
        for (int i = 0; i < this.cursors.length; ++i) {
            if (!string.equalsIgnoreCase(this.cursors[i])) continue;
            switch (i) {
                case 0: {
                    this.mcc.setOnTimebaseM(bl);
                    break;
                }
                case 1: {
                    this.mcc.setOnVoltbaseM(bl);
                    break;
                }
                case 2: {
                    this.fcc.setOnFrebaseMark(bl);
                    break;
                }
                case 3: {
                    this.fcc.setOnVoltbaseMark(bl);
                }
            }
            Platform.getMainWindow().re_paint();
            this.cm.pcs.firePropertyChange("UPDATE_CURSOR", null, null);
            return "SUCCESS";
        }
        return "FIALED";
    }

    public String getDraw() {
        return this.cm.displayControl.linelink ? "VECTOR" : "DOT";
    }

    public String setDraw(String string) {
        if (string.equalsIgnoreCase("VECTOR")) {
            this.cm.displayControl.linelink = true;
        } else if (string.equalsIgnoreCase("DOT")) {
            this.cm.displayControl.linelink = false;
        } else {
            return "FIALED";
        }
        Platform.getMainWindow().updateShow();
        this.cm.pcs.firePropertyChange("UPDATE_LINELINK", null, null);
        return "SUCCESS";
    }

    public String getPersistence() {
        int n = this.cm.displayControl.getPersistenceIndex();
        return this.persistence[n];
    }

    public String setPersistence(String string) {
        int n = this.persistence.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(this.persistence[i])) continue;
            if (string.equalsIgnoreCase("Phosphor") && !this.cm.displayControl.isPhosphorOn()) {
                return "THIS MACHINE NOT SUPPORT PHOSPHOR";
            }
            int n2 = this.cm.displayControl.setPersistenceIndex(i);
            Platform.getDataHouse().getPersistentDisplay().fadeThdOn_Off_UI(n2);
            this.cm.pcs.firePropertyChange("UPDATE_PERSISTENCE_INDEX", null, null);
            return "SUCCESS";
        }
        return "FIALED";
    }
}

