/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.socket.provider;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.view.sub.InfoBlock;
import com.owon.uppersoft.dso.view.sub.InfoBlockAction;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.socket.NB;

public class ChannelScpiProvider {
    private ControlManager cm;

    public ChannelScpiProvider(ControlManager controlManager) {
        this.cm = controlManager;
    }

    public boolean getIsChannelDisplay(int n) {
        return this.cm.getCoreControl().getWaveFormInfo((int)n).ci.isOn();
    }

    public String setChannelDisplay(int n, String string) {
        ChannelInfo channelInfo = this.cm.getCoreControl().getWaveFormInfo((int)n).ci;
        if (string.equalsIgnoreCase("ON")) {
            channelInfo.c_setOn(true);
        } else if (string.equalsIgnoreCase("OFF")) {
            channelInfo.c_setOn(false);
        } else {
            return "FIALED";
        }
        Platform.getMainWindow().updateDefaultAll();
        return "SUCCESS";
    }

    public String getChannelCoupling(int n) {
        WaveForm waveForm = this.cm.getWaveFormInfoControl().getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        return ChannelInfo.COUPLINGCHARS[waveForm.wfi.ci.getCouplingIdx()];
    }

    public String setChannelCoupling(int n, String string) {
        int n2 = -1;
        String[] stringArray = ChannelInfo.COUPLINGCHARS;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return "FIALED";
        }
        WaveForm waveForm = this.cm.getWaveFormInfoControl().getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        waveForm.wfi.ci.c_setCoupling(n2);
        this.cm.pcs.firePropertyChange("CouplingOption", null, null);
        Platform.getMainWindow().updateDefaultAll();
        return "SUCCESS";
    }

    public String getChannelProbe(int n) {
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        WaveForm waveForm = waveFormInfoControl.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        return waveForm.wfi.ci.getProbeLabel();
    }

    public String setChannelProbe(int n, String string) {
        int n2 = -1;
        String[] stringArray = this.cm.getMachineInfo().ProbeTexts;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return "FIALED";
        }
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        WaveForm waveForm = waveFormInfoControl.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        waveForm.wfi.ci.setProbeMultiIdx(n2);
        this.cm.updateChannelVoltValueEverywhere(n);
        return "SUCCESS";
    }

    public double getChannelSCALe(int n) {
        double d = this.cm.getCoreControl().getWaveFormInfo((int)n).ci.getVoltValue();
        return d / 1000.0;
    }

    public String setChannelSCALe(int n, String string) {
        double d;
        if (!NB.isNum(string)) {
            return "NOT VALID NUMBER";
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            return "FIALED";
        }
        d *= 1000.0;
        ChannelInfo.Volt[] voltArray = this.cm.getCoreControl().getWaveFormInfo((int)n).ci.getVoltageLabels();
        int n2 = -1;
        int n3 = voltArray.length;
        for (int i = 0; i < n3; ++i) {
            if ((double)voltArray[i].getValue() != d) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return "FIALED";
        }
        InfoBlock infoBlock = Platform.getMainWindow().getToolPane().getInfoPane().get(n);
        InfoBlockAction infoBlockAction = infoBlock.getInfoBlockDelegate();
        infoBlockAction.removeOwnedComboBox();
        infoBlockAction.selected(n2);
        infoBlock.repaint();
        return "SUCCESS";
    }

    public String getChannelOFFSet(int n) {
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        WaveForm waveForm = waveFormInfoControl.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        return String.valueOf(waveForm.wfi.ci.getPos0());
    }

    public String setChannelOFFSet(int n, String string) {
        if (!NB.isNum(string)) {
            return "NOT VALID NUMBER";
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return "FIALED";
        }
        InfoBlock infoBlock = Platform.getMainWindow().getToolPane().getInfoPane().get(n);
        if (infoBlock == null) {
            return "ERR CHANNEL";
        }
        InfoBlockAction infoBlockAction = infoBlock.getInfoBlockDelegate();
        n2 = infoBlockAction.valueChanged_Directly(n2);
        return "SUCCESS,Valid Set:" + String.valueOf(n2);
    }

    public String getHardwareFrequency(int n) {
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        WaveForm waveForm = waveFormInfoControl.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        return this.cm.getFreqLabel(waveForm.wfi.ci);
    }

    public String getINVerseState(int n) {
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        WaveForm waveForm = waveFormInfoControl.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        return waveForm.wfi.ci.isInverse() ? "ON" : "OFF";
    }

    public String setINVerseState(int n, String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("ON")) {
            bl = true;
        } else if (string.equalsIgnoreCase("OFF")) {
            bl = false;
        } else {
            return "FIALED";
        }
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        WaveForm waveForm = waveFormInfoControl.getWaveForm(n);
        if (waveForm == null) {
            return "ERR CHANNEL";
        }
        waveForm.wfi.ci.c_setInverse(bl);
        this.cm.pcs.firePropertyChange("ChannelOpposite", null, null);
        Platform.getMainWindow().updateShow();
        return "SUCCESS";
    }
}

