/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.print;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.aspect.help.IPrintable;
import com.owon.uppersoft.vds.print.CustomScaleWindow;
import com.owon.uppersoft.vds.print.PageEdgeSetup;
import com.owon.uppersoft.vds.print.Printer;
import com.owon.uppersoft.vds.print.PrinterPreviewControl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrinterPreviewFrame
implements Localizable {
    private static PrinterPreviewFrame instance;
    private static final String PRINT_MESSAGE = "Print.Message";
    private static final String PRINT_SET_PRE_PAGE_BACK = "Print.SetPrePageBack";
    private static final String PRINT_SHOW_WAVE_BACK = "Print.ShowWaveBack";
    private static final String PRINT__DEFAULT_SCALE = "Print._DefaultScale";
    private static final String PRINT_FACE_SIZE = "Print.FaceSize";
    private static final String PRINT_WHOLE_PAGE = "Print.WholePage";
    private static final String PRINT_PAGE_TRANSFORM = "Print.PageTransform";
    private static final String PRINT_EXIT = "Print.Exit";
    private static final String PRINT_PRINT = "Print.Print";
    private static final String PRINT_PAGE_SET = "Print.PageSet";
    private static final String PRINT_VIEW = "Print.View";
    private static final String PRINT_FILE = "Print.File";
    private static final String PRINT_PRINT_PREVIEW_FRAME = "Print.PrintPreviewFrame";
    private JFrame frame;
    private CustomScaleWindow customScaWin;
    private PageEdgeSetup pageEdgeSet;
    private IPrintable chartScreen;
    private Window mw;
    public PrinterPreviewControl ppc;
    private JMenuBar jMenuBarOne;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private JCheckBoxMenuItem showWFBGmenuItem;
    private JMenuItem paperBGMenuItem;
    private JMenuItem customizeMenuItem;
    private JMenuItem realPageMenuItem;
    private JMenuItem wholePageMenuItem;
    private JCheckBoxMenuItem hvtransformMenuItem;
    private JMenuItem pageSetupMenuItem;
    private JMenuItem printMenuItem;
    private JMenuItem exitMenuItem;
    double dpiScale;
    int dpi;
    double scale = 1.0;
    double defaultEdgeSpace = 20.0;
    public static final double inchPerMM = 25.4;
    public static final int A4PaperXPixels = 2480;
    public static final int A4PaperYPixels = 3508;
    public static final int A4PaperBorderTrim = 75;
    public static final int DefaultPrinterDPI = 300;
    public static final int A4PaperClientXPixels = 2330;
    public static final int A4PaperClientYPixels = 3358;
    private int A4EdgeSpace;
    private int A4PageWidth;
    private int A4PageHeight;
    private String message;
    private String title;
    Color A4PageBackground = Color.white;
    MyJScrollPane scrollPanel;

    public static void handlePrinterPreview(MainWindow mainWindow, ControlManager controlManager) {
        if (instance == null || !instance.isDisplayable()) {
            instance = new PrinterPreviewFrame(mainWindow.getChartScreen(), mainWindow.getWindow(), controlManager.ppc);
            controlManager.getLocalizeCenter().addLocalizable(instance);
        } else {
            instance.toFront();
        }
    }

    public static void selfRepaint() {
        if (instance != null) {
            instance.getPFrame().repaint();
        }
    }

    public PrinterPreviewFrame(IPrintable iPrintable, Window window, PrinterPreviewControl printerPreviewControl) {
        this.mw = window;
        this.chartScreen = iPrintable;
        this.ppc = printerPreviewControl;
        this.initialize();
        this.frame.setLocationRelativeTo(null);
        this.frame.setExtendedState(6);
        this.localize(PrinterPreviewControl.bundle());
        this.frame.setVisible(true);
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                instance = null;
            }
        });
        this.mw.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (PrinterPreviewFrame.this.frame != null) {
                    PrinterPreviewFrame.this.frame.dispose();
                    PrinterPreviewFrame.this.frame = null;
                }
                instance = null;
            }
        });
        this.frame.setBounds(0, 20, 1000, 728);
        this.frame.setDefaultCloseOperation(2);
        this.dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        this.dpiScale = (double)this.dpi / 300.0;
        this.A4EdgeSpace = (int)(this.defaultEdgeSpace / 25.4 * (double)this.dpi);
        if (this.ppc.isVertical) {
            this.A4PageWidth = (int)(2480.0 * this.dpiScale);
            this.A4PageHeight = (int)(3508.0 * this.dpiScale);
        } else {
            this.A4PageWidth = (int)(3508.0 * this.dpiScale);
            this.A4PageHeight = (int)(2480.0 * this.dpiScale);
        }
        this.jMenuBarOne = new JMenuBar();
        this.fileMenu = new JMenu();
        this.viewMenu = new JMenu();
        this.frame.setJMenuBar(this.jMenuBarOne);
        this.jMenuBarOne.add(this.fileMenu);
        this.jMenuBarOne.add(this.viewMenu);
        this.pageSetupMenuItem = new JMenuItem();
        this.pageSetupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.this.pageEdgeSet = new PageEdgeSetup(PrinterPreviewFrame.this.getPrinterPreviewFrame());
            }
        });
        this.printMenuItem = new JMenuItem();
        this.printMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrinterPreviewFrame.this.ppc.isPaintWFBG) {
                    int n = JOptionPane.showConfirmDialog(PrinterPreviewFrame.this.frame, PrinterPreviewFrame.this.message, PrinterPreviewFrame.this.title, 0, 3);
                    if (n == 0) {
                        PrinterPreviewFrame.this.ppc.isPaintWFBG = true;
                    } else if (n == 1) {
                        PrinterPreviewFrame.this.ppc.isPaintWFBG = false;
                        PrinterPreviewFrame.this.scrollPanel.repaint();
                    } else {
                        if (n != 2) {
                            // empty if block
                        }
                        return;
                    }
                }
                Printer printer = new Printer(PrinterPreviewFrame.this.getPrinterPreviewFrame());
            }
        });
        this.exitMenuItem = new JMenuItem();
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.this.frame.dispose();
            }
        });
        this.fileMenu.add(this.pageSetupMenuItem);
        this.fileMenu.add(this.printMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.hvtransformMenuItem = new JCheckBoxMenuItem();
        this.hvtransformMenuItem.setSelected(!this.ppc.isVertical);
        this.hvtransformMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.this.setHVPageTransform();
            }
        });
        this.wholePageMenuItem = new JMenuItem();
        this.wholePageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = (double)PrinterPreviewFrame.this.scrollPanel.getSize().height / (double)PrinterPreviewFrame.this.A4PageHeight;
                PrinterPreviewFrame.this.setScale(d);
            }
        });
        this.realPageMenuItem = new JMenuItem();
        this.realPageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.this.setScale(1.0);
            }
        });
        this.customizeMenuItem = new JMenuItem();
        this.customizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.this.customScaWin = new CustomScaleWindow(PrinterPreviewFrame.this.getPrinterPreviewFrame());
            }
        });
        this.showWFBGmenuItem = new JCheckBoxMenuItem();
        this.showWFBGmenuItem.setSelected(this.ppc.isPaintWFBG);
        this.showWFBGmenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.this.ppc.isPaintWFBG = !PrinterPreviewFrame.this.ppc.isPaintWFBG;
                PrinterPreviewFrame.this.scrollPanel.repaint();
            }
        });
        this.paperBGMenuItem = new JMenuItem();
        this.paperBGMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.this.setA4PageBackground();
                PrinterPreviewFrame.this.scrollPanel.repaint();
            }
        });
        this.viewMenu.add(this.hvtransformMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.wholePageMenuItem);
        this.viewMenu.add(this.realPageMenuItem);
        this.viewMenu.add(this.customizeMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.showWFBGmenuItem);
        this.viewMenu.add(this.paperBGMenuItem);
        this.scrollPanel = new MyJScrollPane(this.frame);
        this.fileMenu.setMnemonic('F');
        this.viewMenu.setMnemonic('V');
        this.pageSetupMenuItem.setMnemonic('S');
        this.printMenuItem.setMnemonic('P');
        this.exitMenuItem.setMnemonic('E');
        this.hvtransformMenuItem.setMnemonic('T');
        this.customizeMenuItem.setMnemonic('D');
        this.showWFBGmenuItem.setMnemonic('W');
        this.reScroll();
    }

    public PrinterPreviewFrame getPrinterPreviewFrame() {
        return this;
    }

    public void setPageEdgeSpace(Rectangle rectangle) {
        this.ppc.leftEdgeLength = rectangle.x;
        this.ppc.rightEdgeLength = rectangle.y;
        this.ppc.upEdgeLength = rectangle.width;
        this.ppc.downEdgeLength = rectangle.height;
        this.reScroll();
    }

    public void toFront() {
        this.frame.toFront();
        this.reScroll();
    }

    public boolean isDisplayable() {
        return this.frame.isDisplayable();
    }

    public JFrame getPFrame() {
        return this.frame;
    }

    public Rectangle getPageEdgeSpace() {
        return new Rectangle(this.ppc.leftEdgeLength, this.ppc.rightEdgeLength, this.ppc.upEdgeLength, this.ppc.downEdgeLength);
    }

    public void setScale(double d) {
        this.scale = d;
        this.reScroll();
    }

    public double getScale() {
        return this.scale;
    }

    public void setA4PageBackground() {
        Color color = JColorChooser.showDialog(this.frame, "Demo", this.A4PageBackground);
        if (color != null) {
            this.A4PageBackground = color;
        }
    }

    public void setHVPageTransform() {
        this.ppc.isVertical = !this.ppc.isVertical;
        this.frame.dispose();
        this.initialize();
        this.frame.setLocationRelativeTo(null);
        this.frame.setExtendedState(6);
        this.localize(PrinterPreviewControl.bundle());
        this.frame.setVisible(true);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        if (this.frame == null) {
            return;
        }
        this.frame.setTitle(resourceBundle.getString(PRINT_PRINT_PREVIEW_FRAME));
        this.fileMenu.setText(resourceBundle.getString(PRINT_FILE));
        this.viewMenu.setText(resourceBundle.getString(PRINT_VIEW));
        this.pageSetupMenuItem.setText(resourceBundle.getString(PRINT_PAGE_SET));
        this.printMenuItem.setText(resourceBundle.getString(PRINT_PRINT));
        this.exitMenuItem.setText(resourceBundle.getString(PRINT_EXIT));
        this.hvtransformMenuItem.setText(resourceBundle.getString(PRINT_PAGE_TRANSFORM));
        this.wholePageMenuItem.setText(resourceBundle.getString(PRINT_WHOLE_PAGE));
        this.realPageMenuItem.setText(resourceBundle.getString(PRINT_FACE_SIZE));
        this.customizeMenuItem.setText(resourceBundle.getString(PRINT__DEFAULT_SCALE));
        this.showWFBGmenuItem.setText(resourceBundle.getString(PRINT_SHOW_WAVE_BACK));
        this.paperBGMenuItem.setText(resourceBundle.getString(PRINT_SET_PRE_PAGE_BACK));
        this.message = resourceBundle.getString(PRINT_MESSAGE);
        if (this.customScaWin != null) {
            this.customScaWin.localize(resourceBundle);
        }
        if (this.pageEdgeSet != null) {
            this.pageEdgeSet.localize(resourceBundle);
        }
    }

    private void reScroll() {
        this.scrollPanel.reScroll();
        this.scrollPanel.repaint();
    }

    public void printChartView(Graphics2D graphics2D, int n, int n2) {
        this.chartScreen.printView(graphics2D, n, n2);
    }

    public void drawChartViewBG(Graphics2D graphics2D, int n) {
        if (this.ppc.isPaintWFBG) {
            graphics2D.setColor(Color.black);
            int n2 = n * this.chartScreen.getHeight() / this.chartScreen.getWidth();
            graphics2D.fillRect(0, 0, n, n2);
        }
    }

    public class MyJScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 584209475191317835L;
        private Mypanel panel;

        public MyJScrollPane(JFrame jFrame) {
            this.panel = new Mypanel();
            jFrame.getContentPane().add((Component)this, "Center");
            this.setPreferredSize(new Dimension(100, 100));
            this.setViewportView(this.panel);
            this.setHorizontalScrollBarPolicy(30);
            this.setVerticalScrollBarPolicy(20);
            this.setVisible(true);
        }

        public JPanel getPanel() {
            return this.panel;
        }

        private void reScroll() {
            int n = 0;
            n = (double)PrinterPreviewFrame.this.A4PageWidth * PrinterPreviewFrame.this.scale < (double)PrinterPreviewFrame.this.scrollPanel.getSize().width ? PrinterPreviewFrame.this.scrollPanel.getSize().width : (int)((double)PrinterPreviewFrame.this.A4PageWidth * PrinterPreviewFrame.this.scale);
            int n2 = 0;
            n2 = (double)PrinterPreviewFrame.this.A4PageHeight * PrinterPreviewFrame.this.scale < (double)PrinterPreviewFrame.this.scrollPanel.getSize().height ? PrinterPreviewFrame.this.scrollPanel.getSize().height : (int)((double)PrinterPreviewFrame.this.A4PageHeight * PrinterPreviewFrame.this.scale);
            this.panel.setPreferredSize(new Dimension(n, n2));
            PrinterPreviewFrame.this.scrollPanel.doLayout();
        }
    }

    class Mypanel
    extends JPanel {
        private static final long serialVersionUID = -7620249394827072345L;

        Mypanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawRect((this.getWidth() - (int)((double)PrinterPreviewFrame.this.A4PageWidth * PrinterPreviewFrame.this.scale)) / 2, 0, (int)((double)PrinterPreviewFrame.this.A4PageWidth * PrinterPreviewFrame.this.scale), (int)((double)PrinterPreviewFrame.this.A4PageHeight * PrinterPreviewFrame.this.scale));
            graphics2D.setColor(PrinterPreviewFrame.this.A4PageBackground);
            graphics2D.fillRect((PrinterPreviewFrame.this.scrollPanel.getPanel().getSize().width - (int)((double)PrinterPreviewFrame.this.A4PageWidth * PrinterPreviewFrame.this.scale)) / 2 + 1, 1, (int)((double)PrinterPreviewFrame.this.A4PageWidth * PrinterPreviewFrame.this.scale) - 1, (int)((double)PrinterPreviewFrame.this.A4PageHeight * PrinterPreviewFrame.this.scale) - 1);
            float[] fArray = new float[]{6.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f};
            BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(Color.red);
            int n = (int)((double)(PrinterPreviewFrame.this.scrollPanel.getPanel().getSize().width / 2) - PrinterPreviewFrame.this.scale * (double)PrinterPreviewFrame.this.A4PageWidth / 2.0 + PrinterPreviewFrame.this.scale * ((double)PrinterPreviewFrame.this.ppc.leftEdgeLength / 25.4 * (double)PrinterPreviewFrame.this.dpi));
            int n2 = (int)((double)PrinterPreviewFrame.this.ppc.upEdgeLength / 25.4 * (double)PrinterPreviewFrame.this.dpi * PrinterPreviewFrame.this.scale);
            int n3 = (int)((double)PrinterPreviewFrame.this.A4PageWidth * PrinterPreviewFrame.this.scale - PrinterPreviewFrame.this.scale * ((double)PrinterPreviewFrame.this.ppc.leftEdgeLength / 25.4 * (double)PrinterPreviewFrame.this.dpi + (double)PrinterPreviewFrame.this.ppc.rightEdgeLength / 25.4 * (double)PrinterPreviewFrame.this.dpi));
            int n4 = (int)((double)PrinterPreviewFrame.this.A4PageHeight * PrinterPreviewFrame.this.scale - PrinterPreviewFrame.this.scale * ((double)PrinterPreviewFrame.this.ppc.upEdgeLength / 25.4 * (double)PrinterPreviewFrame.this.dpi + (double)PrinterPreviewFrame.this.ppc.downEdgeLength / 25.4 * (double)PrinterPreviewFrame.this.dpi));
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.translate(n, n2);
            PrinterPreviewFrame.this.drawChartViewBG(graphics2D, n3);
            float f = 0.0f;
            graphics2D.setStroke(new BasicStroke(f, 2, 1));
            PrinterPreviewFrame.this.chartScreen.printView(graphics2D, n3, n4);
        }
    }
}

