/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.print;

import com.owon.uppersoft.vds.print.PrinterPreviewFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class Printer
implements Printable {
    public static final int A4PageWidth = 595;
    public static final int A4PageHeight = 842;
    public int A4EdgeLeftSpace = 57;
    public int A4EdgeRightSpace = 57;
    public int A4EdgeUpSpace = 57;
    public int A4EdgeDownSpace = 57;
    PrinterPreviewFrame ppf;
    float[] dash2 = new float[]{6.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f};
    BasicStroke bs = new BasicStroke(2.0f, 0, 0, 10.0f, this.dash2, 0.0f);

    public Printer(PrinterPreviewFrame printerPreviewFrame) {
        this.ppf = printerPreviewFrame;
        Rectangle rectangle = printerPreviewFrame.getPageEdgeSpace();
        this.A4EdgeLeftSpace = (int)((double)rectangle.x / 25.4 * 72.0);
        this.A4EdgeRightSpace = (int)((double)rectangle.y / 25.4 * 72.0);
        this.A4EdgeUpSpace = (int)((double)rectangle.width / 25.4 * 72.0);
        this.A4EdgeDownSpace = (int)((double)rectangle.height / 25.4 * 72.0);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        if (printerPreviewFrame.ppc.isVertical) {
            pageFormat.setOrientation(1);
        } else {
            pageFormat.setOrientation(0);
        }
        paper.setSize(595.0, 842.0);
        paper.setImageableArea(this.A4EdgeLeftSpace, this.A4EdgeUpSpace, 595 - this.A4EdgeLeftSpace - this.A4EdgeRightSpace, 842 - this.A4EdgeUpSpace - this.A4EdgeDownSpace);
        pageFormat.setPaper(paper);
        book.append(this, pageFormat);
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.setStroke(this.bs);
        graphics2D.setPaint(Color.red);
        graphics2D.drawRect(0, 0, (int)pageFormat.getImageableWidth() - 2, (int)pageFormat.getImageableHeight() - 2);
        this.ppf.drawChartViewBG(graphics2D, (int)pageFormat.getImageableWidth() - 2);
        graphics2D.setStroke(new BasicStroke());
        this.ppf.printChartView(graphics2D, (int)pageFormat.getImageableWidth() - 2, (int)pageFormat.getImageableHeight() - 2);
        return 0;
    }
}

