/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.print;

import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.print.PrinterPreviewControl;
import com.owon.uppersoft.vds.print.PrinterPreviewFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PageEdgeSetup
implements Localizable {
    private static final String ACTION_DEFAULT = "Action.Default";
    private static final String PRINT_SET_PRINT_SPACE = "Print.SetPrintSpace";
    private static final String PRINT_DOWN_SPACE = "Print.DownSpace";
    private static final String PRINT_UP_SPACE = "Print.UpSpace";
    private static final String PRINT_RIGHT_SPACE = "Print.RightSpace";
    private static final String PRINT_LEFT_SPACE = "Print.LeftSpace";
    private static final String PRINT_SET_PAGE_SPACE = "Print.SetPageSpace";
    private JSpinner downSpinner;
    private JSpinner upSpinner;
    private JSpinner rightSpinner;
    private JSpinner leftSpinner;
    private JDialog dialog;
    private PrinterPreviewFrame ppf;
    private JLabel label;
    private JLabel label_1;
    private JLabel label_2;
    private JLabel label_3;
    private JLabel label_4;
    private JButton sureButton;
    private JButton defaultButton;
    private JButton cancelButton;

    public PageEdgeSetup(PrinterPreviewFrame printerPreviewFrame) {
        this.ppf = printerPreviewFrame;
        this.initialize();
        this.localize(PrinterPreviewControl.bundle());
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    private void initialize() {
        this.dialog = new JDialog();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        borderLayout.setHgap(10);
        this.dialog.getContentPane().setLayout(borderLayout);
        this.dialog.setDefaultCloseOperation(2);
        this.label_4 = new JLabel();
        this.label_4.setPreferredSize(new Dimension(0, 40));
        this.dialog.getContentPane().add((Component)this.label_4, "North");
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 4);
        gridLayout.setVgap(10);
        gridLayout.setHgap(10);
        jPanel.setLayout(gridLayout);
        this.dialog.getContentPane().add(jPanel);
        this.label = new JLabel();
        this.label.setPreferredSize(new Dimension(0, 0));
        jPanel.add(this.label);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.ppf.getPageEdgeSpace().x, 0, 100, 1);
        this.leftSpinner = new JSpinner(spinnerNumberModel);
        jPanel.add(this.leftSpinner);
        this.label_1 = new JLabel();
        jPanel.add(this.label_1);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.ppf.getPageEdgeSpace().y, 0, 100, 1);
        this.rightSpinner = new JSpinner(spinnerNumberModel2);
        jPanel.add(this.rightSpinner);
        this.label_2 = new JLabel();
        jPanel.add(this.label_2);
        SpinnerNumberModel spinnerNumberModel3 = new SpinnerNumberModel(this.ppf.getPageEdgeSpace().width, 0, 100, 1);
        this.upSpinner = new JSpinner(spinnerNumberModel3);
        jPanel.add(this.upSpinner);
        this.label_3 = new JLabel();
        jPanel.add(this.label_3);
        SpinnerNumberModel spinnerNumberModel4 = new SpinnerNumberModel(this.ppf.getPageEdgeSpace().height, 0, 100, 1);
        this.downSpinner = new JSpinner(spinnerNumberModel4);
        jPanel.add(this.downSpinner);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(0, 40));
        this.dialog.getContentPane().add((Component)jPanel2, "South");
        this.sureButton = new JButton();
        jPanel2.add(this.sureButton);
        this.sureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = new Rectangle((Integer)PageEdgeSetup.this.leftSpinner.getValue(), (Integer)PageEdgeSetup.this.rightSpinner.getValue(), (Integer)PageEdgeSetup.this.upSpinner.getValue(), (Integer)PageEdgeSetup.this.downSpinner.getValue());
                PageEdgeSetup.this.ppf.setPageEdgeSpace(rectangle);
                PageEdgeSetup.this.dialog.dispose();
            }
        });
        this.defaultButton = new JButton();
        jPanel2.add(this.defaultButton);
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageEdgeSetup.this.leftSpinner.setValue(20);
                PageEdgeSetup.this.rightSpinner.setValue(20);
                PageEdgeSetup.this.upSpinner.setValue(20);
                PageEdgeSetup.this.downSpinner.setValue(20);
            }
        });
        this.cancelButton = new JButton();
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageEdgeSetup.this.dialog.dispose();
            }
        });
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.dialog.setTitle(resourceBundle.getString(PRINT_SET_PAGE_SPACE));
        this.label.setText(resourceBundle.getString(PRINT_LEFT_SPACE));
        this.label_1.setText(resourceBundle.getString(PRINT_RIGHT_SPACE));
        this.label_2.setText(resourceBundle.getString(PRINT_UP_SPACE));
        this.label_3.setText(resourceBundle.getString(PRINT_DOWN_SPACE));
        this.label_4.setText(resourceBundle.getString(PRINT_SET_PRINT_SPACE));
        this.sureButton.setText(resourceBundle.getString("Action.OK"));
        this.defaultButton.setText(resourceBundle.getString(ACTION_DEFAULT));
        this.cancelButton.setText(resourceBundle.getString("Action.Cancel"));
    }
}

