/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.print;

import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.print.PrinterPreviewControl;
import com.owon.uppersoft.vds.print.PrinterPreviewFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class CustomScaleWindow
implements Localizable {
    public static final String ACTION_CANCEL = "Action.Cancel";
    public static final String ACTION_OK = "Action.OK";
    public static final String PRINT_USER_DEFAULT_SCALE = "Print.UserDefaultScale";
    public static final String PRINT_DEFAULT_SCALE = "Print.DefaultScale";
    private PrinterPreviewFrame ppf;
    private JSpinner spinner;
    private JDialog dialog;
    private JLabel label;
    private JButton okButton;
    private JButton cancelButton;

    public CustomScaleWindow(PrinterPreviewFrame printerPreviewFrame) {
        this.ppf = printerPreviewFrame;
        this.initialize();
        this.localize(PrinterPreviewControl.bundle());
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    private void initialize() {
        this.dialog = new JDialog();
        this.dialog.getContentPane().setLayout(new GridBagLayout());
        this.dialog.setBounds(100, 100, 353, 135);
        this.dialog.setDefaultCloseOperation(2);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.ppf.getScale() * 100.0, 0.0, 500.0, 1.0);
        this.label = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.insets = new Insets(33, 20, 6, 60);
        this.dialog.getContentPane().add((Component)this.label, gridBagConstraints);
        this.spinner = new JSpinner(spinnerNumberModel);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 16;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.ipadx = 15;
        gridBagConstraints2.insets = new Insets(32, 5, 0, 5);
        this.dialog.getContentPane().add((Component)this.spinner, gridBagConstraints2);
        JLabel jLabel = new JLabel();
        jLabel.setText("%");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 16;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.ipadx = 15;
        gridBagConstraints3.insets = new Insets(35, 0, 4, 50);
        this.dialog.getContentPane().add((Component)jLabel, gridBagConstraints3);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomScaleWindow.this.ppf.setScale(new Double(CustomScaleWindow.this.spinner.getValue().toString()) / 100.0);
                CustomScaleWindow.this.dialog.dispose();
            }
        });
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.ipadx = 60;
        gridBagConstraints4.ipady = 10;
        gridBagConstraints4.insets = new Insets(20, 20, 14, 60);
        this.dialog.add((Component)this.okButton, gridBagConstraints4);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomScaleWindow.this.dialog.dispose();
            }
        });
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.ipadx = 42;
        gridBagConstraints5.ipady = 14;
        gridBagConstraints5.insets = new Insets(18, 5, 16, 0);
        this.dialog.add((Component)this.cancelButton, gridBagConstraints5);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.dialog.setTitle(resourceBundle.getString(PRINT_DEFAULT_SCALE));
        this.label.setText(resourceBundle.getString(PRINT_USER_DEFAULT_SCALE));
        this.okButton.setText(resourceBundle.getString(ACTION_OK));
        this.cancelButton.setText(resourceBundle.getString(ACTION_CANCEL));
    }
}

