/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.machine;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.source.usb.USBPortsFilter;
import com.owon.uppersoft.vds.core.comm.JobQueueDispatcher;
import com.owon.uppersoft.vds.core.tune.ICal;
import com.owon.uppersoft.vds.device.interpret.DeviceAddressTable;
import com.owon.uppersoft.vds.device.interpret.LowerTranslator;
import com.owon.uppersoft.vds.m50.LowControlManager50M;
import com.owon.uppersoft.vds.m50.PreHandler50M;
import com.owon.uppersoft.vds.m50.Submitor2_50M;
import com.owon.uppersoft.vds.m50.TinyTuneFunctionWithPhaseFine;
import com.owon.uppersoft.vds.machine.DeviceAddressTable_50M;
import com.owon.uppersoft.vds.machine.LowControlManger;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.pen.DefaultTranslator2;
import com.owon.uppersoft.vds.source.comm.PortFilterTiny;
import com.owon.uppersoft.vds.source.comm.Submitor2;
import com.owon.uppersoft.vds.source.front.AbsPreHandler;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.calibration.stuff.BaselineArg;
import com.owon.vds.calibration.stuff.CalArgTypeProvider;
import com.owon.vds.tiny.circle.GainArg;
import com.owon.vds.tiny.firm.pref.model.ArgType;
import com.owon.vds.tiny.tune.TinyTuneFunction;

public class VDS2052
extends TinyMachine {
    public static final int TB_5ns = 0;
    public static final int TB_1_4kFullScreen = 5;
    public static final int TB_5kFullScreen = 7;
    public static final int TB_50MSAMPLE = 9;
    public static final int VB_200mv = 5;
    public static final int FreqRef_125M = 125000000;
    private DeviceAddressTable table;
    public static final int dac_complementCode = 4095;

    public VDS2052() {
        this.setMaxSampleRateWhenChannelsOn(250000000);
        this.table = new DeviceAddressTable_50M();
    }

    @Override
    public DeviceAddressTable getDeviceAddressTable() {
        return this.table;
    }

    @Override
    public int saveID() {
        return 102;
    }

    @Override
    public TinyTuneFunction createTinyTuneFunction(int n, int[] nArray) {
        TinyTuneFunctionWithPhaseFine tinyTuneFunctionWithPhaseFine = new TinyTuneFunctionWithPhaseFine(n, nArray);
        return tinyTuneFunctionWithPhaseFine;
    }

    @Override
    public String name() {
        return "VDS2052";
    }

    @Override
    public boolean isSupportMultiFreqArgument() {
        return true;
    }

    @Override
    public AbsPreHandler createPreHandler(ControlManager controlManager, LowControlManger lowControlManger) {
        PreHandler50M preHandler50M = new PreHandler50M(controlManager, lowControlManger);
        return preHandler50M;
    }

    @Override
    public LowControlManger createLowControlManger(ControlManager controlManager) {
        return new LowControlManager50M(controlManager);
    }

    @Override
    public int getMultiFreqArgument(int n) {
        if (n <= 7) {
            return 2;
        }
        return 1;
    }

    @Override
    public String series() {
        return "VDS_C2";
    }

    @Override
    public boolean bandLimit() {
        return false;
    }

    @Override
    public double doFrequencyCompute(int n, int n2) {
        int n3 = 125000000;
        double d = (double)n * (double)n3 / (double)n2;
        return d;
    }

    @Override
    public double getLimitFrequency() {
        return 6.0E7;
    }

    @Override
    public int getDelayAttenuationVBIndex() {
        return 5;
    }

    @Override
    public LowerTranslator createLowerTranslator(CalArgTypeProvider calArgTypeProvider) {
        return new DefaultTranslator2(calArgTypeProvider, 4095);
    }

    @Override
    public ArgCreator getArgCreator(final CalArgTypeProvider calArgTypeProvider) {
        return new ArgCreator(){

            @Override
            public GainArg createGainArg(int n, int n2) {
                ICal iCal = calArgTypeProvider.getSimpleAdjustCMDType(ArgType.Gain);
                return new GainArg(n, n2, iCal, 4095, 100);
            }

            @Override
            public BaselineArg createBaselineArg(int n, int n2, ArgType argType) {
                int n3 = 1000;
                switch (argType) {
                    case Compensation: {
                        n3 = 500;
                    }
                    case Step: {
                        n3 = n2 == 0 ? 20 : 80;
                    }
                }
                ICal iCal = calArgTypeProvider.getSimpleAdjustCMDType(argType);
                return new BaselineArg(n, n2, iCal, 4095, n3){

                    @Override
                    protected void computeNapply(int n, int n2, int n3) {
                        if (n3 < 1) {
                            n2 >>= 2;
                        }
                        super.computeNapply(n, n2, n3);
                    }
                };
            }
        };
    }

    @Override
    public USBPortsFilter createPortFilter() {
        return new PortFilterTiny(){

            @Override
            protected String getMachineNameFromCode(int n) {
                if (n == 3) {
                    return "VDS2052";
                }
                return null;
            }
        };
    }

    @Override
    public Submitor2 createSubmitor(JobQueueDispatcher jobQueueDispatcher, LowerTranslator lowerTranslator, LowControlManger lowControlManger, ControlManager controlManager) {
        return new Submitor2_50M(jobQueueDispatcher, lowerTranslator, lowControlManger, controlManager);
    }
}

