/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.machine;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.source.usb.USBPortsFilter;
import com.owon.uppersoft.vds.core.comm.JobQueueDispatcher;
import com.owon.uppersoft.vds.core.tune.Cending;
import com.owon.uppersoft.vds.core.tune.ICal;
import com.owon.uppersoft.vds.device.interpret.DefaultTranslator;
import com.owon.uppersoft.vds.device.interpret.DeviceAddressTable;
import com.owon.uppersoft.vds.device.interpret.LowerTranslator;
import com.owon.uppersoft.vds.machine.LowControlManager20M;
import com.owon.uppersoft.vds.machine.LowControlManger;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.source.comm.PortFilterTiny;
import com.owon.uppersoft.vds.source.comm.Submitor2;
import com.owon.uppersoft.vds.source.front.AbsPreHandler;
import com.owon.uppersoft.vds.source.front.PreHandler;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.calibration.stuff.BaselineArg;
import com.owon.vds.calibration.stuff.CalArgTypeProvider;
import com.owon.vds.tiny.circle.GainArg;
import com.owon.vds.tiny.firm.pref.model.ArgType;
import com.owon.vds.tiny.firm.pref.model.TuneModel;
import com.owon.vds.tiny.tune.TinyTuneFunction;
import com.owon.vds.tiny.tune.detail.DefaultCalArgType;
import java.util.List;

public class VDS1022
extends TinyMachine {
    public static final int TB_1_4kFullScreen = 6;
    public static final int TB_5kFullScreen = 9;
    private static final int VB_200mv = 5;
    private DeviceAddressTable table;
    public static final int dac_complementCode = 4095;
    public static final int dac_defaultCode = 512;

    public VDS1022() {
        this.setMaxSampleRateWhenChannelsOn(100000000);
        this.table = new DeviceAddressTable();
    }

    @Override
    public DeviceAddressTable getDeviceAddressTable() {
        return this.table;
    }

    @Override
    public int saveID() {
        return 100;
    }

    @Override
    public boolean isSupportNetwork() {
        return false;
    }

    @Override
    public String name() {
        return "VDS1022";
    }

    @Override
    public String series() {
        return "VDS_C2";
    }

    @Override
    public boolean bandLimit() {
        return false;
    }

    @Override
    public double doFrequencyCompute(int n, int n2) {
        int n3 = 100000000;
        double d = (double)n / (double)n2 * (double)n3;
        return d;
    }

    @Override
    public double getLimitFrequency() {
        return 3.0E7;
    }

    @Override
    public int getDelayAttenuationVBIndex() {
        return 5;
    }

    @Override
    public LowerTranslator createLowerTranslator(CalArgTypeProvider calArgTypeProvider) {
        return new DefaultTranslator(calArgTypeProvider);
    }

    @Override
    public TinyTuneFunction createTinyTuneFunction(int n, int[] nArray) {
        TinyTuneFunction tinyTuneFunction = new TinyTuneFunction(n, nArray){

            @Override
            protected TuneModel createTuneModel(int n, int n2) {
                return new TuneModel(n, n2){

                    @Override
                    protected void fillArgTypeList(List<DefaultCalArgType> list, int n, int n2) {
                        DefaultCalArgType defaultCalArgType = new DefaultCalArgType(ArgType.Gain.ordinal(), Cending.ascending, n, n2);
                        list.add(defaultCalArgType);
                        DefaultCalArgType defaultCalArgType2 = new DefaultCalArgType(ArgType.Step.ordinal(), Cending.ascending, n, n2);
                        list.add(defaultCalArgType2);
                        DefaultCalArgType defaultCalArgType3 = new DefaultCalArgType(ArgType.Compensation.ordinal(), Cending.descending, n, n2);
                        list.add(defaultCalArgType3);
                    }
                };
            }
        };
        return tinyTuneFunction;
    }

    @Override
    public ArgCreator getArgCreator(final CalArgTypeProvider calArgTypeProvider) {
        return new ArgCreator(){

            @Override
            public GainArg createGainArg(int n, int n2) {
                ICal iCal = calArgTypeProvider.getSimpleAdjustCMDType(ArgType.Gain);
                return new GainArg(n, n2, iCal, 99999, 800){

                    @Override
                    protected void computeNapply(int n, int n2, int n3) {
                        super.computeNapply(n, n2 >>= 1, n3);
                    }
                };
            }

            @Override
            public BaselineArg createBaselineArg(int n, int n2, ArgType argType) {
                ICal iCal = calArgTypeProvider.getSimpleAdjustCMDType(argType);
                BaselineArg baselineArg = null;
                int n3 = 512;
                switch (argType) {
                    case Compensation: {
                        n3 = 630;
                        baselineArg = new BaselineArg(n, n2, iCal, 4095, n3);
                        break;
                    }
                    case Step: {
                        n3 = 111;
                        baselineArg = new BaselineArg(n, n2, iCal, 4095, n3);
                    }
                }
                return baselineArg;
            }
        };
    }

    @Override
    public USBPortsFilter createPortFilter() {
        return new PortFilterTiny(){

            @Override
            protected String getMachineNameFromCode(int n) {
                if (n == 1) {
                    return "VDS1022";
                }
                return null;
            }
        };
    }

    @Override
    public Submitor2 createSubmitor(JobQueueDispatcher jobQueueDispatcher, LowerTranslator lowerTranslator, LowControlManger lowControlManger, ControlManager controlManager) {
        return new Submitor2(jobQueueDispatcher, lowerTranslator, lowControlManger, controlManager);
    }

    @Override
    public AbsPreHandler createPreHandler(ControlManager controlManager, LowControlManger lowControlManger) {
        return new PreHandler(controlManager, lowControlManger);
    }

    @Override
    public LowControlManger createLowControlManger(ControlManager controlManager) {
        return new LowControlManager20M(controlManager);
    }
}

