/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.machine;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Principle;
import com.owon.uppersoft.dso.global.WorkBenchTiny;
import com.owon.uppersoft.dso.model.trigger.condition.TrgCondition;
import com.owon.uppersoft.vds.core.comm.JobQueueDispatcher;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.tune.ICal;
import com.owon.uppersoft.vds.device.interpret.LowerTranslator;
import com.owon.uppersoft.vds.machine.LowControlManger;
import com.owon.uppersoft.vds.machine.MachineInfo_Tiny;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.machine.VDS1022;
import com.owon.uppersoft.vds.machine.VDS2052;
import com.owon.uppersoft.vds.source.comm.Submitor2;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.vds.calibration.stuff.CalArgTypeProvider;
import com.owon.vds.tiny.firm.pref.PrefControl;
import com.owon.vds.tiny.firm.pref.model.ArgType;
import com.owon.vds.tiny.tune.TinyTuneFunction;
import java.awt.Window;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PrincipleTiny
implements Principle {
    private TinyTuneFunction tune;
    private TinyMachine mt;
    private CalArgTypeProvider catp;
    private HashMap<Integer, MachineType> machTypIdMap = new HashMap();
    private MachineInfo_Tiny machine;
    private Submitor2 sb;
    private LowControlManger lcm;

    public PrincipleTiny(String string) {
        this.machTypIdMap.put(100, new VDS1022());
        this.machTypIdMap.put(102, new VDS2052());
        this.machineChange(string);
        this.catp = new CalArgTypeProvider(){

            @Override
            public ICal getSimpleAdjustCMDType(ArgType argType) {
                return PrincipleTiny.this.tune.getTuneModel().getSimpleAdjustCMDType(argType.ordinal());
            }
        };
    }

    public CalArgTypeProvider getCalArgTypeProvider() {
        return this.catp;
    }

    public TinyTuneFunction getTuneFunction() {
        return this.tune;
    }

    @Override
    public String getConfigurationDirectory() {
        return WorkBenchTiny.CONFIG_DIR;
    }

    @Override
    public String getMachineTypeName(int n) {
        return this.machTypIdMap.get(n).name();
    }

    @Override
    public int getMachineID(String string) {
        Iterator<Map.Entry<Integer, MachineType>> iterator = this.machTypIdMap.entrySet().iterator();
        while (iterator.hasNext()) {
            MachineType machineType = iterator.next().getValue();
            if (!machineType.name().equals(string)) continue;
            return machineType.saveID();
        }
        return -1;
    }

    @Override
    public TinyMachine getMachineType() {
        return this.mt;
    }

    public void machineChange(String string) {
        this.machine = new MachineInfo_Tiny(MachineInfo_Tiny.class.getResourceAsStream("/com/owon/uppersoft/dso/model/machine/params/" + string + ".txt"));
        TrgCondition.resumeDefaultSet();
        if (string.startsWith("VDS1022")) {
            this.mt = new VDS1022();
        } else if (string.startsWith("VDS2052")) {
            this.mt = new VDS2052();
            TrgCondition.resumeSet2();
        }
        int n = this.machine.getChannelNumbers();
        int[] nArray = this.machine.intVOLTAGE[0];
        this.tune = this.mt.createTinyTuneFunction(n, nArray);
    }

    @Override
    public void prepareTuneFunction(Pref pref) {
    }

    @Override
    public void openTuneDialog(Window window, PropertyChangeSupport propertyChangeSupport) {
        this.tune.open(window);
    }

    @Override
    public void persist(Pref pref) {
        this.tune.persist(pref);
    }

    @Override
    public MachineInfo_Tiny getMachine() {
        return this.machine;
    }

    private void createLowControlManger(ControlManager controlManager) {
        if (this.lcm == null) {
            this.lcm = this.mt.createLowControlManger(controlManager);
        }
    }

    public PrefControl getPrefControl() {
        return this.tune.getDefaultPrefControl();
    }

    public LowControlManger getLowControlManger(ControlManager controlManager) {
        this.createLowControlManger(controlManager);
        return this.lcm;
    }

    @Override
    public Submitable createSubmitor(JobQueueDispatcher jobQueueDispatcher, ControlManager controlManager) {
        this.createLowControlManger(controlManager);
        LowerTranslator lowerTranslator = this.mt.createLowerTranslator(this.catp);
        this.sb = this.mt.createSubmitor(jobQueueDispatcher, lowerTranslator, this.lcm, controlManager);
        return this.sb;
    }

    public String getMachineSeries(int n) {
        return this.machTypIdMap.get(n).series();
    }

    @Override
    public boolean isSameSeries(int n) {
        String string = this.mt.series();
        String string2 = this.getMachineSeries(n);
        return string.equals(string2);
    }
}

