/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.machine;

import com.owon.uppersoft.vds.core.machine.AbstractMachineInfo;
import com.owon.uppersoft.vds.core.sample.SampleRate;
import com.owon.uppersoft.vds.util.format.ParseUtil;
import com.owon.uppersoft.vds.util.ui.ContextFileChooser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class MachineInfo_Tiny
extends AbstractMachineInfo {
    private static final String TINY_SEPERATE_FREQ = "Tiny_SeperateFreq";
    protected int[] seperateFreq;
    public static final int FFT_2048_UsePart = 8;
    public static final int[] SeparatePattern = new int[]{2, 4, 8};

    public MachineInfo_Tiny(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    protected void otherHandle(String string, BufferedReader bufferedReader) throws IOException {
        if (string.equalsIgnoreCase(TINY_SEPERATE_FREQ)) {
            StringTokenizer stringTokenizer = this.nextStringTokenizer(bufferedReader);
            this.seperateFreq = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.seperateFreq[n] = ParseUtil.translateInt(stringTokenizer.nextToken());
                ++n;
            }
        }
    }

    @Override
    public int fftAvailablePoints(int n) {
        int n2 = n;
        if (n2 >= 8) {
            return 4096;
        }
        return 8 * (int)Math.pow(2.0, n2);
    }

    @Override
    protected void computeChannelMaxSampleRate() {
        this.channelMaxSampleRate = new SampleRate[this.sampling_configuration_count];
        for (int i = 0; i < this.sampling_configuration_count; ++i) {
            this.channelMaxSampleRate[i] = this.getADCSampleRate();
        }
    }

    @Override
    public int getChannelSampleType(int n) {
        return 0;
    }

    @Override
    public int getDMIndexFromLength(int n) {
        int n2 = super.getDMIndexFromLength(n);
        if (n2 < 0 && n == 5100) {
            return 0;
        }
        return n2;
    }

    public int getSeperateFreq(int n) {
        if (n < 0 || n >= this.seperateFreq.length) {
            return -1;
        }
        return this.seperateFreq[n];
    }

    public int getFFTSeperateFreq(int n) {
        return this.getSeperateFreq(n);
    }

    protected void computeSeperateFreq() {
        int n = this.SampleRates.length;
        int n2 = this.SampleRates[0].length;
        System.err.println("x, y: " + n + ", " + n2);
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            SampleRate[] sampleRateArray = this.SampleRates[i];
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                SampleRate sampleRate = this.channelMaxSampleRate[i];
                nArray2[j] = sampleRate.getBDValue_Hz().divide(sampleRateArray[j].getBDValue_Hz()).intValue();
                System.err.print(nArray2[j] + ", ");
            }
        }
        System.err.println();
    }

    @Override
    public final int getPos0HalfRange(int n) {
        return 250;
    }

    public static void main(String[] stringArray) {
        MachineInfo_Tiny machineInfo_Tiny = new MachineInfo_Tiny(MachineInfo_Tiny.class.getResourceAsStream("/com/owon/uppersoft/dso/model/machine/params/VDS2052ONE.txt"));
        machineInfo_Tiny.output_SampleRates();
        ContextFileChooser contextFileChooser = new ContextFileChooser();
        File file = contextFileChooser.save();
        if (file != null) {
            machineInfo_Tiny.output_CnDRates(file);
        }
    }
}

