/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.machine;

import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.DeepMemoryControl;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.trigger.PulseTrigger;
import com.owon.uppersoft.dso.model.trigger.SlopeTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.comm.BufferredSourceManager;
import com.owon.uppersoft.vds.device.interpret.util.CBitSet;
import com.owon.uppersoft.vds.machine.MachineInfo_Tiny;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.source.comm.ext.IntObject;

public abstract class LowControlManger {
    protected ControlManager cm;
    protected WaveFormInfoControl wfic;
    public static final int[] Tiny_Coupling = new int[]{1, 0, 2};
    public static final int ChannelSampleConfig = 0;
    private int remainHtp = 0;

    public LowControlManger(ControlManager controlManager) {
        this.cm = controlManager;
        this.wfic = controlManager.getWaveFormInfoControl();
    }

    public int getFFTSeperateFreq(int n) {
        return this.getMachineInfo().getFFTSeperateFreq(n);
    }

    public abstract int getHTPWithoutCompress(int var1, IntObject var2);

    public int getSeperateFreq(int n) {
        return this.getMachineInfo().getSeperateFreq(n);
    }

    public MachineInfo_Tiny getMachineInfo() {
        return (MachineInfo_Tiny)this.cm.getMachineInfo();
    }

    public TinyMachine getMachineType() {
        return (TinyMachine)this.cm.getMachine();
    }

    public int getDeepMemoryIndex() {
        return this.cm.getDeepMemoryControl().getDeepIdx();
    }

    public int getDeepMemoryDataLen() {
        return this.cm.getDeepMemoryControl().getDeepDataLen() + 50 + 50;
    }

    public boolean isFFTOn() {
        return this.cm.getFFTControl().isFFTon();
    }

    public TimeControl getTimeControl() {
        return this.cm.getTimeControl();
    }

    protected DeepMemoryControl getDeepMemoryControl() {
        return this.cm.getDeepMemoryControl();
    }

    public int getLowMachineChannels() {
        return this.cm.getWaveFormInfoControl().getLowMachineChannels();
    }

    public int getChannelPos0(int n) {
        ChannelInfo channelInfo = this.wfic.getWaveFormInfo((int)n).ci;
        return channelInfo.getPos0();
    }

    public int getChannelVBIndex(int n) {
        ChannelInfo channelInfo = this.wfic.getWaveFormInfo((int)n).ci;
        return channelInfo.getVoltbaseIndex();
    }

    public int getChannelsFlag() {
        return this.wfic.getWaveFormFlag();
    }

    public int getChannelsSetFlag(int n, int n2) {
        int n3 = this.getMachineType().getDelayAttenuationVBIndex();
        ChannelInfo channelInfo = this.wfic.getWaveFormInfo((int)n).ci;
        return LowControlManger.getWaveFormSetFlag(channelInfo, n3, n2);
    }

    public static final byte getWaveFormSetFlag(ChannelInfo channelInfo, int n, int n2) {
        CBitSet cBitSet = new CBitSet(8);
        cBitSet.clear();
        cBitSet.set1(channelInfo.isOn(), 7);
        int n3 = Tiny_Coupling[channelInfo.getCouplingIdx()];
        cBitSet.setN(n3, 5, 6);
        cBitSet.set1(0, 4);
        cBitSet.setN(0, 2, 3);
        int n4 = n2;
        if (n4 >= 0 && n4 <= n) {
            cBitSet.set1(0, 1);
        } else {
            cBitSet.set1(1, 1);
        }
        cBitSet.set1(0, 0);
        return (byte)cBitSet.getValue();
    }

    public boolean isSlowMoveTimebase(int n) {
        return this.cm.getCoreControl().getTimeConfProvider().isOnSlowMoveTimebase(n);
    }

    public boolean isPulse_Equal(int n) {
        return PulseTrigger.isCondition_Equal(n);
    }

    public boolean isSlope_Equal(int n) {
        return SlopeTrigger.isCondition_Equal(n);
    }

    public int getThredsholdPairArg(int n) {
        TriggerSet triggerSet = this.cm.getTriggerControl().getTriggerSetOrNull(n);
        if (triggerSet == null) {
            return -1;
        }
        int n2 = triggerSet.slope.c_getLowest() & 0xFF;
        int n3 = triggerSet.slope.c_getUppest() & 0xFF;
        return n2 << 8 | n3;
    }

    public synchronized int getRemainHtp() {
        return this.remainHtp;
    }

    public synchronized void commitRemainHtp(int n) {
        this.remainHtp = n;
    }

    public ControlApps getControlApps() {
        return Platform.getControlApps();
    }

    public BufferredSourceManager getSourceManager() {
        return this.cm.sourceManager;
    }

    public int getTrgChannles() {
        TriggerControl triggerControl = this.cm.getTriggerControl();
        int n = triggerControl.getChannelsNumber();
        int n2 = 0;
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        for (int i = 0; i < n; ++i) {
            n2 |= 1 << i;
        }
        return n2;
    }

    public boolean alsoSupportPeakDetect() {
        return this.cm.isPeakDetectWork();
    }
}

