/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.m50;

import com.owon.uppersoft.vds.core.wf.rt.PlugInfo;
import com.owon.uppersoft.vds.device.interpolate.TinyPlugHelper;
import com.owon.uppersoft.vds.device.interpolate.dynamic.DynamicPlugUtil;
import com.owon.uppersoft.vds.device.interpolate.dynamic.SineTables;
import java.nio.ByteBuffer;

public class DynamicPlugHelper50M
extends TinyPlugHelper {
    private ByteBuffer[] temp;
    private ByteBuffer[] trgs;

    public DynamicPlugHelper50M(int n) {
        this.temp = new ByteBuffer[n];
        this.trgs = new ByteBuffer[n];
    }

    private ByteBuffer allocate(boolean bl, int n, int n2) {
        ByteBuffer[] byteBufferArray;
        ByteBuffer[] byteBufferArray2 = byteBufferArray = bl ? this.trgs : this.temp;
        if (n2 < 0 || n2 >= byteBufferArray.length) {
            System.err.println("err DynamicPlugHelper allocate chl: " + n2 + ", len: " + n + ", forTrg: " + bl);
            return null;
        }
        ByteBuffer byteBuffer = byteBufferArray[n2];
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(6000);
        }
        byteBuffer.position(0);
        byteBuffer.limit(n);
        return byteBuffer;
    }

    @Override
    protected ByteBuffer plugJob(int n, ByteBuffer byteBuffer, PlugInfo plugInfo, boolean bl, int n2) {
        ByteBuffer byteBuffer2 = null;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        int n5 = n4 - n3;
        byte[] byArray = byteBuffer.array();
        int n6 = (int)this.getPlugRate(n);
        this.logln("plugrate: " + n6);
        int n7 = n5 * n6;
        ByteBuffer byteBuffer3 = this.allocate(bl, n7, n2);
        byte[] byArray2 = byteBuffer3.array();
        int[][] nArray = SineTables.sincTabSp(n6);
        if (nArray == null) {
            return this.doLineJob(n, n6, byteBuffer, plugInfo);
        }
        DynamicPlugUtil.sinc_interps(byArray, n3, n4, byArray2, n6, nArray);
        byteBuffer2 = ByteBuffer.wrap(byArray2, 0, n7);
        plugInfo.sinePlugRate = n6;
        plugInfo.linearPlugRate = 1.0;
        return byteBuffer2;
    }

    private ByteBuffer doLineJob(int n, int n2, ByteBuffer byteBuffer, PlugInfo plugInfo) {
        ByteBuffer byteBuffer2 = DynamicPlugHelper50M.lineplug(byteBuffer, n2);
        plugInfo.sinePlugRate = 1;
        plugInfo.linearPlugRate = n2;
        return byteBuffer2;
    }

    @Override
    public double getPlugRate(int n) {
        switch (n) {
            case 500: {
                return 2.0;
            }
            case 250: {
                return 4.0;
            }
            case 100: {
                return 10.0;
            }
            case 50: {
                return 20.0;
            }
            case 25: {
                return 40.0;
            }
        }
        return -1.0;
    }
}

