/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.function.rule;

import com.owon.uppersoft.vds.core.aspect.help.AreaImageHelper;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.function.rule.PFRuleUtil;
import com.owon.uppersoft.vds.function.rule.RuleDetail;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class PFRuleControl {
    public static final int AREA_WIDTH = 1000;
    public static final int AREA_WIDTH_BLOCK_PIXES = 50;
    public static final int PIXELS_PER_DIV = 25;
    public static final int PASS = 1;
    public static final int FAIL = 0;
    public static final int None = -1;
    private boolean enable_rule = false;
    private boolean prepared_rule = false;
    private int R_verticalSet = 10;
    private int R_horizontalSet = 10;
    private int data_num;
    private int[] adc_min;
    private int[] adc_max;
    private int[] rule_max;
    private int[] rule_min;
    private int result;
    private RuleDetail rd;
    public static final int ScreenEndsOffsetPixels = 20;
    public static final int ScreenPixels = 1000;
    public static final int RuleCheckWidthPixels = 960;
    private boolean resetBI = false;
    private BufferedImage rule_bi;

    public PFRuleControl(RuleDetail ruleDetail) {
        this.rd = ruleDetail;
    }

    public int getResult() {
        return this.result;
    }

    public void resetRusult() {
        this.result = -1;
    }

    public void receiveData(ComplexBuffer complexBuffer, boolean bl, int n) {
        if (!this.enable_rule) {
            return;
        }
        this.resetRusult();
        IntBuffer intBuffer = complexBuffer.ib;
        ByteBuffer byteBuffer = complexBuffer.bb;
        boolean bl2 = complexBuffer.isByteArray;
        if (this.prepared_rule) {
            if (bl) {
                this.result = bl2 ? this.checkRulePoints(byteBuffer, this.rule_min, this.rule_max, this.data_num) : this.checkRulePoints(intBuffer, this.rule_min, this.rule_max, this.data_num);
            }
        } else {
            this.resetRulePoints();
            this.data_num = bl2 ? PFRuleUtil.createRulePoints(byteBuffer, this.adc_min, this.adc_max, this.rule_min, this.rule_max, this.R_horizontalSet, this.R_verticalSet) : PFRuleUtil.createRulePoints(intBuffer, this.adc_min, this.adc_max, this.rule_min, this.rule_max, this.R_horizontalSet, this.R_verticalSet);
            this.prepared_rule = true;
            this.resetBI = true;
        }
    }

    public boolean isRulePrepared() {
        return this.prepared_rule;
    }

    public double getHor() {
        return this.rd.hor;
    }

    public double getVer() {
        return this.rd.ver;
    }

    public int getRuleChannel() {
        return this.rd.chl;
    }

    public RuleDetail getRuleDetail() {
        return this.rd;
    }

    public void configRule(int n, double d, double d2) {
        this.rd.set(n, d, d2);
        if (this.enable_rule) {
            this.prepared_rule = false;
        }
    }

    public boolean isRuleEnable() {
        return this.enable_rule;
    }

    protected void trimBuffer(Buffer buffer) {
        int n = buffer.position();
        int n2 = buffer.limit();
        int n3 = n2 - n;
        double d = 0.96 * (double)n3;
        int n4 = (int)Math.round(d);
        if (n4 > 0 && n4 < n3) {
            int n5;
            int n6 = n4 >> 1;
            int n7 = n + n2 >> 1;
            n = n5 = n7 - n6;
            n3 = n4;
            n2 = n + n3;
            buffer.position(n);
            buffer.limit(n2);
        }
    }

    private void resetRulePoints() {
        int n = 1000;
        if (this.adc_min == null || this.adc_min.length != n) {
            this.prepareRulePoints(n);
        }
        this.prepareADCPoints(n);
        this.R_horizontalSet = (int)(this.rd.hor * 50.0);
        this.R_verticalSet = (int)(this.rd.ver * 25.0);
    }

    public void enableRule() {
        this.enable_rule = true;
    }

    public void disableRule() {
        this.enable_rule = false;
        this.prepared_rule = false;
        this.adc_min = null;
        this.adc_max = null;
        this.rule_max = null;
        this.rule_min = null;
        this.rule_bi = null;
    }

    private void prepareRulePoints(int n) {
        this.adc_min = new int[n];
        this.adc_max = new int[n];
        this.rule_max = new int[n];
        this.rule_min = new int[n];
    }

    private void prepareADCPoints(int n) {
        for (int i = 0; i < n; ++i) {
            this.adc_min[i] = 255;
            this.adc_max[i] = -255;
        }
    }

    private int checkRulePoints(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = byteBuffer.limit();
        int n4 = n3 - n2;
        byte[] byArray = byteBuffer.array();
        int n5 = 0;
        double d = 0.0;
        double d2 = (double)n / (double)n4;
        int n6 = 1;
        for (n2 = byteBuffer.position(); n2 < n3; ++n2) {
            byte by;
            if (n5 >= 20 && n5 <= 980 && ((by = byArray[n2]) < nArray[n5] || by > nArray2[n5])) {
                n6 = 0;
                break;
            }
            n5 = (int)(d += d2);
        }
        return n6;
    }

    private int checkRulePoints(IntBuffer intBuffer, int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = intBuffer.limit();
        int n4 = n3 - n2;
        int[] nArray3 = intBuffer.array();
        int n5 = 0;
        double d = 0.0;
        double d2 = (double)n / (double)n4;
        int n6 = 1;
        for (n2 = intBuffer.position(); n2 < n3; ++n2) {
            int n7;
            if (n5 >= 20 && n5 <= 980 && ((n7 = nArray3[n2]) < nArray[n5] || n7 > nArray2[n5])) {
                n6 = 0;
                break;
            }
            n5 = (int)(d += d2);
        }
        return n6;
    }

    public void adjustView() {
        this.resetBI = true;
    }

    public void paintRulePoints(Graphics2D graphics2D, boolean bl, Rectangle rectangle, AreaImageHelper areaImageHelper) {
        boolean bl2;
        boolean bl3 = bl2 = this.enable_rule && this.prepared_rule;
        if (!bl2) {
            return;
        }
        if (this.rule_bi == null) {
            this.rule_bi = areaImageHelper.createARGBScreenBufferedImage();
            this.resetBI = true;
        }
        if (this.resetBI) {
            areaImageHelper.resetARGBBufferImage(this.rule_bi);
            PFRuleUtil.paintRuleArea(this.rule_bi.createGraphics(), bl, rectangle, this.rule_min, this.rule_max, this.data_num, 20, 960);
            this.resetBI = false;
        }
        Point point = areaImageHelper.getDrawSize();
        int n = point.x;
        int n2 = point.y;
        graphics2D.drawImage(this.rule_bi, 0, 0, n, n2, 0, 0, n, n2, null);
    }

    public static class ComplexBuffer {
        public boolean isByteArray;
        public IntBuffer ib;
        public ByteBuffer bb;
    }
}

